/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.algebra.AlgebraFamily;
import groove.algebra.Operation;
import groove.algebra.Operator;
import groove.grammar.host.HostElement;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.OperatorNode;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.LookupEntry;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSimpleMatch;
import java.util.ArrayList;
import java.util.List;

public class DataOperatorChecker
extends ReteNetworkNode {
    private RuleElement[] pattern;
    private Operator operator;
    private Operation operation;
    private boolean dataCreator = false;
    private List<LookupEntry> argumentLocator = new ArrayList<LookupEntry>();

    public DataOperatorChecker(ReteNetwork network, ReteNetwork.ReteStaticMapping antecedent, OperatorNode opNode) {
        super(network);
        assert (antecedent.getLhsNodes().containsAll(opNode.getArguments()));
        this.operator = opNode.getOperator();
        this.operation = AlgebraFamily.getInstance().getOperation(this.operator);
        this.dataCreator = !antecedent.getLhsNodes().contains(opNode.getTarget()) && opNode.getTarget().getConstant() == null;
        this.addAntecedent(antecedent.getNNode());
        antecedent.getNNode().addSuccessor(this);
        this.adjustPattern(opNode);
        for (VariableNode vn : opNode.getArguments()) {
            this.argumentLocator.add(antecedent.locateNode(vn));
        }
    }

    private void adjustPattern(OperatorNode opNode) {
        ReteNetworkNode antecedent = this.getAntecedents().get(0);
        RuleElement[] antecedentPattern = antecedent.getPattern();
        this.pattern = new RuleElement[antecedent.getPattern().length + 1];
        int i = 0;
        while (i < antecedentPattern.length) {
            this.pattern[i] = antecedentPattern[i];
            ++i;
        }
        this.pattern[this.pattern.length - 1] = opNode.getTarget();
    }

    public boolean isDataCreator() {
        return this.dataCreator;
    }

    @Override
    public int demandOneMatch() {
        return 0;
    }

    @Override
    public boolean demandUpdate() {
        return false;
    }

    @Override
    public RuleElement[] getPattern() {
        return this.pattern;
    }

    @Override
    public int size() {
        return this.pattern.length;
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch subgraph) {
        Object[] matchUnits = subgraph.getAllUnits();
        ArrayList<Object> arguments = new ArrayList<Object>();
        int i = 0;
        while (i < this.argumentLocator.size()) {
            LookupEntry entry = this.argumentLocator.get(i);
            ValueNode vn = (ValueNode)entry.lookup(matchUnits);
            arguments.add(vn.getValue());
            ++i;
        }
        Object outcome = this.operation.apply(arguments);
        VariableNode opResultVarNode = (VariableNode)this.pattern[this.pattern.length - 1];
        ValueNode resultValueNode = null;
        boolean passDown = false;
        if (this.isDataCreator()) {
            passDown = true;
            resultValueNode = this.getOwner().getHostFactory().createValueNode(this.operation.getResultAlgebra(), outcome);
        } else if (opResultVarNode.getConstant() != null) {
            resultValueNode = this.getOwner().getHostFactory().createValueNode(this.operation.getResultAlgebra(), outcome);
            passDown = this.operation.getResultAlgebra().getSymbol(outcome).equals(opResultVarNode.getConstant().getSymbol());
        } else {
            LookupEntry entry = this.getAntecedents().get(0).getPatternLookupTable().getNode((RuleNode)this.pattern[this.pattern.length - 1]);
            ValueNode n = (ValueNode)entry.lookup(matchUnits);
            if (n.getValue().equals(outcome)) {
                resultValueNode = n;
                passDown = true;
            }
        }
        if (passDown) {
            ReteSimpleMatch m = new ReteSimpleMatch((ReteNetworkNode)this, this.getOwner().isInjective(), subgraph, new HostElement[]{resultValueNode});
            this.passDownMatchToSuccessors(m);
        }
    }

    @Override
    public boolean equals(ReteNetworkNode node) {
        return this == node;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("- Data Operator Checker%s\n", this.isDataCreator() ? "(creator)" : ""));
        sb.append(String.format("- Operator - %s\n", this.operator.toString()));
        sb.append("---  Pattern-\n");
        int i = 0;
        while (i < this.pattern.length) {
            sb.append(":--- " + i + " -" + this.pattern[i].toString() + "\n");
            ++i;
        }
        i = 0;
        while (i < this.argumentLocator.size()) {
            LookupEntry entry = this.argumentLocator.get(i);
            if (entry.getRole() != LookupEntry.Role.NODE) {
                sb.append(String.format("-- argument[%d]=element[%d]%s\n", i, entry.getPos(), entry.getRole() == LookupEntry.Role.SOURCE ? ".source" : ".target"));
            } else {
                sb.append(String.format("-- argument[%d]=element[%d]\n", i, entry.getPos()));
            }
            ++i;
        }
        return sb.toString();
    }
}

