/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.Condition;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostElement;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.graph.NodeComparator;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.CompositeConditionChecker;
import groove.match.rete.DominoEventListener;
import groove.match.rete.QuantifierCountChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSimpleMatch;
import groove.match.rete.ReteStateSubscriber;
import groove.util.collect.FilterIterator;
import groove.util.collect.HashBag;
import groove.util.collect.TreeHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConditionChecker
extends ReteNetworkNode
implements ReteStateSubscriber,
DominoEventListener {
    protected RuleElement[] pattern;
    protected SearchTree conflictSetSearchTree = null;
    protected Set<ReteSimpleMatch> conflictSet = new HashSet<ReteSimpleMatch>();
    protected HashBag<ReteSimpleMatch> inhibitionMap = new HashBag();
    protected Condition condition;
    protected ConditionChecker parent;
    protected List<ConditionChecker> subConditionCheckers;
    protected boolean hasNacSubconditions = false;
    protected QuantifierCountChecker countCheckerNode = null;
    protected boolean notifyParent = false;
    private Set<ReteSimpleMatch> oneEmptyMatch;

    public ConditionChecker(ReteNetwork network, Condition c, ConditionChecker parentConditionChecker, ReteNetwork.ReteStaticMapping antecedent) {
        super(network);
        this.condition = c;
        this.getOwner().getState().subscribe(this);
        this.parent = parentConditionChecker;
        this.makeRootSearchOrder(c);
        this.subConditionCheckers = new ArrayList<ConditionChecker>();
        if (this.parent != null) {
            this.parent.addSubConditionChecker(this);
        }
        this.connectToAntecedent(antecedent);
        this.oneEmptyMatch = Collections.singleton(new ReteSimpleMatch(this, false));
    }

    private void makeRootSearchOrder(Condition c) {
        if (!c.getRoot().isEmpty()) {
            ArrayList<RuleNode> nodes = new ArrayList<RuleNode>();
            nodes.addAll(c.getRoot().nodeSet());
            Collections.sort(nodes, NodeComparator.instance());
            this.conflictSetSearchTree = new SearchTree(nodes);
        }
    }

    private void connectToAntecedent(ReteNetwork.ReteStaticMapping antecedent) {
        if (antecedent != null) {
            this.addAntecedent(antecedent.getNNode());
            antecedent.getNNode().addSuccessor(this);
            this.pattern = Arrays.copyOf(antecedent.getElements(), antecedent.getElements().length);
        } else {
            this.pattern = new RuleElement[0];
        }
    }

    private void addSubConditionChecker(ConditionChecker cc) {
        if (!this.subConditionCheckers.contains(cc)) {
            this.subConditionCheckers.add(cc);
            if (cc instanceof CompositeConditionChecker) {
                this.hasNacSubconditions = true;
            }
            if (this.condition.getCountNode() != null) {
                cc.setNotifyParent(true);
            }
        }
    }

    public List<ConditionChecker> getSubConditionCheckers() {
        return this.subConditionCheckers;
    }

    public boolean equals(Object node) {
        return node != null && node instanceof ConditionChecker && (this == (ConditionChecker)node || this.condition.equals(((ConditionChecker)node).condition));
    }

    public Condition getCondition() {
        return this.condition;
    }

    public ConditionChecker getParent() {
        return this.parent;
    }

    @Override
    public int size() {
        assert (this.getAntecedents().size() == 1);
        return this.getAntecedents().iterator().next().size();
    }

    public Set<ReteSimpleMatch> getConflictSet() {
        Set<ReteSimpleMatch> cs;
        assert (this.conflictSetSearchTree == null);
        this.demandUpdate();
        Set<ReteSimpleMatch> result = cs = this.isEmpty() ? this.oneEmptyMatch : this.conflictSet;
        if (!this.inhibitionMap.isEmpty() && cs.size() > 0) {
            result = new TreeHashSet<ReteSimpleMatch>();
            for (ReteSimpleMatch m : cs) {
                if (this.isInhibited(m)) continue;
                result.add(m);
            }
        }
        return result;
    }

    protected boolean isInhibited(AbstractReteMatch m) {
        boolean result = this.inhibitionMap.contains(m);
        return result;
    }

    public boolean hasNacs() {
        return this.hasNacSubconditions;
    }

    public Iterator<ReteSimpleMatch> getConflictSetIterator() {
        this.demandUpdate();
        Iterator<ReteSimpleMatch> result = this.isEmpty() ? (this.inhibitionMap.isEmpty() ? this.oneEmptyMatch.iterator() : this.getConflictSet().iterator()) : (!this.inhibitionMap.isEmpty() && this.conflictSet.size() > 0 ? new FilterIterator<ReteSimpleMatch>(this.conflictSet.iterator()){

            @Override
            protected boolean approves(Object obj) {
                AbstractReteMatch m = (AbstractReteMatch)obj;
                return !ConditionChecker.this.isInhibited(m);
            }
        } : this.conflictSet.iterator());
        return result;
    }

    public Iterator<ReteSimpleMatch> getConflictSetIterator(RuleToHostMap anchorMap) {
        this.demandUpdate();
        Iterator<ReteSimpleMatch> result = this.isEmpty() ? this.oneEmptyMatch.iterator() : (!this.inhibitionMap.isEmpty() ? (this.conflictSetSearchTree != null ? new FilterIterator<ReteSimpleMatch>(anchorMap != null ? this.conflictSetSearchTree.getStorageFor(anchorMap).iterator() : this.getConflictSet().iterator()){

            @Override
            protected boolean approves(Object obj) {
                return !ConditionChecker.this.isInhibited((AbstractReteMatch)obj);
            }
        } : new FilterIterator<ReteSimpleMatch>(this.getConflictSet().iterator(), anchorMap){
            RuleToHostMap anchor;
            {
                this.anchor = ruleToHostMap;
            }

            @Override
            protected boolean approves(Object obj) {
                AbstractReteMatch m = (AbstractReteMatch)obj;
                return !ConditionChecker.this.isInhibited((AbstractReteMatch)obj) && m.conformsWith(this.anchor);
            }
        }) : (this.conflictSetSearchTree != null ? this.conflictSetSearchTree.getStorageFor(anchorMap).iterator() : new FilterIterator<ReteSimpleMatch>(this.getConflictSet().iterator(), anchorMap){
            RuleToHostMap anchor;
            {
                this.anchor = ruleToHostMap;
            }

            @Override
            protected boolean approves(Object obj) {
                AbstractReteMatch m = (AbstractReteMatch)obj;
                return m.conformsWith(this.anchor);
            }
        }));
        return result;
    }

    public Set<RuleToHostMap> getActiveConflictsetAnchors(boolean includeEmpty) {
        HashSet<RuleToHostMap> result = null;
        if (this.conflictSetSearchTree != null) {
            result = new HashSet<RuleToHostMap>();
            HashMap<Set<ReteSimpleMatch>, RuleToHostMap> g = this.conflictSetSearchTree.getCollectionsToAnchorsMap();
            for (Map.Entry<Set<ReteSimpleMatch>, RuleToHostMap> s : g.entrySet()) {
                if (!includeEmpty && s.getKey().isEmpty()) continue;
                result.add(s.getValue());
            }
        }
        return result;
    }

    public void receive(AbstractReteMatch match) {
        ReteSimpleMatch m = new ReteSimpleMatch((ReteNetworkNode)this, this.getOwner().isInjective(), match);
        this.updateConflictSet(m, ReteNetworkNode.Action.ADD);
    }

    public void receiveInhibitorMatch(ReteSimpleMatch m, ReteNetworkNode.Action action) {
        if (action == ReteNetworkNode.Action.ADD) {
            this.inhibitionMap.add(m);
        } else {
            this.inhibitionMap.remove(m);
        }
        if (this.countCheckerNode != null) {
            this.countCheckerNode.invalidateCount();
        }
        if (this.notifyParent && this.parent != null) {
            this.parent.notifyChange(this);
        }
    }

    protected void updateConflictSet(ReteSimpleMatch m, ReteNetworkNode.Action action) {
        if (action == ReteNetworkNode.Action.ADD) {
            this.addMatchToConflictSet(m);
        } else {
            this.removeMatchFromConflictSet(m);
        }
        if (this.countCheckerNode != null) {
            this.countCheckerNode.invalidateCount();
        }
        if (this.notifyParent && this.parent != null) {
            this.parent.notifyChange(this);
        }
    }

    protected void addMatchToConflictSet(ReteSimpleMatch m) {
        Set<ReteSimpleMatch> c = this.conflictSetSearchTree == null ? this.conflictSet : this.conflictSetSearchTree.getStorageFor(m);
        assert (!c.contains(m));
        c.add(m);
        m.addContainerCollection(c);
        m.addDominoListener(this);
    }

    protected void removeMatchFromConflictSet(ReteSimpleMatch m) {
        assert (m != null);
        Set<ReteSimpleMatch> c = this.conflictSetSearchTree == null ? this.conflictSet : this.conflictSetSearchTree.getStorageFor(m);
        assert (c.contains(m));
        c.remove(m);
        assert (!c.contains(m));
    }

    public boolean isEmpty() {
        return this.getAntecedents().size() == 0;
    }

    @Override
    public boolean equals(ReteNetworkNode node) {
        return node instanceof ConditionChecker && this.getCondition().equals(((ConditionChecker)node).getCondition());
    }

    public int hashCode() {
        return this.condition.hashCode();
    }

    public String toString() {
        StringBuilder res = new StringBuilder(String.format("Name %s: ", this.condition.getName() != null ? this.condition.getName() : "null"));
        res.append(String.format("The conflict set size: %s", this.getConflictSet().size()));
        int i = 0;
        for (AbstractReteMatch abstractReteMatch : this.getConflictSet()) {
            res.append(String.format("Match(%d): %s", ++i, abstractReteMatch));
        }
        return res.toString();
    }

    @Override
    public void clear() {
        this.inhibitionMap.clear();
        this.conflictSet.clear();
        if (this.conflictSetSearchTree != null) {
            this.conflictSetSearchTree.clear();
        }
    }

    @Override
    public List<? extends Object> initialize() {
        return null;
    }

    @Override
    public RuleElement[] getPattern() {
        return this.pattern;
    }

    public boolean isIndexed() {
        return this.conflictSetSearchTree != null;
    }

    @Override
    public boolean demandUpdate() {
        boolean result = false;
        if (!this.isUpToDate()) {
            if (this.getOwner().isInOnDemandMode()) {
                if (!this.isEmpty()) {
                    for (ReteNetworkNode nnode : this.getAntecedents()) {
                        boolean bl = result = result || nnode.demandUpdate();
                    }
                }
                if (this.hasNacs()) {
                    for (ConditionChecker cc : this.getSubConditionCheckers()) {
                        if (!(cc instanceof CompositeConditionChecker)) continue;
                        cc.demandUpdate();
                    }
                }
            }
            this.setUpToDate(true);
        }
        return result;
    }

    @Override
    public int demandOneMatch() {
        int result = 0;
        if (this.getOwner().isInOnDemandMode()) {
            result = this.getAntecedents().get(0).demandOneMatch();
            while (result > 0 && this.conflictSet.size() == this.inhibitionMap.elementSet().size()) {
                result = this.getAntecedents().get(0).demandOneMatch();
            }
        }
        return result;
    }

    @Override
    protected void passDownMatchToSuccessors(AbstractReteMatch m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch subgraph) {
        this.receive(subgraph);
    }

    public ReteSimpleMatch getEmptyMatch() {
        return this.isEmpty() ? this.oneEmptyMatch.iterator().next() : null;
    }

    public QuantifierCountChecker getCountCheckerNode() {
        return this.countCheckerNode;
    }

    public void setCountCheckerNode(QuantifierCountChecker value) {
        assert (this.condition.getCountNode() != null && value.getCountNode().equals(this.condition.getCountNode()));
        this.countCheckerNode = value;
    }

    public boolean isNotifyParent() {
        return this.notifyParent;
    }

    public void setNotifyParent(boolean value) {
        this.notifyParent = value;
        for (ConditionChecker cc : this.getSubConditionCheckers()) {
            if (!cc.getCondition().isPositive()) continue;
            cc.setNotifyParent(value);
        }
    }

    protected void notifyChange(ConditionChecker sender) {
        if (this.countCheckerNode != null) {
            this.countCheckerNode.invalidateCount();
        }
        if (this.getParent() != null) {
            this.getParent().notifyChange(sender);
        }
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
    }

    @Override
    public void matchRemoved(AbstractReteMatch match) {
        if (this.countCheckerNode != null) {
            this.countCheckerNode.invalidateCount();
        }
        if (this.notifyParent && this.parent != null) {
            this.parent.notifyChange(this);
        }
    }

    class SearchTree {
        protected RuleElement[] rootSearchOrder;
        HashMap<HostElement, Object> root = new HashMap();
        HashMap<Set<ReteSimpleMatch>, RuleToHostMap> collectionsToAnchorsMap = new HashMap();
        HostFactory factory;

        SearchTree(List<? extends RuleElement> searchOrder) {
            this.rootSearchOrder = new RuleElement[searchOrder.size()];
            this.rootSearchOrder = searchOrder.toArray(this.rootSearchOrder);
        }

        public void clear() {
            this.root.clear();
            for (Set<ReteSimpleMatch> c : this.collectionsToAnchorsMap.keySet()) {
                c.clear();
            }
            this.collectionsToAnchorsMap.clear();
        }

        Set<ReteSimpleMatch> getStorageFor(ReteSimpleMatch m) {
            return this.getStorageFor(m, true);
        }

        Set<ReteSimpleMatch> getStorageFor(ReteSimpleMatch m, boolean create) {
            HostElement ei;
            Set result = null;
            HashMap leaf = this.root;
            RuleToHostMap anchorMap = this.getFactory().createRuleToHostMap();
            int i = 0;
            while (i < this.rootSearchOrder.length - 1) {
                if (this.rootSearchOrder[i] instanceof RuleNode) {
                    ei = m.getNode((RuleNode)this.rootSearchOrder[i]);
                    anchorMap.putNode((RuleNode)this.rootSearchOrder[i], (HostNode)ei);
                } else {
                    ei = m.getEdge((RuleEdge)this.rootSearchOrder[i]);
                    anchorMap.putEdge((RuleEdge)this.rootSearchOrder[i], (HostEdge)ei);
                }
                HashMap treeNode = (HashMap)leaf.get(ei);
                if (treeNode == null) {
                    if (create) {
                        treeNode = new HashMap();
                        leaf.put((HostNode)ei, treeNode);
                    } else {
                        leaf = null;
                        break;
                    }
                }
                leaf = treeNode;
                ++i;
            }
            if (leaf != null) {
                if (this.rootSearchOrder[this.rootSearchOrder.length - 1] instanceof RuleNode) {
                    ei = m.getNode((RuleNode)this.rootSearchOrder[this.rootSearchOrder.length - 1]);
                    anchorMap.putNode((RuleNode)this.rootSearchOrder[i], (HostNode)ei);
                } else {
                    ei = m.getEdge((RuleEdge)this.rootSearchOrder[this.rootSearchOrder.length - 1]);
                    anchorMap.putEdge((RuleEdge)this.rootSearchOrder[i], (HostEdge)ei);
                }
                Object o = leaf.get(ei);
                if (o == null && create) {
                    o = new TreeHashSet();
                    leaf.put((HostNode)ei, o);
                }
                result = (Set)o;
            }
            this.collectionsToAnchorsMap.put(result, anchorMap);
            return result;
        }

        Set<ReteSimpleMatch> getStorageFor(RuleToHostMap anchorMap) {
            Set result = null;
            HashMap leaf = this.root;
            int i = 0;
            while (i < this.rootSearchOrder.length - 1) {
                HostElement ei = this.rootSearchOrder[i] instanceof RuleNode ? (HostElement)anchorMap.nodeMap().get(this.rootSearchOrder[i]) : (HostElement)anchorMap.edgeMap().get(this.rootSearchOrder[i]);
                HashMap treeNode = (HashMap)leaf.get(ei);
                if (treeNode == null) {
                    treeNode = new HashMap();
                    leaf.put(ei, treeNode);
                }
                leaf = treeNode;
                ++i;
            }
            HostElement ei = this.rootSearchOrder[this.rootSearchOrder.length - 1] instanceof RuleNode ? (HostElement)anchorMap.nodeMap().get(this.rootSearchOrder[this.rootSearchOrder.length - 1]) : (HostElement)anchorMap.edgeMap().get(this.rootSearchOrder[this.rootSearchOrder.length - 1]);
            Object o = leaf.get(ei);
            if (o == null) {
                o = new TreeHashSet();
                leaf.put(ei, o);
            }
            result = (Set)o;
            this.collectionsToAnchorsMap.put(result, anchorMap);
            return result;
        }

        HostFactory getFactory() {
            if (this.factory == null) {
                this.factory = ConditionChecker.this.getOwner().getHostFactory();
            }
            return this.factory;
        }

        HashMap<Set<ReteSimpleMatch>, RuleToHostMap> getCollectionsToAnchorsMap() {
            return this.collectionsToAnchorsMap;
        }
    }
}

