/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.algebra.Algebra;
import groove.algebra.AlgebraFamily;
import groove.algebra.Term;
import groove.algebra.Variable;
import groove.grammar.Condition;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostGraph;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.match.ValueOracle;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.SearchItem;
import java.util.Collection;
import java.util.Collections;

class ValueNodeSearchItem
extends AbstractSearchItem {
    private final Collection<RuleNode> boundNodes;
    final VariableNode node;
    final Algebra<?> algebra;
    final Object value;
    int nodeIx;
    Condition condition;
    ValueOracle oracle;

    public ValueNodeSearchItem(VariableNode node, AlgebraFamily family) {
        this.node = node;
        this.boundNodes = Collections.singleton(node);
        this.algebra = family.getAlgebra(node.getSignature());
        Term term = node.getTerm();
        this.value = term instanceof Variable ? null : family.getValue(node.getTerm());
    }

    @Override
    public SearchItem.Record createRecord(PlanSearchStrategy.Search matcher) {
        if (this.value == null) {
            return new ValueQueryRecord(matcher);
        }
        return new ValueNodeRecord(matcher);
    }

    @Override
    public int compareTo(SearchItem item) {
        int result = super.compareTo(item);
        if (result != 0) {
            return result;
        }
        ValueNodeSearchItem other = (ValueNodeSearchItem)item;
        return this.getNode().compareTo(other.getNode());
    }

    @Override
    int computeHashCode() {
        return super.computeHashCode() + 31 * this.getNode().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ValueNodeSearchItem other = (ValueNodeSearchItem)obj;
        return this.getNode().equals(other.getNode());
    }

    @Override
    int getRating() {
        return 0;
    }

    @Override
    public Collection<? extends RuleNode> bindsNodes() {
        return this.boundNodes;
    }

    public String toString() {
        return String.format("Value %s", this.node);
    }

    public VariableNode getNode() {
        return this.node;
    }

    @Override
    public void activate(PlanSearchStrategy strategy) {
        this.nodeIx = strategy.getNodeIx(this.node);
        this.oracle = strategy.getOracle();
        this.condition = strategy.getPlan().getCondition();
    }

    private class ValueNodeRecord
    extends AbstractSearchItem.SingularRecord {
        private ValueNode image;

        ValueNodeRecord(PlanSearchStrategy.Search search) {
            super(search);
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            this.image = host.getFactory().createValueNode(ValueNodeSearchItem.this.algebra, ValueNodeSearchItem.this.value);
        }

        @Override
        boolean find() {
            return this.write();
        }

        @Override
        void erase() {
            this.search.putNode(ValueNodeSearchItem.this.nodeIx, null);
        }

        @Override
        boolean write() {
            return this.search.putNode(ValueNodeSearchItem.this.nodeIx, this.image);
        }

        @Override
        public String toString() {
            return ValueNodeSearchItem.this.toString();
        }
    }

    private class ValueQueryRecord
    extends AbstractSearchItem.MultipleRecord<String> {
        private HostFactory factory;
        private Iterable<String> values;

        public ValueQueryRecord(PlanSearchStrategy.Search search) {
            super(search);
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            this.factory = host.getFactory();
            this.values = ValueNodeSearchItem.this.oracle.getValues(ValueNodeSearchItem.this.condition, ValueNodeSearchItem.this.node);
        }

        @Override
        void init() {
            this.imageIter = this.values.iterator();
        }

        @Override
        boolean write(String image) {
            ValueNode imageNode = this.factory.createNodeFromString(ValueNodeSearchItem.this.algebra, image);
            return this.search.putNode(ValueNodeSearchItem.this.nodeIx, imageNode);
        }

        @Override
        void erase() {
            this.search.putNode(ValueNodeSearchItem.this.nodeIx, null);
        }
    }
}

