/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.grammar.aspect.AspectGraph;
import groove.io.FileType;
import groove.io.external.AbstractFormatExporter;
import groove.io.external.Exporter;
import groove.io.external.Format;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import groove.io.external.util.GraphToKth;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;

public final class KthExporter
extends AbstractFormatExporter {
    private final Format kthformat = new Format((FormatPorter)this, FileType.KTH);
    private static final KthExporter instance = new KthExporter();

    private KthExporter() {
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.GRAPH;
    }

    @Override
    public Collection<? extends Format> getSupportedFormats() {
        return Collections.singletonList(this.kthformat);
    }

    @Override
    public void doExport(File file, Format format, Exporter.Exportable exportable) throws PortException {
        AspectGraph graph = (AspectGraph)exportable.getGraph();
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            GraphToKth.export(graph, writer);
            writer.close();
        }
        catch (IOException e) {
            throw new PortException(e);
        }
    }

    public static final KthExporter getInstance() {
        return instance;
    }
}

