/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.gui.Simulator;
import groove.io.ExtensionFilter;
import groove.io.GrooveFileChooser;
import groove.io.external.Format;
import groove.io.external.FormatFilter;
import groove.io.external.FormatImporter;
import groove.io.external.PortException;
import groove.io.external.format.AutPorter;
import groove.io.external.format.ColImporter;
import groove.io.external.format.DotPorter;
import groove.io.external.format.EcorePorter;
import groove.io.external.format.GxlPorter;
import groove.io.external.format.NativePorter;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class Importer {
    private final List<FormatImporter> importers = new ArrayList<FormatImporter>();
    private final GrooveFileChooser formatChooser;
    private static final Importer instance = new Importer();

    private Importer() {
        this.importers.add(NativePorter.getInstance());
        this.importers.add(AutPorter.getInstance());
        this.importers.add(ColImporter.getInstance());
        this.importers.add(EcorePorter.instance());
        this.importers.add(GxlPorter.instance());
        this.importers.add(DotPorter.getInstance());
        ArrayList<ExtensionFilter> filters = new ArrayList<ExtensionFilter>();
        for (FormatImporter ri : this.importers) {
            for (Format format : ri.getSupportedFormats()) {
                filters.add(format.getFilter());
            }
        }
        this.formatChooser = GrooveFileChooser.getFileChooser(filters);
        this.formatChooser.setFileFilter((FileFilter)filters.get(0));
    }

    public void doImport(Simulator simulator, GrammarModel grammar) throws IOException {
        int approve = this.formatChooser.showDialog(simulator.getFrame(), "Import");
        if (approve == 0) {
            try {
                this.doChosenImport(simulator, grammar);
            }
            catch (PortException e) {
                throw new IOException(e);
            }
        }
    }

    private void doChosenImport(Simulator simulator, GrammarModel grammar) throws PortException, IOException {
        FormatFilter filter = (FormatFilter)this.formatChooser.getFileFilter();
        FormatImporter ri = (FormatImporter)filter.getFormat().getFormatter();
        File file = this.formatChooser.getSelectedFile();
        ri.setSimulator(simulator);
        Set<FormatImporter.Resource> resources = ri.doImport(file, filter.getFormat(), grammar);
        if (resources != null) {
            EnumMap<ResourceKind, ArrayList<AspectGraph>> newGraphs = new EnumMap<ResourceKind, ArrayList<AspectGraph>>(ResourceKind.class);
            EnumMap<ResourceKind, HashMap<String, String>> newTexts = new EnumMap<ResourceKind, HashMap<String, String>>(ResourceKind.class);
            for (FormatImporter.Resource resource : resources) {
                String name = resource.getName();
                ResourceKind kind = resource.getKind();
                if (grammar.getResource(kind, name) != null && !this.confirmOverwrite(simulator.getFrame(), kind, name)) continue;
                if (resource.isGraph()) {
                    AspectGraph graph = resource.getGraphResource();
                    ArrayList<AspectGraph> graphs = (ArrayList<AspectGraph>)newGraphs.get((Object)kind);
                    if (graphs == null) {
                        graphs = new ArrayList<AspectGraph>();
                        newGraphs.put(kind, graphs);
                    }
                    graphs.add(graph);
                    continue;
                }
                String text = resource.getTextResource();
                HashMap<String, String> texts = (HashMap<String, String>)newTexts.get((Object)kind);
                if (texts == null) {
                    texts = new HashMap<String, String>();
                    newTexts.put(kind, texts);
                }
                texts.put(name, text);
                grammar.getStore().putTexts(resource.getKind(), Collections.singletonMap(name, text));
            }
            for (Map.Entry entry : newGraphs.entrySet()) {
                grammar.getStore().putGraphs((ResourceKind)((Object)entry.getKey()), (Collection)entry.getValue(), true);
            }
            for (Map.Entry entry : newTexts.entrySet()) {
                grammar.getStore().putTexts((ResourceKind)((Object)entry.getKey()), (Map)entry.getValue());
            }
        }
    }

    protected final boolean confirmOverwrite(Component parent, ResourceKind resource, String name) {
        int response = JOptionPane.showConfirmDialog(parent, String.format("Replace existing %s '%s'?", resource.getDescription(), name), null, 2);
        return response == 0;
    }

    public static Importer instance() {
        return instance;
    }
}

