/*
 * Decompiled with CFR 0.152.
 */
package groove.io.ecore2groove;

import groove.grammar.aspect.AspectGraph;
import groove.graph.Node;
import groove.graph.plain.PlainEdge;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainLabel;
import groove.graph.plain.PlainNode;
import groove.io.ecore2groove.GraphLabels;
import groove.io.ecore2groove.ModelHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class InstanceModelRep {
    private PlainGraph instanceGraph;
    private Resource instanceModel;
    private Set<PlainEdge> classEdgeSet;
    private Set<PlainEdge> referenceEdgeSet;
    private Set<PlainEdge> containmentReferenceEdgeSet;
    private Set<PlainEdge> attributeEdgeSet;
    private PlainEdge rootEdge;
    private Map<PlainNode, PlainNode> nextNode;
    private Map<String, EClass> labelToClass;
    private Map<String, EReference> labelToReference;
    private Map<String, EReference> labelToContainmentReference;
    private Map<String, EAttribute> labelToAttribute;
    private Map<String, EEnum> labelToEnum;
    private Map<String, EEnumLiteral> labelToLiteral;
    private Map<PlainNode, PlainNode> referenceToVal;
    private Map<PlainNode, String> attributeToVal;
    private Map<PlainNode, PlainEdge> featureToType;
    private Map<PlainNode, EObject> nodeToObject;

    public InstanceModelRep(ModelHandler mh, AspectGraph ig) {
        this.instanceGraph = ig.toPlainGraph();
        this.classEdgeSet = new HashSet<PlainEdge>();
        this.referenceEdgeSet = new HashSet<PlainEdge>();
        this.containmentReferenceEdgeSet = new HashSet<PlainEdge>();
        this.attributeEdgeSet = new HashSet<PlainEdge>();
        this.rootEdge = null;
        this.nextNode = new HashMap<PlainNode, PlainNode>();
        this.labelToClass = new HashMap<String, EClass>();
        this.labelToReference = new HashMap<String, EReference>();
        this.labelToContainmentReference = new HashMap<String, EReference>();
        this.labelToAttribute = new HashMap<String, EAttribute>();
        this.labelToEnum = new HashMap<String, EEnum>();
        this.labelToLiteral = new HashMap<String, EEnumLiteral>();
        this.referenceToVal = new HashMap<PlainNode, PlainNode>();
        this.attributeToVal = new HashMap<PlainNode, String>();
        this.featureToType = new HashMap<PlainNode, PlainEdge>();
        this.nodeToObject = new HashMap<PlainNode, EObject>();
        for (EClass eClass : mh.getEClasses()) {
            String classLabel = GraphLabels.getLabel((EClassifier)eClass);
            this.labelToClass.put(classLabel, eClass);
        }
        for (EReference eReference : mh.getEReferences()) {
            String referenceLabel = GraphLabels.getLabel((EStructuralFeature)eReference);
            if (eReference.isContainment()) {
                this.labelToContainmentReference.put(referenceLabel, eReference);
                continue;
            }
            this.labelToReference.put(referenceLabel, eReference);
        }
        for (EAttribute eAttribute : mh.getEAttributes()) {
            String attributeLabel = GraphLabels.getLabel((EStructuralFeature)eAttribute);
            this.labelToAttribute.put(attributeLabel, eAttribute);
        }
        for (EEnum eEnum : mh.getEEnums()) {
            String enumLabel = GraphLabels.getLabel(eEnum);
            this.labelToEnum.put(enumLabel, eEnum);
        }
        for (EEnumLiteral eEnumLiteral : mh.getEEnumLiterals()) {
            String literalLabel = GraphLabels.getLabel(eEnumLiteral);
            this.labelToLiteral.put(literalLabel, eEnumLiteral);
        }
        for (PlainEdge plainEdge : this.instanceGraph.edgeSet()) {
            if (plainEdge.source() == plainEdge.target()) {
                if (this.labelToClass.containsKey(((PlainLabel)plainEdge.label()).text())) {
                    this.classEdgeSet.add(plainEdge);
                    this.featureToType.put((PlainNode)plainEdge.source(), plainEdge);
                    continue;
                }
                if (this.labelToReference.containsKey(((PlainLabel)plainEdge.label()).text())) {
                    this.referenceEdgeSet.add(plainEdge);
                    this.featureToType.put((PlainNode)plainEdge.source(), plainEdge);
                    this.referenceToVal.put((PlainNode)plainEdge.source(), this.getValue((PlainNode)plainEdge.source()));
                    continue;
                }
                if (this.labelToContainmentReference.containsKey(((PlainLabel)plainEdge.label()).text())) {
                    this.containmentReferenceEdgeSet.add(plainEdge);
                    this.featureToType.put((PlainNode)plainEdge.source(), plainEdge);
                    this.referenceToVal.put((PlainNode)plainEdge.source(), this.getValue((PlainNode)plainEdge.source()));
                    continue;
                }
                if (this.labelToAttribute.containsKey(((PlainLabel)plainEdge.label()).text())) {
                    this.attributeEdgeSet.add(plainEdge);
                    this.featureToType.put((PlainNode)plainEdge.source(), plainEdge);
                    PlainNode attrVal = this.getValue((PlainNode)plainEdge.source());
                    if (attrVal == null) continue;
                    for (PlainEdge plainEdge2 : this.instanceGraph.outEdgeSet(attrVal)) {
                        String outLabelText = ((PlainLabel)plainEdge2.label()).text();
                        if (outLabelText.startsWith("flag:") || outLabelText.startsWith("int:") || outLabelText.startsWith("bool:") || outLabelText.startsWith("real:")) {
                            this.attributeToVal.put((PlainNode)plainEdge.source(), outLabelText.substring(outLabelText.indexOf(58) + 1));
                            continue;
                        }
                        if (!outLabelText.startsWith("string:")) continue;
                        this.attributeToVal.put((PlainNode)plainEdge.source(), outLabelText.substring(outLabelText.indexOf(58) + 2, outLabelText.length() - 1));
                    }
                    continue;
                }
                if (!((PlainLabel)plainEdge.label()).text().equals("flag:root")) continue;
                this.rootEdge = plainEdge;
                continue;
            }
            if (!((PlainLabel)plainEdge.label()).text().equals("next")) continue;
            this.nextNode.put((PlainNode)plainEdge.source(), (PlainNode)plainEdge.target());
        }
        this.instanceModel = mh.createModel(this.instanceGraph.getName());
        EList eList = this.instanceModel.getContents();
        if (this.rootEdge == null) {
            System.out.println("No root element!");
            System.exit(1);
        }
        String rootLabel = ((PlainLabel)this.featureToType.get(this.rootEdge.source()).label()).text();
        EClass rootClass = this.labelToClass.get(rootLabel);
        EObject eObject = rootClass.getEPackage().getEFactoryInstance().create(rootClass);
        this.nodeToObject.put((PlainNode)this.rootEdge.source(), eObject);
        eList.add((Object)eObject);
        this.addContainedClasses(this.rootEdge);
        this.addStructuralFeatures();
    }

    private void addContainedClasses(PlainEdge startEdge) {
        for (PlainEdge plainEdge : this.instanceGraph.outEdgeSet((Node)startEdge.source())) {
            PlainEdge refEdge = this.featureToType.get(plainEdge.target());
            if (refEdge == null || !this.containmentReferenceEdgeSet.contains(refEdge)) continue;
            if (!this.labelToContainmentReference.get(((PlainLabel)refEdge.label()).text()).isOrdered()) {
                PlainEdge valueEdge = this.featureToType.get(this.referenceToVal.get(refEdge.source()));
                EClass valueEClass = this.labelToClass.get(((PlainLabel)valueEdge.label()).text());
                EReference valueEReference = this.labelToContainmentReference.get(((PlainLabel)refEdge.label()).text());
                EObject valueInstance = valueEClass.getEPackage().getEFactoryInstance().create(valueEClass);
                if (valueEReference.isMany()) {
                    ((EList)this.nodeToObject.get(startEdge.source()).eGet((EStructuralFeature)valueEReference)).add((Object)valueInstance);
                } else {
                    this.nodeToObject.get(startEdge.source()).eSet((EStructuralFeature)valueEReference, (Object)valueInstance);
                }
                this.nodeToObject.put((PlainNode)valueEdge.source(), valueInstance);
                this.addContainedClasses(valueEdge);
                continue;
            }
            if (this.nextNode.containsValue(plainEdge.target())) continue;
            PlainNode next = (PlainNode)plainEdge.target();
            do {
                PlainEdge valueEdge = this.featureToType.get(this.referenceToVal.get(next));
                EClass valueEClass = this.labelToClass.get(((PlainLabel)valueEdge.label()).text());
                EReference valueEReference = this.labelToContainmentReference.get(((PlainLabel)refEdge.label()).text());
                EObject valueInstance = valueEClass.getEPackage().getEFactoryInstance().create(valueEClass);
                if (valueEReference.isMany()) {
                    ((EList)this.nodeToObject.get(startEdge.source()).eGet((EStructuralFeature)valueEReference)).add((Object)valueInstance);
                } else {
                    this.nodeToObject.get(startEdge.source()).eSet((EStructuralFeature)valueEReference, (Object)valueInstance);
                }
                this.nodeToObject.put((PlainNode)valueEdge.source(), valueInstance);
                this.addContainedClasses(valueEdge);
            } while ((next = this.nextNode.get(next)) != null);
        }
    }

    private void addStructuralFeatures() {
        for (PlainEdge classEdge : this.classEdgeSet) {
            for (PlainEdge plainEdge : this.instanceGraph.outEdgeSet((Node)classEdge.source())) {
                PlainEdge featureEdge = this.featureToType.get(plainEdge.target());
                if (featureEdge == null) continue;
                if (this.referenceEdgeSet.contains(featureEdge) && !this.labelToReference.get(((PlainLabel)featureEdge.label()).text()).isContainer()) {
                    this.addReference(classEdge, featureEdge);
                    continue;
                }
                if (!this.attributeEdgeSet.contains(featureEdge)) continue;
                this.addAttribute(classEdge, featureEdge);
            }
        }
    }

    private void addAttribute(PlainEdge containerEdge, PlainEdge featureEdge) {
        if (!this.labelToAttribute.get(((PlainLabel)featureEdge.label()).text()).isOrdered()) {
            String attrValue = this.attributeToVal.get(featureEdge.source());
            EClass containerEClass = this.labelToClass.get(((PlainLabel)containerEdge.label()).text());
            EAttribute valueEAttribute = this.labelToAttribute.get(((PlainLabel)featureEdge.label()).text());
            EDataType attrType = (EDataType)this.labelToAttribute.get(((PlainLabel)featureEdge.label()).text()).getEType();
            EFactory factory = containerEClass.getEPackage().eContents().contains((Object)attrType) ? containerEClass.getEPackage().getEFactoryInstance() : containerEClass.eClass().getEPackage().getEFactoryInstance();
            Object valueInstance = factory.createFromString(attrType, attrValue);
            if (valueEAttribute.isMany()) {
                EList values = (EList)this.nodeToObject.get(containerEdge.source()).eGet((EStructuralFeature)valueEAttribute);
                values.add(valueInstance);
            } else {
                this.nodeToObject.get(containerEdge.source()).eSet((EStructuralFeature)valueEAttribute, valueInstance);
            }
        } else if (!this.nextNode.containsValue(featureEdge.target())) {
            PlainNode next = (PlainNode)featureEdge.source();
            do {
                String attrValue = this.attributeToVal.get(next);
                EClass containerEClass = this.labelToClass.get(((PlainLabel)containerEdge.label()).text());
                EAttribute valueEAttribute = this.labelToAttribute.get(((PlainLabel)featureEdge.label()).text());
                EDataType attrType = (EDataType)this.labelToAttribute.get(((PlainLabel)featureEdge.label()).text()).getEType();
                EFactory factory = containerEClass.getEPackage().eContents().contains((Object)attrType) ? containerEClass.getEPackage().getEFactoryInstance() : containerEClass.eClass().getEPackage().getEFactoryInstance();
                Object valueInstance = factory.createFromString(attrType, attrValue);
                if (valueEAttribute.isMany()) {
                    EList values = (EList)this.nodeToObject.get(containerEdge.source()).eGet((EStructuralFeature)valueEAttribute);
                    values.add(valueInstance);
                    continue;
                }
                this.nodeToObject.get(containerEdge.source()).eSet((EStructuralFeature)valueEAttribute, valueInstance);
            } while ((next = this.nextNode.get(next)) != null);
        }
    }

    private void addReference(PlainEdge containerEdge, PlainEdge featureEdge) {
        if (!this.labelToReference.get(((PlainLabel)featureEdge.label()).text()).isOrdered()) {
            PlainEdge valueEdge = this.featureToType.get(this.referenceToVal.get(featureEdge.source()));
            EReference valueEReference = this.labelToReference.get(((PlainLabel)featureEdge.label()).text());
            EObject valueInstance = this.nodeToObject.get(valueEdge.source());
            if (valueEReference.isMany()) {
                EList values = (EList)this.nodeToObject.get(containerEdge.source()).eGet((EStructuralFeature)valueEReference);
                if (!values.contains((Object)valueInstance)) {
                    values.add((Object)valueInstance);
                }
            } else {
                this.nodeToObject.get(containerEdge.source()).eSet((EStructuralFeature)valueEReference, (Object)valueInstance);
            }
        } else if (!this.nextNode.containsValue(featureEdge.target())) {
            PlainNode next = (PlainNode)featureEdge.source();
            do {
                PlainEdge valueEdge = this.featureToType.get(this.referenceToVal.get(next));
                EReference valueEReference = this.labelToReference.get(((PlainLabel)featureEdge.label()).text());
                EObject valueInstance = this.nodeToObject.get(valueEdge.source());
                if (valueEReference.isMany()) {
                    EList values = (EList)this.nodeToObject.get(containerEdge.source()).eGet((EStructuralFeature)valueEReference);
                    if (!values.contains((Object)valueInstance)) {
                        values.add((Object)valueInstance);
                        continue;
                    }
                    values.move(values.size() - 1, (Object)valueInstance);
                    continue;
                }
                this.nodeToObject.get(containerEdge.source()).eSet((EStructuralFeature)valueEReference, (Object)valueInstance);
            } while ((next = this.nextNode.get(next)) != null);
        }
    }

    private PlainNode getValue(PlainNode featureNode) {
        PlainNode value = null;
        for (PlainEdge plainEdge : this.instanceGraph.outEdgeSet(featureNode)) {
            if (!((PlainLabel)plainEdge.label()).text().equals("val")) continue;
            value = (PlainNode)plainEdge.target();
        }
        return value;
    }

    public Resource getInstanceModel() {
        return this.instanceModel;
    }
}

