/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.type;

import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.Visitor;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.value.RealValue;
import groove.io.conceptual.value.Value;

public class RealType
extends DataType {
    private static RealType instance = new RealType();
    public static final String NAME = "real";

    private RealType() {
        super(Id.getId(Id.ROOT, Name.getName(NAME)));
    }

    @Override
    public String typeString() {
        return NAME;
    }

    @Override
    public boolean doVisit(Visitor v, Object param) {
        v.visit(this, param);
        return true;
    }

    @Override
    public Value valueFromString(String valueString) {
        double i = 0.0;
        try {
            i = Double.parseDouble(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new RealValue(i);
    }

    @Override
    public boolean acceptValue(Value v) {
        return v instanceof RealValue;
    }

    public static RealType instance() {
        return instance;
    }
}

