/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectElement;
import groove.grammar.aspect.AspectNode;
import groove.grammar.model.RuleModel;
import groove.gui.jgraph.AspectJCell;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.gui.look.VisualKey;
import groove.gui.tree.CheckboxTree;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;

public class RuleLevelTree
extends CheckboxTree
implements TreeSelectionListener {
    private final AspectJGraph jGraph;
    private RuleModel rule;
    private final Map<RuleModel.Index, LevelNode> levelNodeMap = new TreeMap<RuleModel.Index, LevelNode>();
    private AspectJModel jModel;
    private final Set<AspectJCell> allCellSet = new HashSet<AspectJCell>();
    private final Set<AspectJCell> selectedSet = new HashSet<AspectJCell>();
    private final Map<RuleModel.Index, Set<AspectJCell>> levelCellMap = new TreeMap<RuleModel.Index, Set<AspectJCell>>();

    public RuleLevelTree(AspectJGraph jGraph) {
        this.jGraph = jGraph;
        this.setLargeModel(true);
        this.setEnabled(jGraph.isEnabled());
        this.setShowsRootHandles(false);
        this.getUI().setCollapsedIcon(null);
        this.getUI().setExpandedIcon(null);
        this.addMouseListener(new MyMouseListener());
        jGraph.addGraphSelectionListener(new GraphSelectionListener(){

            public void valueChanged(GraphSelectionEvent e) {
                RuleLevelTree.this.clearSelection();
            }
        });
    }

    private void synchroniseJModel() {
        AspectJModel jModel = this.getJGraph().getModel();
        if (jModel != this.jModel) {
            this.jModel = jModel;
            this.rule = jModel == null ? null : (RuleModel)jModel.getResourceModel();
            boolean enabled = this.updateTree();
            for (Set<AspectJCell> levelCells : this.levelCellMap.values()) {
                this.allCellSet.addAll(levelCells);
            }
            this.updateVisibleCells(this.levelNodeMap.values());
            this.setEnabled(enabled);
        }
    }

    public boolean isVisible(AspectJCell jCell) {
        this.synchroniseJModel();
        return !this.allCellSet.contains(jCell) || this.selectedSet.contains(jCell);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.synchroniseJModel();
        HashSet emphSet = new HashSet();
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            TreePath[] treePathArray = selectionPaths;
            int n = selectionPaths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath selectedPath = treePathArray[n2];
                RuleModel.Index index = ((LevelNode)selectedPath.getLastPathComponent()).getIndex();
                emphSet.addAll(this.levelCellMap.get(index));
                ++n2;
            }
        }
        emphSet.retainAll(this.selectedSet);
        this.getJGraph().setSelectionCells(emphSet.toArray());
    }

    private boolean updateTree() {
        boolean enabled;
        this.removeTreeSelectionListener(this);
        this.clearSelection();
        this.getTopNode().removeAllChildren();
        HashSet<LevelNode> newNodes = new HashSet<LevelNode>();
        TreeMap<RuleModel.Index, Set<AspectElement>> levelTree = this.rule == null ? null : this.rule.getLevelTree();
        boolean bl = enabled = levelTree != null && levelTree.size() > 1;
        if (enabled) {
            for (Map.Entry levelEntry : levelTree.entrySet()) {
                AspectNode ruleLevelNode;
                RuleModel.Index index = (RuleModel.Index)levelEntry.getKey();
                if (!index.isTopLevel() && index.getLevelNode() == null) continue;
                LevelNode levelNode = new LevelNode(index);
                if (index.isTopLevel()) {
                    this.getTopNode().add(levelNode);
                } else {
                    LevelNode parentNode = this.levelNodeMap.get(index.getParent());
                    parentNode.add(levelNode);
                }
                this.levelNodeMap.put(index, levelNode);
                AspectJModel jModel = this.getJGraph().getModel();
                HashSet<AspectJCell> levelCells = new HashSet<AspectJCell>();
                for (AspectElement elem : (Set)levelEntry.getValue()) {
                    AspectJCell jCell = jModel.getJCell(elem);
                    if (jCell == null) continue;
                    levelCells.add(jCell);
                }
                if (!index.isTopLevel()) {
                    levelCells.removeAll((Collection)this.levelCellMap.get(index.getParent()));
                }
                if ((ruleLevelNode = index.getLevelNode()) != null) {
                    AspectJCell jCell = jModel.getJCell(ruleLevelNode);
                    if (jCell != null) {
                        levelCells.add(jCell);
                    }
                    for (AspectEdge edge : this.rule.getSource().edgeSet(ruleLevelNode)) {
                        jCell = jModel.getJCell(edge);
                        if (jCell == null) continue;
                        levelCells.add(jCell);
                    }
                }
                this.levelCellMap.put(index, levelCells);
                newNodes.add(levelNode);
            }
        }
        this.getModel().reload(this.getTopNode());
        for (LevelNode newNode : newNodes) {
            this.expandPath(new TreePath(newNode.getPath()));
        }
        this.addTreeSelectionListener(this);
        return enabled;
    }

    private Set<AspectJCell> updateVisibleCells(Collection<LevelNode> changedNodes) {
        HashSet<AspectJCell> selecteds = new HashSet<AspectJCell>();
        HashSet<AspectJCell> unselecteds = new HashSet<AspectJCell>();
        for (LevelNode node : changedNodes) {
            Set<AspectJCell> levelCells = this.levelCellMap.get(node.getIndex());
            if (node.isSelected()) {
                selecteds.addAll(levelCells);
                continue;
            }
            unselecteds.addAll(levelCells);
        }
        this.selectedSet.removeAll(unselecteds);
        this.selectedSet.addAll(selecteds);
        HashSet<AspectJCell> result = new HashSet<AspectJCell>(selecteds.size() + unselecteds.size());
        result.addAll(selecteds);
        result.addAll(unselecteds);
        for (AspectJCell jCell : result) {
            jCell.setStale(VisualKey.VISIBLE);
            for (AspectJCell aspectJCell : jCell.getContext()) {
                aspectJCell.setStale(VisualKey.VISIBLE);
            }
        }
        return result;
    }

    @Override
    protected void setExpandedState(TreePath path, boolean state) {
        if (state) {
            super.setExpandedState(path, state);
        }
    }

    private AspectJGraph getJGraph() {
        return this.jGraph;
    }

    private class LevelNode
    extends CheckboxTree.TreeNode {
        private String name;
        private final RuleModel.Index index;
        private boolean selected;

        public LevelNode(RuleModel.Index index) {
            this.index = index;
            this.selected = true;
        }

        public RuleModel.Index getIndex() {
            return this.index;
        }

        public String getName() {
            if (this.name == null) {
                StringBuilder result = new StringBuilder(this.index.getOperator().getSymbol());
                String levelName = null;
                if (this.index.getLevelNode() != null) {
                    levelName = this.index.getLevelNode().getLevelName();
                }
                if (levelName == null) {
                    int[] nArray = this.index.getIntArray();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int level = nArray[n2];
                        result.append('.');
                        result.append(level);
                        ++n2;
                    }
                } else {
                    result.append('.');
                    result.append(levelName);
                }
                this.name = result.toString();
            }
            return this.name;
        }

        @Override
        public boolean hasCheckbox() {
            return true;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setSelected(boolean selected) {
            this.selected = selected;
            Set changes = RuleLevelTree.this.updateVisibleCells(Collections.singleton(this));
            RuleLevelTree.this.getJGraph().refreshCells(changes);
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath path;
            if (e.getClickCount() == 2 && (path = RuleLevelTree.this.getPathForLocation(e.getPoint().x, e.getPoint().y)) != null) {
                LevelNode levelNode;
                levelNode.setSelected(!(levelNode = (LevelNode)path.getLastPathComponent()).isSelected());
                RuleLevelTree.this.repaint();
            }
        }
    }
}

