/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.menu;

import groove.gui.jgraph.JGraph;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JViewport;
import javax.swing.KeyStroke;

public class ZoomMenu
extends JMenu {
    public static final String ZOOM_MENU_NAME = "Zoom";
    protected final Action zoomToFitAction = new AbstractAction("Zoom to fit"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            Container component = ZoomMenu.this.jgraph.getParent();
            while (component != null && !(component instanceof JViewport)) {
                component = component.getParent();
            }
            if (component != null) {
                JViewport viewport = (JViewport)component;
                Rectangle2D graphBounds = ZoomMenu.this.jgraph.getGraphBounds();
                Dimension viewportBounds = viewport.getExtentSize();
                double scale = Math.min((double)viewportBounds.width / graphBounds.getWidth(), (double)viewportBounds.height / graphBounds.getHeight());
                ZoomMenu.this.jgraph.setScale(Math.min(scale, 1.0));
                ZoomMenu.this.jgraph.scrollRectToVisible(graphBounds.getBounds());
                ZoomMenu.this.setActionsEnabled();
            }
        }
    };
    protected final Action zoomInAction = new AbstractAction("Zoom in"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ZoomMenu.this.jgraph.changeScale(1);
            ZoomMenu.this.setActionsEnabled();
        }
    };
    protected final Action zoomOutAction = new AbstractAction("Zoom out"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ZoomMenu.this.jgraph.changeScale(-1);
            ZoomMenu.this.setActionsEnabled();
        }
    };
    protected final Action resetZoomAction = new AbstractAction("Reset zoom"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ZoomMenu.this.jgraph.setScale(1.0);
            ZoomMenu.this.setActionsEnabled();
        }
    };
    final JGraph<?> jgraph;
    private static final int MENU_MNEMONIC = 90;

    public ZoomMenu(JGraph<?> jgraph) {
        super(ZOOM_MENU_NAME);
        this.jgraph = jgraph;
        this.add(this.zoomToFitAction);
        this.add(this.zoomInAction);
        this.add(this.zoomOutAction);
        this.add(this.resetZoomAction);
        this.setMnemonic(90);
        this.registerAction(this.zoomInAction, 61);
        this.registerAction(this.zoomOutAction, 45);
        this.registerAction(this.resetZoomAction, 48);
        this.reset();
    }

    private void registerAction(Action action, int keyCode) {
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(keyCode, 2));
        this.jgraph.addAccelerator(action);
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        if (isIncluded) {
            this.reset();
        }
    }

    public void reset() {
        this.setActionsEnabled();
    }

    protected void setActionsEnabled() {
    }
}

