/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.gui.look.LineFormat;
import groove.gui.look.Values;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;

public abstract class Line {
    private static final Empty empty = new Empty();

    public abstract <R extends LineFormat.Builder<R>> R toString(LineFormat<R> var1);

    public Line color(ColorType type) {
        if (this.isEmpty()) {
            return this;
        }
        return new Colored(type, type.getColor(), this);
    }

    public Line color(Color color) {
        if (this.isEmpty()) {
            return this;
        }
        return new Colored(ColorType.RGB, color, this);
    }

    public Line style(Style style) {
        if (this.isEmpty()) {
            return this;
        }
        return new Styled(style, this);
    }

    public Line append(Line ... args) {
        Line result;
        if (this == empty) {
            result = args.length == 0 ? this : (args.length == 1 ? args[0] : new Composed(args));
        } else if (this instanceof Composed) {
            Line[] oldFragments = ((Composed)this).fragments;
            Line[] newFragments = new Line[oldFragments.length + args.length];
            System.arraycopy(oldFragments, 0, newFragments, 0, oldFragments.length);
            System.arraycopy(args, 0, newFragments, oldFragments.length, args.length);
            result = new Composed(newFragments);
        } else {
            Line[] newFragments = new Line[args.length + 1];
            newFragments[0] = this;
            System.arraycopy(args, 0, newFragments, 1, args.length);
            result = new Composed(newFragments);
        }
        return result;
    }

    public Line append(String atom) {
        Line result;
        if (this == empty) {
            result = Line.atom(atom);
        } else if (this instanceof Atomic) {
            result = Line.atom(String.valueOf(((Atomic)this).text) + atom);
        } else if (this instanceof Composed) {
            Line[] oldFragments = ((Composed)this).fragments;
            Line[] newFragments = new Line[oldFragments.length + 1];
            System.arraycopy(oldFragments, 0, newFragments, 0, oldFragments.length);
            newFragments[oldFragments.length] = Line.atom(atom);
            result = new Composed(newFragments);
        } else {
            result = new Composed(this, Line.atom(atom));
        }
        return result;
    }

    public boolean isEmpty() {
        return this == empty;
    }

    public static Empty empty() {
        return empty;
    }

    public static Line atom(String text) {
        if (text == null || text.length() == 0) {
            return empty;
        }
        return new Atomic(text);
    }

    public static Composed composed(List<Line> fragments) {
        return new Composed(fragments);
    }

    public static class Atomic
    extends Line {
        private final String text;

        public Atomic(String text) {
            this.text = text;
        }

        @Override
        public <R extends LineFormat.Builder<R>> R toString(LineFormat<R> renderer) {
            return renderer.applyAtomic(this.text);
        }

        public String toString() {
            return "Atomic[" + this.text + "]";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Atomic other = (Atomic)obj;
            return this.text.equals(other.text);
        }
    }

    public static enum ColorType {
        ERASER(Values.ERASER_FOREGROUND),
        CREATOR(Values.CREATOR_FOREGROUND),
        EMBARGO(Values.EMBARGO_FOREGROUND),
        REMARK(Values.REMARK_FOREGROUND),
        RGB(null);

        private final Color color;

        private ColorType(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static class Colored
    extends Line {
        private final ColorType type;
        private final Color color;
        private final Line subline;

        public Colored(ColorType type, Color color, Line subline) {
            assert (type == ColorType.RGB || color == type.getColor());
            this.type = type;
            this.color = color;
            this.subline = subline;
        }

        @Override
        public <R extends LineFormat.Builder<R>> R toString(LineFormat<R> renderer) {
            R subline = this.subline.toString(renderer);
            return renderer.applyColored(this.type, this.color, subline);
        }

        public String toString() {
            return "Colored[" + this.color + ", " + this.subline + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.color.hashCode();
            result = 31 * result + this.subline.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Colored other = (Colored)obj;
            if (!this.color.equals(other.color)) {
                return false;
            }
            if (!this.subline.equals(other.subline)) {
                return false;
            }
            return this.type == other.type;
        }
    }

    public static class Composed
    extends Line {
        private final Line[] fragments;

        public Composed(Line ... fragments) {
            this.fragments = fragments;
        }

        public Composed(List<Line> fragments) {
            this.fragments = new Line[fragments.size()];
            fragments.toArray(this.fragments);
        }

        @Override
        public <R extends LineFormat.Builder<R>> R toString(LineFormat<R> renderer) {
            LineFormat.Builder[] fragments = new LineFormat.Builder[this.fragments.length];
            int i = 0;
            while (i < fragments.length) {
                fragments[i] = this.fragments[i].toString(renderer);
                ++i;
            }
            return (R)renderer.applyComposed(fragments);
        }

        public String toString() {
            return "Composed[" + Arrays.toString(this.fragments) + "]";
        }

        public int hashCode() {
            return Arrays.hashCode(this.fragments);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Composed other = (Composed)obj;
            return Arrays.equals(this.fragments, other.fragments);
        }
    }

    public static class Empty
    extends Line {
        private Empty() {
        }

        @Override
        public <R extends LineFormat.Builder<R>> R toString(LineFormat<R> renderer) {
            return renderer.createResult();
        }

        public String toString() {
            return "Empty";
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    public static enum Style {
        BOLD,
        ITALIC,
        STRIKE,
        SUPER;

    }

    public static class Styled
    extends Line {
        private final Style style;
        private final Line subline;

        public Styled(Style style, Line subline) {
            this.style = style;
            this.subline = subline;
        }

        @Override
        public <R extends LineFormat.Builder<R>> R toString(LineFormat<R> renderer) {
            R subline = this.subline.toString(renderer);
            return renderer.applyStyled(this.style, subline);
        }

        public String toString() {
            return "Styled[" + (Object)((Object)this.style) + ", " + this.subline + "]";
        }
    }
}

