/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.layout;

import groove.gui.layout.JCellLayout;
import groove.gui.look.LineStyle;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualMap;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class JEdgeLayout
implements JCellLayout {
    private final Point2D labelPosition;
    private final List<Point2D> points;
    private final LineStyle lineStyle;

    public static JEdgeLayout newInstance(AttributeMap attr) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        List attrPoints = GraphConstants.getPoints((Map)attr);
        if (attrPoints == null) {
            points.add(new Point());
            points.add(new Point());
        } else {
            for (Object p : attrPoints) {
                Point2D point = null;
                if (p instanceof Point2D) {
                    point = (Point2D)p;
                } else if (p instanceof PortView) {
                    point = ((PortView)p).getLocation();
                }
                if (point == null) continue;
                points.add(point);
            }
        }
        return new JEdgeLayout(points, GraphConstants.getLabelPosition((Map)attr), LineStyle.getStyle(GraphConstants.getLineStyle((Map)attr)));
    }

    public static JEdgeLayout newInstance(VisualMap visuals) {
        return new JEdgeLayout(visuals.getPoints(), visuals.getLabelPos(), visuals.getLineStyle());
    }

    public static boolean isDefaultLabelPosition(Point2D labelPosition) {
        return labelPosition == null || labelPosition.equals(defaultLabelPosition);
    }

    public JEdgeLayout(List<Point2D> points, Point2D labelPosition, LineStyle lineStyle) {
        this.points = new LinkedList<Point2D>(points);
        this.labelPosition = labelPosition == null ? defaultLabelPosition : labelPosition;
        this.lineStyle = lineStyle;
    }

    public List<Point2D> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public Point2D getLabelPosition() {
        return this.labelPosition;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public AttributeMap toJAttr() {
        AttributeMap result = new AttributeMap();
        GraphConstants.setPoints((Map)result, this.points);
        GraphConstants.setLineStyle((Map)result, (int)this.lineStyle.getCode());
        GraphConstants.setLabelPosition((Map)result, (Point2D)(this.labelPosition == null ? defaultLabelPosition : this.labelPosition));
        return result;
    }

    @Override
    public VisualMap toVisuals() {
        VisualMap result = new VisualMap();
        if (this.points != null) {
            result.put(VisualKey.POINTS, this.points);
        }
        result.put(VisualKey.LINE_STYLE, (Object)this.lineStyle);
        if (this.labelPosition != null) {
            result.put(VisualKey.LABEL_POS, this.labelPosition);
        }
        return result;
    }

    @Override
    public boolean isDefault() {
        return VisualKey.LABEL_POS.getDefaultValue().equals(this.getLabelPosition()) && this.lineStyle.isDefault() && this.getPoints().size() == 2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JEdgeLayout) {
            JEdgeLayout other = (JEdgeLayout)obj;
            return this.getPoints().equals(other.getPoints()) && this.getLabelPosition().equals(other.getLabelPosition()) && this.getLineStyle() == other.getLineStyle();
        }
        return false;
    }

    public int hashCode() {
        return this.getPoints().hashCode() + this.getLabelPosition().hashCode() + this.getLineStyle().hashCode();
    }

    public String toString() {
        return "LabelPosition=" + this.getLabelPosition() + "; Points=" + this.getPoints() + "; LineStyle=" + (Object)((Object)this.getLineStyle());
    }
}

