/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.aspect.AspectNode;
import groove.grammar.aspect.AspectParser;
import groove.grammar.model.FormatError;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.rule.RuleLabel;
import groove.grammar.type.TypeEdge;
import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.gui.jgraph.AJEdge;
import groove.gui.jgraph.AspectJCell;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.gui.jgraph.AspectJObject;
import groove.gui.jgraph.AspectJVertex;
import groove.gui.look.Look;
import groove.gui.look.VisualKey;
import groove.io.HTMLConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class AspectJEdge
extends AJEdge<AspectGraph, AspectJGraph, AspectJModel, AspectJVertex>
implements AspectJCell {
    private AspectKind aspect;

    private AspectJEdge() {
        this.setUserObject(null);
    }

    @Override
    public AspectKind getAspect() {
        return this.aspect;
    }

    @Override
    public AspectNode getSourceNode() {
        return (AspectNode)super.getSourceNode();
    }

    @Override
    public AspectNode getTargetNode() {
        return (AspectNode)super.getTargetNode();
    }

    public boolean isNodeEdgeIn() {
        return this.getTargetVertex() != null && ((AspectJVertex)this.getTargetVertex()).isNodeEdge();
    }

    public boolean isNodeEdgeOut() {
        return this.getSourceVertex() != null && ((AspectJVertex)this.getSourceVertex()).isNodeEdge();
    }

    @Override
    public Set<AspectEdge> getEdges() {
        return super.getEdges();
    }

    @Override
    public AspectEdge getEdge() {
        return (AspectEdge)super.getEdge();
    }

    @Override
    protected void initialise() {
        super.initialise();
        this.aspect = AspectKind.DEFAULT;
    }

    @Override
    public boolean isCompatible(Edge edge) {
        if (!super.isCompatible(edge)) {
            return false;
        }
        return ((AspectEdge)edge).equalsAspects(this.getEdge());
    }

    @Override
    public void addEdge(Edge e) {
        AspectEdge edge = (AspectEdge)e;
        AspectEdge oldEdge = this.getEdge();
        if (oldEdge == null) {
            this.aspect = edge.getKind();
        }
        FormatError error = null;
        if (edge.getRole() != EdgeRole.BINARY) {
            error = new FormatError("Node label '%s' not allowed on edges", edge.label(), this);
        } else if (oldEdge != null && !edge.equalsAspects(oldEdge)) {
            error = new FormatError("Conflicting aspects in edge labels %s and %s", oldEdge.label(), edge.label(), this);
        }
        if (error != null) {
            edge = new AspectEdge((AspectNode)edge.source(), (AspectLabel)edge.label(), (AspectNode)edge.target());
            edge.addError(error);
            edge.setFixed();
        }
        super.addEdge(edge);
        this.updateLook(edge);
        this.refreshVisual(VisualKey.COLOR);
    }

    private void updateLook(AspectEdge edge) {
        RuleLabel ruleLabel = edge.getRuleLabel();
        if (ruleLabel != null) {
            if (ruleLabel.isEmpty() && this.aspect != AspectKind.CREATOR || ruleLabel.isNeg() && ruleLabel.getNegOperand().isEmpty()) {
                this.setLook(Look.NO_ARROW, true);
            } else if (!ruleLabel.isAtom()) {
                this.setLook(Look.REGULAR, true);
            }
        }
        if (edge.isComposite()) {
            this.setLook(Look.COMPOSITE, true);
        }
        this.getErrors().addErrors(edge.getErrors(), true);
        this.setStale(VisualKey.ERROR);
    }

    @Override
    StringBuilder getEdgeDescription() {
        this.getEdge().testFixed(true);
        StringBuilder result = new StringBuilder();
        if (this.hasErrors()) {
            for (FormatError error : this.getErrors()) {
                if (result.length() > 0) {
                    result.append("<br>");
                }
                result.append(error.toString());
            }
            HTMLConverter.EMBARGO_TAG.on(result);
        } else {
            AspectKind attrKind = this.getEdge().getAttrKind();
            if (attrKind == AspectKind.ARGUMENT) {
                result.append((CharSequence)new StringBuilder("Argument edge"));
            } else if (attrKind.hasSignature()) {
                result.append((CharSequence)new StringBuilder("Operation edge"));
            } else {
                result.append((CharSequence)super.getEdgeDescription());
            }
            if (AspectJModel.ROLE_DESCRIPTIONS.containsKey((Object)this.aspect)) {
                result.append("<br>" + AspectJModel.ROLE_DESCRIPTIONS.get((Object)this.aspect));
            }
        }
        return result;
    }

    @Override
    StringBuilder getEdgeKindDescription() {
        StringBuilder result = super.getEdgeKindDescription();
        if (AspectJModel.ROLE_NAMES.containsKey((Object)this.aspect)) {
            HTMLConverter.toUppercase(result, false);
            result.insert(0, " ");
            result.insert(0, AspectJModel.ROLE_NAMES.get((Object)this.aspect));
        }
        return result;
    }

    @Override
    public Collection<? extends Label> getKeys() {
        if (this.aspect.isMeta()) {
            return Collections.emptySet();
        }
        return super.getKeys();
    }

    @Override
    public TypeEdge getKey(Edge edge) {
        TypeEdge result = null;
        GraphBasedModel.TypeModelMap typeMap = this.getTypeMap();
        if (typeMap != null) {
            result = (TypeEdge)typeMap.getEdge(edge);
        }
        return result;
    }

    private GraphBasedModel.TypeModelMap getTypeMap() {
        return ((AspectJModel)((Object)this.getJModel())).getResourceModel().getTypeMap();
    }

    public boolean isSourceLabel() {
        if (((AspectJGraph)((Object)this.getJGraph())).isShowValueNodes()) {
            return false;
        }
        if (this.getSourceNode().getAttrKind().hasSignature()) {
            return false;
        }
        if (!this.getTargetNode().getAttrKind().hasSignature()) {
            return false;
        }
        if (this.getTargetNode().hasParam()) {
            return false;
        }
        return ((AspectJGraph)((Object)this.getJGraph())).getGraphRole() == GraphRole.TYPE || this.getTargetNode().getAttrAspect().hasContent();
    }

    @Override
    protected Look getStructuralLook() {
        if (this.isNodeEdgeIn()) {
            return Look.NODIFIED;
        }
        return Look.getLookFor(this.getAspect());
    }

    @Override
    public void saveToUserObject() {
        AspectJObject userObject = this.getUserObject();
        userObject.clear();
        userObject.addEdges(this.getEdges());
    }

    @Override
    public void loadFromUserObject(GraphRole role) {
        this.initialise();
        AspectParser parser = AspectParser.getInstance();
        for (String text : this.getUserObject()) {
            AspectLabel label = parser.parse(text, role);
            AspectEdge edge = new AspectEdge(this.getSourceNode(), label, this.getTargetNode());
            edge.setFixed();
            this.addEdge(edge);
        }
        this.setStale(VisualKey.refreshables());
    }

    @Override
    public void setUserObject(Object value) {
        AspectJObject myObject = new AspectJObject();
        if (value instanceof AspectJObject) {
            myObject.addAll((AspectJObject)value);
        } else if (value != null) {
            myObject.load(value.toString());
        }
        super.setUserObject((Object)myObject);
    }

    @Override
    public AspectJObject getUserObject() {
        return (AspectJObject)super.getUserObject();
    }

    public static AspectJEdge newInstance() {
        return new AspectJEdge();
    }
}

