/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.Graph;
import groove.graph.Label;
import groove.graph.Node;
import groove.gui.jgraph.AJCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JModel;
import groove.gui.jgraph.JVertex;
import groove.io.HTMLConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.graph.DefaultPort;

public abstract class AJVertex<G extends Graph, JG extends JGraph<G>, JM extends JModel<G>, JE extends JEdge<G>>
extends AJCell<G, JG, JM>
implements JVertex<G> {
    private Node node;

    protected AJVertex() {
        this.add((MutableTreeNode)new DefaultPort());
    }

    @Override
    public Set<JE> getContext() {
        return this.getPort().getEdges();
    }

    @Override
    public void setNode(Node node) {
        this.node = node;
        this.initialise();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public DefaultPort getPort() {
        return (DefaultPort)this.getFirstChild();
    }

    @Override
    public JVertex<G> clone() {
        AJVertex clone = (AJVertex)super.clone();
        clone.initialise();
        return clone;
    }

    @Override
    public boolean isCompatible(Edge edge) {
        if (this.getLayout(edge) != null) {
            return false;
        }
        if (edge.getRole() != EdgeRole.BINARY) {
            return true;
        }
        return ((JGraph)((Object)this.getJGraph())).isShowLoopsAsNodeLabels() && edge.source() == edge.target() && edge.source() == this.getNode();
    }

    @Override
    public Collection<? extends Label> getKeys() {
        ArrayList<Label> result = new ArrayList<Label>();
        for (Edge edge : this.getEdges()) {
            Label key = this.getKey(edge);
            if (key == null) continue;
            result.add(key);
        }
        result.addAll(this.getNodeKeys(!result.isEmpty()));
        return result;
    }

    protected Collection<? extends Label> getNodeKeys(boolean hasEdgeKeys) {
        return Collections.emptySet();
    }

    @Override
    public Label getKey(Edge edge) {
        return edge.label();
    }

    @Override
    public String getNodeIdString() {
        return this.getNode().toString();
    }

    StringBuilder getNodeDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Node");
        String id = this.getNodeIdString();
        if (id != null) {
            result.append(" ");
            result.append(HTMLConverter.ITALIC_TAG.on(id));
        }
        return result;
    }

    @Override
    public int getNumber() {
        return this.getNode().getNumber();
    }

    public String toString() {
        return String.format("%s %d with labels %s", this.getClass().getSimpleName(), this.getNumber(), this.getKeys());
    }

    @Override
    public String getToolTipText() {
        return HTMLConverter.HTML_TAG.on(this.getNodeDescription()).toString();
    }
}

