/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.grammar.model.FormatError;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleLabel;
import groove.graph.Graph;
import groove.graph.Label;
import groove.graph.Node;
import groove.gui.jgraph.AJCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JModel;
import groove.gui.jgraph.JVertex;
import groove.gui.layout.JEdgeLayout;
import groove.gui.look.Look;
import groove.gui.look.MultiLabel;
import groove.gui.look.Values;
import groove.io.HTMLConverter;
import groove.util.Groove;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;

public abstract class AJEdge<G extends Graph, JG extends JGraph<G>, JM extends JModel<G>, JV extends JVertex<G>>
extends AJCell<G, JG, JM>
implements Edge,
JEdge<G> {
    private DefaultPort sourcePort;
    private DefaultPort targetPort;
    private Node sourceNode;
    private Node targetNode;

    protected AJEdge() {
    }

    @Override
    protected void initialise() {
        super.initialise();
        this.sourceNode = null;
        this.targetNode = null;
    }

    @Override
    public JEdge<G> clone() {
        AJEdge clone = (AJEdge)super.clone();
        clone.initialise();
        return clone;
    }

    public DefaultPort getSource() {
        return this.sourcePort;
    }

    public DefaultPort getTarget() {
        return this.targetPort;
    }

    public void setSource(Object port) {
        this.sourcePort = (DefaultPort)port;
    }

    public void setTarget(Object port) {
        this.targetPort = (DefaultPort)port;
    }

    @Override
    public Node getSourceNode() {
        if (this.sourceNode == null) {
            this.sourceNode = this.getSourceVertex().getNode();
        }
        return this.sourceNode;
    }

    @Override
    public Node getTargetNode() {
        if (this.targetNode == null) {
            this.targetNode = this.getTargetVertex().getNode();
        }
        return this.targetNode;
    }

    public String toString() {
        return String.format("%s with labels %s", this.getClass().getSimpleName(), this.getKeys());
    }

    @Override
    public void addEdge(groove.graph.Edge edge) {
        if (this.getEdges().isEmpty()) {
            this.sourceNode = edge.source();
            this.targetNode = edge.target();
        }
        super.addEdge(edge);
        MultiLabel.Direct direct = this.getDirect(edge);
        if (direct == MultiLabel.Direct.NONE) {
            this.setLook(Look.NO_ARROW, true);
        } else if (direct == MultiLabel.Direct.BACKWARD) {
            this.setLook(Look.BIDIRECTIONAL, true);
        }
    }

    @Override
    public boolean isCompatible(groove.graph.Edge edge) {
        if (edge.source() == this.getSourceNode() && edge.target() == this.getTargetNode() && !this.getLooks().contains((Object)Look.BIDIRECTIONAL)) {
            return true;
        }
        if (edge.source() == this.getTargetNode() && edge.target() == this.getSourceNode()) {
            return ((JModel)((Object)this.getJModel())).isMergeBidirectionalEdges() && this.getEdges().size() == 1 && edge.label().equals(this.getEdge().label());
        }
        return false;
    }

    protected boolean isLayoutCompatible(groove.graph.Edge edge) {
        JEdgeLayout edgeLayout = this.getLayout(edge);
        JEdgeLayout myLayout = this.getLayout(this.getEdge());
        if (myLayout == null) {
            return edgeLayout == null;
        }
        if (myLayout.equals(edgeLayout)) {
            return true;
        }
        return myLayout.getPoints().size() == 2 && (edgeLayout == null || edgeLayout.getPoints().size() == 2);
    }

    @Override
    public boolean isLoop() {
        return this.sourceNode == this.targetNode;
    }

    @Override
    public String getToolTipText() {
        return HTMLConverter.HTML_TAG.on(this.getEdgeDescription()).toString();
    }

    @Override
    public groove.graph.Edge getEdge() {
        return this.getEdges().isEmpty() ? null : this.getEdges().iterator().next();
    }

    @Override
    public MultiLabel.Direct getDirect(groove.graph.Edge edge) {
        boolean regular = false;
        if (edge instanceof RuleEdge) {
            RuleLabel label = (RuleLabel)((RuleEdge)edge).label();
            boolean bl = regular = label.isEmpty() || label.isNeg() && label.getNegOperand().isEmpty();
        }
        MultiLabel.Direct result = regular ? MultiLabel.Direct.NONE : (edge == null || this.getSourceNode().equals(edge.source()) ? MultiLabel.Direct.FORWARD : MultiLabel.Direct.BACKWARD);
        return result;
    }

    @Override
    public Collection<? extends Label> getKeys() {
        ArrayList<Label> result = new ArrayList<Label>();
        for (groove.graph.Edge edge : this.getEdges()) {
            Label entry = this.getKey(edge);
            if (entry == null) continue;
            result.add(entry);
        }
        return result;
    }

    @Override
    public Label getKey(groove.graph.Edge edge) {
        return edge.label();
    }

    StringBuilder getEdgeDescription() {
        String targetIdentity;
        String sourceIdentity;
        StringBuilder result = this.getEdgeKindDescription();
        if (this.getKeys().size() > 1) {
            HTMLConverter.toUppercase(result, false);
            result.insert(0, "Multiple ");
            result.append("s");
        }
        if ((sourceIdentity = this.getSourceVertex().getNodeIdString()) != null) {
            result.append(" from ");
            result.append(HTMLConverter.ITALIC_TAG.on(sourceIdentity));
        }
        if ((targetIdentity = this.getTargetVertex().getNodeIdString()) != null) {
            result.append(" to ");
            result.append(HTMLConverter.ITALIC_TAG.on(targetIdentity));
        }
        if (this.hasErrors()) {
            HTMLConverter.HTMLTag errorTag = HTMLConverter.createColorTag(Values.ERROR_NORMAL_FOREGROUND);
            for (FormatError error : this.getErrors()) {
                result.append(HTMLConverter.HTML_LINEBREAK);
                result.append(errorTag.on(error));
            }
        }
        return result;
    }

    StringBuilder getEdgeKindDescription() {
        return new StringBuilder("Graph edge");
    }

    String getLabelDescription() {
        StringBuffer result = new StringBuffer();
        Object[] displayedLabels = new String[this.getKeys().size()];
        int labelIndex = 0;
        for (Label label : this.getKeys()) {
            displayedLabels[labelIndex] = HTMLConverter.STRONG_TAG.on(label.toString(), true);
            ++labelIndex;
        }
        if (displayedLabels.length == 0) {
            result.append(" (unlabelled)");
        } else {
            result.append(", labelled ");
            result.append(Groove.toString(displayedLabels, "", "", ", ", " and "));
        }
        return result.toString();
    }

    public JV getSourceVertex() {
        DefaultPort source = this.getSource();
        return (JV)(source == null ? null : (JVertex)((Object)source.getParent()));
    }

    public JV getTargetVertex() {
        DefaultPort target = this.getTarget();
        return (JV)(target == null ? null : (JVertex)((Object)target.getParent()));
    }

    @Override
    public Set<JV> getContext() {
        Set<JV> result;
        if (this.isLoop()) {
            result = Collections.singleton(this.getSourceVertex());
        } else {
            result = new HashSet<JV>();
            result.add(this.getSourceVertex());
            result.add(this.getTargetVertex());
        }
        return result;
    }
}

