/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.model.ResourceKind;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorModel;
import groove.gui.action.CollapseAllAction;
import groove.gui.display.Display;
import groove.gui.display.ResourceDisplay;
import groove.gui.tree.RuleTree;
import groove.lts.GraphState;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public final class RuleDisplay
extends ResourceDisplay {
    private final JLabel statusLine = new JLabel(" ");
    private JButton collapseAllButton;

    RuleDisplay(Simulator simulator) {
        super(simulator, ResourceKind.RULE);
    }

    @Override
    protected void installListeners() {
        this.getSimulatorModel().addListener(this, SimulatorModel.Change.ABSTRACT, SimulatorModel.Change.STATE);
        super.installListeners();
    }

    @Override
    protected JToolBar createListToolBar() {
        int separation = 7;
        JToolBar result = super.createListToolBar(separation);
        result.add(this.getActions().getShiftPriorityAction(true));
        result.add(this.getActions().getShiftPriorityAction(false));
        result.addSeparator(new Dimension(separation, 0));
        result.add(this.getCollapseAllButton());
        return result;
    }

    @Override
    public RuleTree getList() {
        return (RuleTree)super.getList();
    }

    @Override
    public RuleTree createList() {
        return new RuleTree(this);
    }

    @Override
    protected Display.ListPanel createListPanel() {
        Display.ListPanel result = super.createListPanel();
        result.add((Component)this.statusLine, "South");
        return result;
    }

    @Override
    protected void resetList() {
        this.getList().dispose();
        super.resetList();
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        super.update(source, oldModel, changes);
        if (this.suspendListening()) {
            if (changes.contains((Object)SimulatorModel.Change.ABSTRACT) && source.isAbstractionMode()) {
                this.resetList();
            }
            if (changes.contains((Object)SimulatorModel.Change.STATE)) {
                GraphState state = source.getState();
                String statusText = state == null ? "No state selected" : "Matches for state " + state;
                this.statusLine.setText(statusText);
            }
            this.activateListening();
        }
    }

    private JButton getCollapseAllButton() {
        if (this.collapseAllButton == null) {
            this.collapseAllButton = Options.createButton(new CollapseAllAction(this.getSimulator(), this.getList()));
        }
        return this.collapseAllButton;
    }
}

