/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.gui.display.Display;
import groove.gui.display.DisplaysPanel;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

class DisplayWindow
extends JFrame {
    private final Kind kind;
    private JComponent contentPanel;
    private JSplitPane displayInfoPanel;
    private DisplaysPanel parent;
    private Display display;
    private static final Dimension MINIMUM_SIZE = new Dimension(500, 300);

    private DisplayWindow(Kind kind, String title, ImageIcon icon) {
        super(title);
        this.kind = kind;
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setAlwaysOnTop(true);
        this.setMinimumSize(MINIMUM_SIZE);
        this.getContentPane().setMinimumSize(MINIMUM_SIZE);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DisplayWindow.this.doClosingAction();
                super.windowClosing(e);
            }
        });
    }

    public DisplayWindow(DisplaysPanel parent, Display display) {
        this(Kind.DISPLAY, display.getKind().getTitle(), display.getKind().getTabIcon());
        this.parent = parent;
        this.display = display;
        this.setContentPane(this.getContentPanel());
        this.pack();
        this.setVisible(true);
    }

    JComponent getContentPanel() {
        JComponent result = this.contentPanel;
        if (result == null) {
            Display.ListPanel listPanel = this.display.getListPanel();
            JSplitPane displayPanel = this.getDisplayInfoPanel();
            result = listPanel == null ? displayPanel : new JSplitPane(1, listPanel, displayPanel);
            this.contentPanel = result;
        }
        return result;
    }

    JSplitPane getDisplayInfoPanel() {
        JSplitPane result = this.displayInfoPanel;
        if (result == null) {
            JComponent infoPanel = this.display.getInfoPanel();
            result = new JSplitPane(1);
            result.setBorder(null);
            result.setResizeWeight(0.9);
            result.setLeftComponent(this.display);
            result.setRightComponent(infoPanel);
            infoPanel.setVisible(true);
            this.displayInfoPanel = result;
        }
        return result;
    }

    private void doClosingAction() {
        switch (this.kind) {
            case DISPLAY: {
                this.parent.attach(this.display);
            }
        }
    }

    private static enum Kind {
        DISPLAY,
        STATE;

    }
}

