/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.explore.AcceptorEnumerator;
import groove.explore.AcceptorValue;
import groove.explore.Exploration;
import groove.explore.StrategyEnumerator;
import groove.explore.StrategyValue;
import groove.explore.encode.EncodedTypeEditor;
import groove.explore.encode.Serialized;
import groove.explore.encode.TemplateListener;
import groove.explore.result.Acceptor;
import groove.explore.strategy.Strategy;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.gui.Simulator;
import groove.gui.SimulatorModel;
import groove.gui.dialog.ErrorDialog;
import groove.gui.layout.SpringUtilities;
import groove.io.HTMLConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.ToolTipManager;

public class ExplorationDialog
extends JDialog
implements TemplateListener {
    private static final String DEFAULT_COMMAND = "Set Default";
    private static final String START_COMMAND = "Start";
    private static final String EXPLORE_COMMAND = "Run";
    private static final String CANCEL_COMMAND = "Cancel";
    private static final String RESULT_TOOLTIP = "<HTML>Exploration can be interrupted between atomic steps of the strategy.<BR> The size of the atomic steps depends on the chosen strategy.<BR> The interruption condition is determined by the indicated number of times that the acceptor succeeds.</HTML>";
    private static final String START_TOOLTIP = "Restart with the customized exploration";
    private static final String DEFAULT_TOOLTIP = "Set the currently selected exploration as the default for this grammar";
    private static final String EXPLORE_TOOLTIP = "Run the customized exploration on the currently explored state space";
    public static final String HEADER_COLOR = "green";
    public static final String INFO_COLOR = "#005050";
    public static final Color INFO_BG_COLOR = new Color(230, 230, 255);
    public static final Color INFO_BOX_BG_COLOR = new Color(210, 210, 255);
    private final EncodedTypeEditor<Strategy, Serialized> strategyEditor;
    private final EncodedTypeEditor<Acceptor, Serialized> acceptorEditor;
    private ResultPanel resultPanel;
    private RefreshButton defaultButton;
    private RefreshButton startButton;
    private RefreshButton exploreButton;
    private RefreshButton cancelButton;
    private final List<RefreshButton> buttons;
    private final Simulator simulator;
    private final int oldDismissDelay;

    public ExplorationDialog(Simulator simulator, JFrame owner) {
        super(owner, "Customize Exploration ...", true);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.oldDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
        ToolTipManager.sharedInstance().setDismissDelay(1000000000);
        this.simulator = simulator;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ExplorationDialog.this.closeDialog();
            }
        });
        JPanel dialogContent = new JPanel(new SpringLayout());
        dialogContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        dialogContent.registerKeyboardAction(this.createCloseListener(), escape, 2);
        dialogContent.registerKeyboardAction(this.createExploreListener(), enter, 2);
        StrategyEnumerator strategyEnumerator = StrategyEnumerator.newInstance();
        strategyEnumerator.setMask(StrategyValue.DIALOG_STRATEGIES);
        this.strategyEditor = strategyEnumerator.createEditor(this.getGrammar());
        Serialized defaultStrategy = this.getSimulatorModel().getExploration().getStrategy();
        AcceptorEnumerator acceptorEnumerator = AcceptorEnumerator.newInstance();
        HashSet<AcceptorValue> acceptorMask = new HashSet<AcceptorValue>(EnumSet.allOf(AcceptorValue.class));
        acceptorMask.remove(AcceptorValue.CYCLE);
        acceptorEnumerator.setMask(acceptorMask);
        this.acceptorEditor = acceptorEnumerator.createEditor(this.getGrammar());
        Serialized defaultAcceptor = this.getSimulatorModel().getExploration().getAcceptor();
        this.strategyEditor.setCurrentValue(defaultStrategy);
        this.acceptorEditor.setCurrentValue(defaultAcceptor);
        this.strategyEditor.addTemplateListener(this);
        this.acceptorEditor.addTemplateListener(this);
        JPanel selectors = new JPanel(new SpringLayout());
        selectors.add(this.strategyEditor);
        selectors.add(this.acceptorEditor);
        SpringUtilities.makeCompactGrid(selectors, 1, 2, 0, 0, 15, 0);
        dialogContent.add(selectors);
        dialogContent.add(new JLabel(" "));
        dialogContent.add(this.createResultPanel());
        dialogContent.add(new JLabel(" "));
        dialogContent.add(this.createButtonPanel());
        SpringUtilities.makeCompactGrid(dialogContent, 5, 1, 0, 0, 0, 0);
        this.add(dialogContent);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.buttons = this.createButtons();
        this.refreshButtons();
        this.setVisible(true);
    }

    private void closeDialog() {
        this.dispose();
        ToolTipManager.sharedInstance().setDismissDelay(this.oldDismissDelay);
    }

    private void startExploration() {
        this.getSimulatorModel().setGts();
        this.doExploration();
    }

    private void doExploration() {
        try {
            this.getSimulatorModel().setExploration(this.createExploration());
            this.closeDialog();
            this.simulator.getActions().getExploreAction().execute();
        }
        catch (FormatException exc) {
            this.showError(exc);
        }
    }

    private void showError(FormatException exc) {
        new ErrorDialog((Component)this.simulator.getFrame(), "<HTML><B>Invalid exploration.</B><BR> " + exc.getMessage(), exc).setVisible(true);
    }

    private Exploration createExploration() {
        Exploration result = null;
        Serialized strategy = this.strategyEditor.getCurrentValue();
        Serialized acceptor = this.acceptorEditor.getCurrentValue();
        if (strategy != null && acceptor != null) {
            int nrResults = this.resultPanel.getSelectedValue();
            result = new Exploration(strategy, acceptor, nrResults);
        }
        return result;
    }

    private void setDefaultExploration() {
        try {
            Exploration exploration = this.createExploration();
            exploration.test(this.getGrammar().toGrammar());
            this.getSimulatorModel().doSetDefaultExploration(exploration);
            this.strategyEditor.refresh();
            this.acceptorEditor.refresh();
        }
        catch (FormatException exc) {
            this.showError(exc);
        }
        catch (IOException iOException) {}
    }

    private ActionListener createCloseListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExplorationDialog.this.closeDialog();
            }
        };
    }

    private ActionListener createExploreListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExplorationDialog.this.doExploration();
            }
        };
    }

    private ResultPanel createResultPanel() {
        this.resultPanel = new ResultPanel(RESULT_TOOLTIP, this.getSimulatorModel().getExploration().getNrResults());
        return this.resultPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.getDefaultButton());
        buttonPanel.add(this.getStartButton());
        buttonPanel.add(this.getExploreButton());
        buttonPanel.add(this.getCancelButton());
        return buttonPanel;
    }

    @Override
    public void templateEdited() {
        this.refreshButtons();
    }

    private void refreshButtons() {
        Exploration exploration = this.createExploration();
        for (RefreshButton button : this.buttons) {
            button.refresh(exploration);
        }
    }

    private List<RefreshButton> createButtons() {
        ArrayList<RefreshButton> result = new ArrayList<RefreshButton>();
        result.add(this.getDefaultButton());
        result.add(this.getStartButton());
        result.add(this.getExploreButton());
        result.add(this.getCancelButton());
        return result;
    }

    private RefreshButton getDefaultButton() {
        if (this.defaultButton == null) {
            this.defaultButton = new RefreshButton(DEFAULT_COMMAND){

                @Override
                public void execute() {
                    ExplorationDialog.this.setDefaultExploration();
                }

                @Override
                public void refresh(Exploration exploration) {
                    this.setEnabled(ExplorationDialog.DEFAULT_TOOLTIP, exploration);
                }
            };
            this.defaultButton.setToolTipText(DEFAULT_TOOLTIP);
        }
        return this.defaultButton;
    }

    private RefreshButton getStartButton() {
        if (this.startButton == null) {
            this.startButton = new RefreshButton(START_COMMAND){

                @Override
                public void execute() {
                    ExplorationDialog.this.startExploration();
                }

                @Override
                public void refresh(Exploration exploration) {
                    this.setEnabled(ExplorationDialog.START_TOOLTIP, exploration);
                }
            };
        }
        return this.startButton;
    }

    private RefreshButton getExploreButton() {
        if (this.exploreButton == null) {
            this.exploreButton = new RefreshButton(EXPLORE_COMMAND){

                @Override
                public void execute() {
                    ExplorationDialog.this.doExploration();
                }

                @Override
                public void refresh(Exploration exploration) {
                    this.setEnabled(ExplorationDialog.EXPLORE_TOOLTIP, exploration);
                }
            };
        }
        return this.exploreButton;
    }

    private RefreshButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new RefreshButton(CANCEL_COMMAND){

                @Override
                public void execute() {
                    ExplorationDialog.this.closeDialog();
                }

                @Override
                public void refresh(Exploration exploration) {
                }
            };
        }
        return this.cancelButton;
    }

    private SimulatorModel getSimulatorModel() {
        return this.simulator.getModel();
    }

    private GrammarModel getGrammar() {
        return this.getSimulatorModel().getGrammar();
    }

    private abstract class RefreshButton
    extends JButton {
        public RefreshButton(String text) {
            super(text);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RefreshButton.this.execute();
                }
            });
        }

        public abstract void execute();

        public abstract void refresh(Exploration var1);

        protected void setEnabled(String toolTipText, Exploration exploration) {
            GrammarModel grammar = ExplorationDialog.this.getGrammar();
            boolean enabled = exploration != null && grammar != null && !grammar.hasErrors();
            StringBuilder toolTip = new StringBuilder(toolTipText);
            if (enabled) {
                try {
                    exploration.test(grammar.toGrammar());
                }
                catch (FormatException exc) {
                    enabled = false;
                    toolTip.append(HTMLConverter.HTML_LINEBREAK);
                    toolTip.append((CharSequence)HTMLConverter.EMBARGO_TAG.on(HTMLConverter.toHtml(new StringBuilder(exc.getMessage()))));
                }
            }
            this.setEnabled(enabled);
            this.setToolTipText(HTMLConverter.HTML_TAG.on(toolTip).toString());
        }
    }

    private static class ResultPanel
    extends JPanel
    implements ActionListener {
        JRadioButton[] checkboxes = new JRadioButton[3];
        JTextField customNumber;

        public ResultPanel(String tooltip, int initialValue) {
            super(new SpringLayout());
            this.checkboxes[0] = new JRadioButton("Infinite (don't interrupt)");
            this.checkboxes[1] = new JRadioButton("1 (interrupt as soon as acceptor succeeds)");
            this.checkboxes[2] = new JRadioButton("Custom: ");
            int i = 0;
            while (i < 3) {
                this.checkboxes[i].addActionListener(this);
                ++i;
            }
            String initialCustomValue = "2";
            if (initialValue == 0) {
                this.checkboxes[0].setSelected(true);
            } else if (initialValue == 1) {
                this.checkboxes[1].setSelected(true);
            } else {
                this.checkboxes[2].setSelected(true);
                initialCustomValue = Integer.toString(initialValue);
            }
            this.customNumber = new JTextField(initialCustomValue, 3);
            this.customNumber.addKeyListener(new OnlyListenToNumbers());
            this.customNumber.setEnabled(initialValue >= 2);
            JLabel leadingLabel = new JLabel("<HTML><FONT color=green><B>Interrupt exploration when the following number of accepted results have been found: </HTML>");
            leadingLabel.setToolTipText(tooltip);
            this.add(leadingLabel);
            ButtonGroup options = new ButtonGroup();
            JPanel optionsLine = new JPanel(new SpringLayout());
            int i2 = 0;
            while (i2 < 3) {
                optionsLine.add(this.checkboxes[i2]);
                if (i2 < 2) {
                    optionsLine.add(Box.createRigidArea(new Dimension(25, 0)));
                }
                options.add(this.checkboxes[i2]);
                ++i2;
            }
            optionsLine.add(this.customNumber);
            optionsLine.add(Box.createRigidArea(new Dimension(50, 0)));
            SpringUtilities.makeCompactGrid(optionsLine, 1, 7, 0, 0, 0, 0);
            this.add(optionsLine);
            SpringUtilities.makeCompactGrid(this, 2, 1, 0, 0, 0, 0);
        }

        public Integer getSelectedValue() {
            if (this.checkboxes[0].isSelected()) {
                return 0;
            }
            if (this.checkboxes[1].isSelected()) {
                return 1;
            }
            if (this.checkboxes[2].isSelected()) {
                return Integer.parseInt(this.customNumber.getText());
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.checkboxes[0]) {
                this.customNumber.setEnabled(false);
            }
            if (e.getSource() == this.checkboxes[1]) {
                this.customNumber.setEnabled(false);
            }
            if (e.getSource() == this.checkboxes[2]) {
                this.customNumber.setEnabled(true);
            }
        }

        private static class OnlyListenToNumbers
        extends KeyAdapter {
            private OnlyListenToNumbers() {
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                char ch = evt.getKeyChar();
                if (!Character.isDigit(ch)) {
                    evt.consume();
                }
            }
        }
    }
}

