/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class NewGrammarAction
extends SimulatorAction {
    public NewGrammarAction(Simulator simulator) {
        super(simulator, "New Grammar ...", null);
    }

    @Override
    public void execute() {
        File grammarFile = this.getLastGrammarFile();
        File newGrammar = grammarFile == null ? new File("newGrammar") : new File(grammarFile.getParentFile(), "newGrammar");
        JFileChooser fileChooser = this.getGrammarFileChooser(false);
        fileChooser.setSelectedFile(newGrammar);
        boolean ok = false;
        while (!ok) {
            if (fileChooser.showDialog(this.getFrame(), "New") == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                if (selectedFile.exists()) {
                    int response = JOptionPane.showConfirmDialog(this.getFrame(), String.format("Load existing grammar %s?", selectedFile.getName()));
                    if (response == 0) {
                        try {
                            this.getActions().getLoadGrammarAction().load(selectedFile);
                        }
                        catch (IOException exc) {
                            this.showErrorDialog(exc, exc.getMessage(), new Object[0]);
                        }
                    }
                    ok = response != 1;
                    continue;
                }
                if (!this.getDisplaysPanel().saveAllEditors(true)) continue;
                try {
                    this.getSimulatorModel().doNewGrammar(selectedFile);
                }
                catch (IOException exc) {
                    this.showErrorDialog(exc, String.format("Error while creating grammar at '%s'", grammarFile), new Object[0]);
                }
                ok = true;
                continue;
            }
            ok = true;
        }
    }

    @Override
    public void refresh() {
        this.setEnabled(true);
    }
}

