/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.grammar.model.RuleModel;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.store.EditType;
import java.io.IOException;
import java.util.Set;

public class EnableAction
extends SimulatorAction {
    public EnableAction(Simulator simulator, ResourceKind resource) {
        super(simulator, EditType.ENABLE, resource);
        if (resource == ResourceKind.HOST) {
            this.putValue("Name", "Use as Start Graph");
            this.putValue("ShortDescription", "Use as Start Graph");
        }
    }

    @Override
    public void execute() {
        ResourceKind resource = this.getResourceKind();
        Set<String> names = this.getSimulatorModel().getSelectSet(resource);
        boolean proceed = true;
        for (String name : names) {
            if (this.getDisplay().saveEditor(name, true, false)) continue;
            proceed = false;
            break;
        }
        if (proceed) {
            try {
                this.getSimulatorModel().doEnable(resource, names);
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, "Error during %s enabling", this.getResourceKind().getDescription());
            }
        }
    }

    @Override
    public void refresh() {
        boolean enabled;
        ResourceKind resourceKind = this.getResourceKind();
        String name = this.getSimulatorModel().getSelected(resourceKind);
        ResourceModel<?> resource = this.getSimulatorModel().getResource(resourceKind);
        boolean isEnabling = resource == null || !resource.isEnabled();
        boolean bl = enabled = resourceKind.isEnableable() && name != null && this.getGrammarStore().isModifiable();
        if (enabled && this.getResourceKind() == ResourceKind.RULE) {
            enabled = !((RuleModel)resource).hasRecipes();
        }
        String description = Options.getEnableName(resourceKind, isEnabling);
        this.putValue("Name", description);
        this.putValue("ShortDescription", description);
        this.setEnabled(enabled);
    }
}

