/*
 * Decompiled with CFR 0.152.
 */
package groove.gui;

import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.action.ActionStore;
import groove.gui.action.SimulatorAction;
import groove.io.store.SystemStore;
import java.util.Set;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public final class SimulatorUndoManager
extends UndoManager
implements SimulatorListener {
    private final ActionStore actions;

    public SimulatorUndoManager(Simulator simulator) {
        this.actions = simulator.getActions();
        simulator.getModel().addListener(this, new SimulatorModel.Change[0]);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        super.undoableEditHappened(e);
        this.refreshActions();
    }

    @Override
    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.refreshActions();
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        super.redo();
        this.refreshActions();
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        super.undo();
        this.refreshActions();
    }

    @Override
    public SystemStore.Edit editToBeUndone() {
        return (SystemStore.Edit)super.editToBeUndone();
    }

    @Override
    public SystemStore.Edit editToBeRedone() {
        return (SystemStore.Edit)super.editToBeRedone();
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        if (changes.contains((Object)SimulatorModel.Change.GRAMMAR) && source.getGrammar() != oldModel.getGrammar()) {
            this.discardAllEdits();
            if (oldModel.getGrammar() != null) {
                oldModel.getStore().removeUndoableEditListener(this);
            }
            if (source.getGrammar() != null) {
                source.getStore().addUndoableEditListener(this);
            }
        }
    }

    private void refreshActions() {
        this.getUndoAction().refresh();
        this.getRedoAction().refresh();
    }

    private SimulatorAction getRedoAction() {
        return this.actions.getRedoAction();
    }

    private SimulatorAction getUndoAction() {
        return this.actions.getUndoAction();
    }
}

