/*
 * Decompiled with CFR 0.152.
 */
package groove.gui;

import apple.dts.samplecode.osxadapter.OSXAdapter;
import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.HostModel;
import groove.grammar.model.ResourceKind;
import groove.graph.Element;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.SimulatorHistory;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.SimulatorUndoManager;
import groove.gui.StepHistory;
import groove.gui.UserSettings;
import groove.gui.action.AboutAction;
import groove.gui.action.ActionStore;
import groove.gui.dialog.ErrorDialog;
import groove.gui.dialog.GraphPreviewDialog;
import groove.gui.display.DisplayKind;
import groove.gui.display.DisplaysPanel;
import groove.gui.display.GraphEditorTab;
import groove.gui.display.GraphTab;
import groove.gui.display.JGraphPanel;
import groove.gui.display.ResourceTab;
import groove.gui.display.TextTab;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.JGraph;
import groove.gui.list.ListPanel;
import groove.gui.list.ListTabbedPane;
import groove.gui.list.SearchResult;
import groove.gui.menu.ModelCheckingMenu;
import groove.gui.menu.MyJMenu;
import groove.io.FileType;
import groove.util.Groove;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class Simulator
implements SimulatorListener {
    private ListTabbedPane resultsPanel;
    private Options options;
    private final SimulatorModel model = new SimulatorModel();
    private final ActionStore actions = new ActionStore(this);
    private JFrame frame;
    private StepHistory stepHistory;
    private DisplaysPanel displaysPanel;
    private JSplitPane contentPanel;
    private JSplitPane grammarPanel;
    private JSplitPane displaysInfoPanel;
    private JSplitPane listsPanel;
    private SimulatorHistory history;
    private JMenu externalMenu;
    private RefreshableMenuItem exportMenuItem;
    private RefreshableMenuItem saveMenuItem;
    private Action dummyExternalAction;
    private RefreshableMenuItem editGraphItem;
    private RefreshableMenuItem copyGraphItem;
    private RefreshableMenuItem deleteGraphItem;
    private RefreshableMenuItem renameMenuItem;
    private RefreshableMenuItem enableMenuItem;
    private List<RefreshableMenuItem> menuItems;
    private final SimulatorUndoManager undoManager;
    public static final String LTS_FILE_NAME = "lts";
    public static final String NEW_GRAMMAR_NAME = "newGrammar";
    public static final String NEW_GRAPH_NAME = "newGraph";
    public static final String NEW_PROLOG_NAME = "newProlog";
    public static final String NEW_RULE_NAME = "newRule";
    private static final String TITLE_NAME_SEPARATOR = "@";
    private static final String APPLICATION_NAME = "Production Simulator";

    public Simulator() {
        this.model.addListener(this, SimulatorModel.Change.GRAMMAR, SimulatorModel.Change.DISPLAY);
        this.undoManager = new SimulatorUndoManager(this);
        GraphPreviewDialog.setSimulator(this);
        this.getFrame();
        this.actions.initialiseRemainingActions();
    }

    public Simulator(String grammarLocation) {
        this();
        if (grammarLocation != null) {
            final File location = new File(FileType.GRAMMAR_FILTER.addExtension(grammarLocation)).getAbsoluteFile();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Simulator.this.actions.getLoadGrammarAction().load(location);
                    }
                    catch (IOException exc) {
                        new ErrorDialog((Component)Simulator.this.getFrame(), exc.getMessage(), exc).setVisible(true);
                    }
                }
            });
        }
    }

    public void start() {
        this.getActions().refreshActions();
        this.refreshMenuItems();
        this.getFrame().pack();
        UserSettings.applyUserSettings(this);
        this.getFrame().setVisible(true);
    }

    public ActionStore getActions() {
        return this.actions;
    }

    public StepHistory getSimulationHistory() {
        if (this.stepHistory == null) {
            this.stepHistory = new StepHistory(this);
        }
        return this.stepHistory;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        if (changes.contains((Object)SimulatorModel.Change.GRAMMAR)) {
            this.setTitle();
            FormatErrorSet grammarErrors = this.getModel().getGrammar().getErrors();
            this.setErrors(grammarErrors);
        }
        if (changes.contains((Object)SimulatorModel.Change.DISPLAY)) {
            this.refreshMenuItems();
            this.adjustInfoPanel(source.getDisplay());
        }
    }

    private void setErrors(FormatErrorSet grammarErrors) {
        this.getResultsPanel().getErrorListPanel().setEntries(grammarErrors);
        this.adjustResultsPanel();
    }

    public void setSearchResults(List<SearchResult> searchResults) {
        this.getResultsPanel().getSearchResultListPanel().setEntries(searchResults);
        this.adjustResultsPanel();
    }

    public void tryQuit() {
        this.getActions().getQuitAction().execute();
    }

    public JFrame getFrame() {
        if (this.frame == null) {
            Options.initLookAndFeel();
            this.frame = new JFrame(APPLICATION_NAME);
            this.frame.setIconImage(Icons.GROOVE_ICON_16x16.getImage());
            this.frame.setDefaultCloseOperation(0);
            if (Groove.IS_PLATFORM_MAC) {
                try {
                    OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("tryQuit", new Class[0]));
                }
                catch (NoSuchMethodException e1) {
                    e1.printStackTrace();
                }
            }
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Simulator.this.actions.getQuitAction().execute();
                }
            });
            this.frame.setJMenuBar(this.createMenuBar());
            this.frame.setContentPane(this.getContentPanel());
            ToolTipManager.sharedInstance().registerComponent(this.getContentPanel());
        }
        return this.frame;
    }

    public DisplaysPanel getDisplaysPanel() {
        if (this.displaysPanel == null) {
            this.displaysPanel = new DisplaysPanel(this);
        }
        return this.displaysPanel;
    }

    JSplitPane getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JSplitPane(0);
            this.contentPanel.setTopComponent(this.getGrammarPanel());
            this.contentPanel.setResizeWeight(0.8);
            this.contentPanel.setDividerSize(0);
            this.contentPanel.setContinuousLayout(true);
        }
        return this.contentPanel;
    }

    JSplitPane getGrammarPanel() {
        if (this.grammarPanel == null) {
            this.grammarPanel = new JSplitPane(1, this.getListsPanel(), this.getDisplaysInfoPanel());
            this.grammarPanel.setBorder(null);
        }
        return this.grammarPanel;
    }

    JSplitPane getListsPanel() {
        if (this.listsPanel == null) {
            this.listsPanel = new JSplitPane(0, this.getDisplaysPanel().getUpperListsPanel(), this.getDisplaysPanel().getLowerListsPanel());
            this.listsPanel.setBorder(null);
        }
        return this.listsPanel;
    }

    JSplitPane getDisplaysInfoPanel() {
        JSplitPane result = this.displaysInfoPanel;
        if (result == null) {
            this.displaysInfoPanel = result = new JSplitPane(1);
            result.setLeftComponent(this.getDisplaysPanel());
            result.setRightComponent(this.getDisplaysPanel().getInfoPanel());
            result.setOneTouchExpandable(true);
            result.setResizeWeight(1.0);
            result.setDividerLocation(0.8);
            result.setContinuousLayout(true);
            result.setBorder(null);
            ToolTipManager.sharedInstance().registerComponent(result);
        }
        return result;
    }

    private void adjustInfoPanel(DisplayKind kind) {
    }

    private ListTabbedPane getResultsPanel() {
        if (this.resultsPanel == null) {
            this.resultsPanel = new ListTabbedPane();
            this.resultsPanel.getErrorListPanel().addSelectionListener(this.createListListener());
            this.resultsPanel.getSearchResultListPanel().addSelectionListener(this.createListListener());
            this.model.addListener(this.resultsPanel.getSearchResultListPanel(), SimulatorModel.Change.GRAMMAR);
        }
        return this.resultsPanel;
    }

    private void adjustResultsPanel() {
        JSplitPane contentPane = (JSplitPane)this.frame.getContentPane();
        this.getResultsPanel().adjustVisibility();
        if (this.getResultsPanel().isVisible()) {
            contentPane.setBottomComponent(this.getResultsPanel());
            contentPane.setDividerSize(1);
            contentPane.resetToPreferredSizes();
        } else {
            contentPane.remove(this.getResultsPanel());
            contentPane.setDividerSize(0);
        }
    }

    private Observer createListListener() {
        return new Observer(){

            @Override
            public void update(Observable observable, Object arg) {
                if (arg != null) {
                    ListPanel.SelectableListEntry entry = (ListPanel.SelectableListEntry)arg;
                    ResourceKind resource = entry.getResourceKind();
                    String name = entry.getResourceName();
                    if (resource != null) {
                        FormatError error;
                        Simulator.this.getModel().doSelect(resource, name);
                        ResourceTab resourceTab = Simulator.this.getDisplaysPanel().getDisplayFor(resource).getSelectedTab();
                        if (resource.isGraphBased()) {
                            AspectJGraph jGraph = resourceTab.isEditor() ? ((GraphEditorTab)resourceTab).getJGraph() : ((GraphTab)resourceTab).getJGraph();
                            for (Element cell : entry.getElements()) {
                                if (!jGraph.selectJCell(cell)) {
                                    continue;
                                }
                                break;
                            }
                        } else if (arg instanceof FormatError && (error = (FormatError)arg).getNumbers().size() > 1) {
                            int line = error.getNumbers().get(0);
                            int column = error.getNumbers().get(1);
                            ((TextTab)resourceTab).select(line, column);
                        }
                    }
                }
            }
        };
    }

    private void refreshMenuItems() {
        DisplayKind displayKind = this.getModel().getDisplay();
        for (RefreshableMenuItem item : this.getRefreshableMenuItems()) {
            item.refresh(displayKind);
        }
    }

    public void addAccelerator(Action action) {
        JComponent contentPane = (JComponent)this.getFrame().getContentPane();
        ActionMap am = contentPane.getActionMap();
        am.put(action.getValue("Name"), action);
        InputMap im = contentPane.getInputMap(1);
        im.put((KeyStroke)action.getValue("AcceleratorKey"), action.getValue("Name"));
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createDisplayMenu());
        menuBar.add(this.createExploreMenu());
        menuBar.add(this.createVerifyMenu());
        menuBar.add(this.getExternalActionsMenu());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    private JMenu createFileMenu() {
        JMenu result = new JMenu("File");
        result.setMnemonic(70);
        result.add(new JMenuItem(this.actions.getNewGrammarAction()));
        result.addSeparator();
        result.add(new JMenuItem(this.actions.getLoadGrammarAction()));
        result.add(new JMenuItem(this.actions.getLoadGrammarFromURLAction()));
        result.add(this.createOpenRecentMenu());
        result.addSeparator();
        result.add(new JMenuItem(this.actions.getLoadStartGraphAction()));
        result.addSeparator();
        result.add(new JMenuItem(this.actions.getSaveGrammarAction()));
        result.add(this.getSaveAsMenuItem());
        result.addSeparator();
        result.add(new JMenuItem(this.actions.getImportAction()));
        result.add(this.getExportMenuItem());
        result.addSeparator();
        result.add(new JMenuItem(this.actions.getRefreshGrammarAction()));
        result.addSeparator();
        result.add(new JMenuItem(this.actions.getQuitAction()));
        return result;
    }

    private JMenu createOpenRecentMenu() {
        if (this.history == null) {
            this.history = new SimulatorHistory(this);
        }
        return this.history.getOpenRecentMenu();
    }

    private JMenu createEditMenu() {
        JMenu result = new JMenu("Edit");
        result.setMnemonic(69);
        result.add(this.actions.getUndoAction());
        result.add(this.actions.getRedoAction());
        result.addSeparator();
        JMenu newMenu = new JMenu("New");
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind resource = resourceKindArray[n2];
            if (resource != ResourceKind.PROPERTIES && resource != ResourceKind.CONFIG) {
                newMenu.add(this.actions.getNewAction(resource));
            }
            ++n2;
        }
        result.add(newMenu);
        result.addSeparator();
        result.add(this.getEditMenuItem());
        result.add(this.getCopyMenuItem());
        result.add(this.getDeleteMenuItem());
        result.add(this.getRenameMenuItem());
        result.add(this.getEnableMenuItem());
        result.addSeparator();
        result.add(this.actions.getFindReplaceAction());
        result.add(this.actions.getRenumberAction());
        result.addSeparator();
        result.add(this.actions.getShiftPriorityAction(true));
        result.add(this.actions.getShiftPriorityAction(false));
        result.add(this.actions.getEditRulePropertiesAction());
        result.add(this.actions.getEditSystemPropertiesAction());
        return result;
    }

    private List<RefreshableMenuItem> getRefreshableMenuItems() {
        if (this.menuItems == null) {
            this.menuItems = new ArrayList<RefreshableMenuItem>();
            this.menuItems.add(this.getEditMenuItem());
            this.menuItems.add(this.getCopyMenuItem());
            this.menuItems.add(this.getDeleteMenuItem());
            this.menuItems.add(this.getRenameMenuItem());
            this.menuItems.add(this.getEnableMenuItem());
            this.menuItems.add(this.getSaveAsMenuItem());
            this.menuItems.add(this.getExportMenuItem());
        }
        return this.menuItems;
    }

    private RefreshableMenuItem getEditMenuItem() {
        if (this.editGraphItem == null) {
            this.editGraphItem = new RefreshableMenuItem(){

                @Override
                protected void refresh(ResourceKind resource) {
                    this.setAction(Simulator.this.getActions().getEditAction(resource));
                }
            };
            this.editGraphItem.setAccelerator(Options.EDIT_KEY);
        }
        return this.editGraphItem;
    }

    private RefreshableMenuItem getCopyMenuItem() {
        if (this.copyGraphItem == null) {
            this.copyGraphItem = new RefreshableMenuItem(){

                @Override
                protected void refresh(ResourceKind resource) {
                    this.setAction(Simulator.this.getActions().getCopyAction(resource));
                }
            };
        }
        return this.copyGraphItem;
    }

    private RefreshableMenuItem getDeleteMenuItem() {
        if (this.deleteGraphItem == null) {
            this.deleteGraphItem = new RefreshableMenuItem(){

                @Override
                protected void refresh(ResourceKind resource) {
                    this.setAction(Simulator.this.getActions().getDeleteAction(resource));
                }
            };
        }
        return this.deleteGraphItem;
    }

    private RefreshableMenuItem getRenameMenuItem() {
        if (this.renameMenuItem == null) {
            this.renameMenuItem = new RefreshableMenuItem(){

                @Override
                protected void refresh(ResourceKind resource) {
                    this.setAction(Simulator.this.getActions().getRenameAction(resource));
                }
            };
        }
        return this.renameMenuItem;
    }

    private RefreshableMenuItem getEnableMenuItem() {
        if (this.enableMenuItem == null) {
            this.enableMenuItem = new RefreshableMenuItem(){

                @Override
                protected void refresh(ResourceKind resource) {
                    this.setAction(Simulator.this.getActions().getEnableAction(resource));
                }
            };
        }
        return this.enableMenuItem;
    }

    private RefreshableMenuItem getExportMenuItem() {
        if (this.exportMenuItem == null) {
            this.exportMenuItem = new RefreshableMenuItem(){

                @Override
                protected void refresh(DisplayKind display) {
                    this.setAction(Simulator.this.getActions().getExportAction(display));
                }
            };
        }
        return this.exportMenuItem;
    }

    private RefreshableMenuItem getSaveAsMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new RefreshableMenuItem(){

                @Override
                protected void refresh(ResourceKind resource) {
                    this.setAction(Simulator.this.getActions().getSaveAsAction(resource));
                }
            };
        }
        return this.saveMenuItem;
    }

    private MyJMenu createDisplayMenu() {
        MyJMenu result = new MyJMenu("View"){

            @Override
            public void menuSelectionChanged(boolean selected) {
                this.removeAll();
                JGraphPanel<?> panel = Simulator.this.getDisplaysPanel().getGraphPanel();
                if (panel != null) {
                    JGraph<?> jGraph = panel.getJGraph();
                    if (jGraph instanceof AspectJGraph) {
                        this.addSubmenu(((AspectJGraph)jGraph).createEditMenu(null));
                    }
                    this.add(jGraph.createShowHideMenu());
                    this.add(jGraph.createZoomMenu());
                }
                this.addSubmenu(Simulator.this.createOptionsMenu());
                super.menuSelectionChanged(selected);
            }
        };
        result.setMnemonic(86);
        return result;
    }

    private MyJMenu createOptionsMenu() {
        MyJMenu result = new MyJMenu("Options");
        result.setMnemonic(79);
        for (ResourceKind kind : Options.getOptionalTabs()) {
            String showTabOption = Options.getShowTabOption(kind);
            result.add(this.getOptions().getItem(showTabOption));
        }
        result.addSeparator();
        result.add(this.getOptions().getItem("Show node identities"));
        result.add(this.getOptions().getItem("Show anchors"));
        result.add(this.getOptions().getItem("Show aspect prefixes"));
        result.add(this.getOptions().getItem("Show data values as nodes"));
        result.add(this.getOptions().getItem("Show partial transitions"));
        result.add(this.getOptions().getItem("Show state identities"));
        result.add(this.getOptions().getItem("Show all unfiltered edges"));
        result.add(this.getOptions().getItem("Show bidirectional edges"));
        result.add(this.getOptions().getItem("Show arrows on labels"));
        result.addSeparator();
        result.add(this.getOptions().getItem("Delete seletected resource?"));
        result.add(this.getOptions().getItem("Check CTL on all states?"));
        return result;
    }

    private JMenu createExploreMenu() {
        JMenu result = new JMenu();
        result.setMnemonic(88);
        result.setText("Explore");
        result.add(this.getActions().getExplorationDialogAction());
        result.addSeparator();
        result.add(this.getActions().getStartSimulationAction());
        result.add(this.getActions().getApplyMatchAction());
        result.add(this.getActions().getAnimateAction());
        result.add(this.getActions().getExploreAction());
        result.addSeparator();
        result.add(this.getActions().getBackAction());
        result.add(this.getActions().getForwardAction());
        result.add(this.getActions().getGotoStartStateAction());
        result.add(this.getActions().getGotoFinalStateAction());
        result.addSeparator();
        result.add(this.getActions().getSaveLTSAsAction());
        result.addSeparator();
        result.add(this.getActions().getExplorationStatsDialogAction());
        return result;
    }

    private JMenu createVerifyMenu() {
        JMenu result = new JMenu("Verify");
        result.setMnemonic(89);
        result.add(this.actions.getCheckCTLAction(true));
        result.add(this.actions.getCheckCTLAction(false));
        result.addSeparator();
        ModelCheckingMenu mcScenarioMenu = new ModelCheckingMenu(this);
        Component[] componentArray = mcScenarioMenu.getMenuComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component menuComponent = componentArray[n2];
            result.add(menuComponent);
            ++n2;
        }
        return result;
    }

    private JMenu getExternalActionsMenu() {
        if (this.externalMenu == null) {
            this.externalMenu = this.createExternalActionsMenu();
            this.dummyExternalAction = new AbstractAction("(empty)"){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
            this.dummyExternalAction.setEnabled(false);
            this.externalMenu.add(this.dummyExternalAction);
        }
        return this.externalMenu;
    }

    private JMenu createExternalActionsMenu() {
        return new JMenu("External");
    }

    public void addExternalAction(Action action) {
        JMenu externalMenu = this.getExternalActionsMenu();
        if (externalMenu.getItem(0).getAction() == this.dummyExternalAction) {
            externalMenu.remove(0);
        }
        this.getExternalActionsMenu().add(action);
    }

    private JMenu createHelpMenu() {
        JMenu result = new JMenu("Help");
        result.setMnemonic(72);
        result.add(new JMenuItem(new AboutAction(this.getFrame())));
        return result;
    }

    public void setTitle() {
        StringBuffer title = new StringBuffer();
        GrammarModel grammar = this.getModel().getGrammar();
        if (grammar != null && grammar.getName() != null) {
            title.append(grammar.getName());
            HostModel startGraph = grammar.getStartGraphModel();
            if (startGraph != null) {
                title.append(TITLE_NAME_SEPARATOR);
                title.append(startGraph.getFullName());
            }
            if (!grammar.getStore().isModifiable()) {
                title.append(" (read-only)");
            }
            title.append(" - ");
        }
        title.append(APPLICATION_NAME);
        this.getFrame().setTitle(title.toString());
    }

    public Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
            this.options.getItem("Show state identities").setSelected(true);
        }
        return this.options;
    }

    public final SimulatorModel getModel() {
        return this.model;
    }

    public StepHistory getStepHistory() {
        return this.stepHistory;
    }

    public final SimulatorUndoManager getUndoManager() {
        return this.undoManager;
    }

    public static void main(String[] args) {
        try {
            Simulator simulator;
            if (args.length == 0) {
                simulator = new Simulator();
            } else if (args.length == 1) {
                simulator = new Simulator(args[0]);
            } else {
                throw new IOException("Usage: Simulator [<production-system>]");
            }
            simulator.start();
        }
        catch (IOException exc) {
            exc.printStackTrace();
            System.out.println(exc.getMessage());
        }
    }

    private static abstract class RefreshableMenuItem
    extends JMenuItem {
        private RefreshableMenuItem() {
        }

        protected void refresh(DisplayKind display) {
            if (display.hasResource()) {
                this.refresh(display.getResource());
            } else {
                this.setEnabled(false);
            }
        }

        protected void refresh(ResourceKind resource) {
        }

        @Override
        public void setAction(Action a) {
            if (a == null) {
                this.setEnabled(false);
            } else {
                super.setAction(a);
            }
        }
    }
}

