/*
 * Decompiled with CFR 0.152.
 */
package groove.gui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;

public class BehaviourOption
extends JMenu
implements ItemListener {
    private int value;
    private final List<String> answers;
    private List<String> dialogOptions;
    private final ButtonGroup answerGroup;
    public static final int ASK = 0;
    public static final String ASK_TEXT = "Ask";
    public static final int ALWAYS = 1;
    public static final String ALWAYS_TEXT = "Always";
    public static final String AUTO_TEXT = "Auto";
    public static final int NEVER = 2;
    public static final String NEVER_TEXT = "Never";
    private static final int YES = 0;
    private static final String YES_TEXT = "Yes";
    private static final int NO = 1;
    private static final String NO_TEXT = "No";
    private static final List<String> standardAnswers2 = Collections.unmodifiableList(Arrays.asList("Ask", "Always"));
    private static final List<String> standardAnswers3 = Collections.unmodifiableList(Arrays.asList("Ask", "Always", "Never"));
    private static final String DIALOG_TITLE = "Confirm";
    public static final String SELECTION = "selection";

    public BehaviourOption(String name, int choiceCount) {
        super(name);
        if (choiceCount != 2 && choiceCount != 3) {
            throw new IllegalArgumentException(String.format("Number of options cannot be %d", choiceCount));
        }
        this.answers = choiceCount == 2 ? standardAnswers2 : standardAnswers3;
        this.answerGroup = new ButtonGroup();
        for (String answer : this.answers) {
            this.addAnswer(answer);
        }
        this.getItem(0).setSelected(true);
    }

    private void addAnswer(String answer) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(answer);
        this.answerGroup.add(item);
        this.add(item);
        item.addItemListener(this);
    }

    public final int getValue() {
        return this.value;
    }

    public final void setValue(int value) {
        if (value < 0 || value >= this.getItemCount()) {
            throw new IllegalArgumentException(String.format("Value should be in the range %d-%d", 0, this.getItemCount()));
        }
        if (value != this.value) {
            int oldValue = this.value;
            this.value = value;
            this.getItem(value).setSelected(true);
            this.firePropertyChange(SELECTION, oldValue, value);
        }
    }

    public List<String> getAnswers() {
        return this.answers;
    }

    public boolean confirm(Component owner, String question) {
        if (this.value == 0) {
            if (question == null) {
                question = this.getText();
            }
            List<String> options = this.getDialogOptions();
            JOptionPane pane = new JOptionPane(question, 3, 1, null, options.toArray());
            pane.createDialog(owner, DIALOG_TITLE).setVisible(true);
            int dialogValue = options.indexOf(pane.getValue());
            if (dialogValue > 1) {
                this.setValue(dialogValue - 1);
            }
            return dialogValue == 0 || dialogValue - 1 == 1;
        }
        return this.value == 1;
    }

    private List<String> getDialogOptions() {
        if (this.dialogOptions == null) {
            this.dialogOptions = new ArrayList<String>();
            this.dialogOptions.add(YES_TEXT);
            this.dialogOptions.add(NO_TEXT);
            Iterator<String> answerIter = this.getAnswers().iterator();
            answerIter.next();
            while (answerIter.hasNext()) {
                this.dialogOptions.add(answerIter.next());
            }
        }
        return this.dialogOptions;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            int value = 0;
            while (this.getItem(value) != e.getSource()) {
                ++value;
            }
            this.setValue(value);
        }
    }
}

