/*
 * Decompiled with CFR 0.152.
 */
package groove.graph.iso;

import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.type.TypeLabel;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.iso.CertificateStrategy;
import groove.util.collect.TreeHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class SimplePaigeTarjanMcKay
extends CertificateStrategy {
    private final boolean strong;
    private int nodePartitionCount;
    private int iterateCount;
    private List<Queue<Block>> partitionRecord;
    private static int totalSymmetryBreakCount;
    private static final int INT_WIDTH = 32;
    private static final int TREE_RESOLUTION = 3;
    private static final TreeHashSet<MyNodeCert> certStore;
    private static final List<MyNodeCert> EMPTY_NODE_LIST;
    private static final Block[] EMPTY_BLOCK_ARRAY;
    private static final boolean BREAK_DUPLICATES = true;
    private static final boolean RECORD = false;

    static {
        certStore = new TreeHashSet<MyNodeCert>(3){

            @Override
            protected boolean allEqual() {
                return true;
            }

            @Override
            protected int getCode(MyNodeCert key) {
                return key.getValue();
            }
        };
        EMPTY_NODE_LIST = Collections.emptyList();
        EMPTY_BLOCK_ARRAY = new Block[0];
    }

    public SimplePaigeTarjanMcKay(Graph graph) {
        this(graph, false);
    }

    public SimplePaigeTarjanMcKay(Graph graph, boolean strong) {
        super(graph);
        this.strong = strong;
    }

    @Override
    public SimplePaigeTarjanMcKay newInstance(Graph graph, boolean strong) {
        return new SimplePaigeTarjanMcKay(graph);
    }

    @Override
    public int getNodePartitionCount() {
        if (this.nodePartitionCount == 0) {
            this.computeCertificates();
        }
        return this.nodePartitionCount;
    }

    @Override
    public boolean getStrength() {
        return true;
    }

    @Override
    void iterateCertificates() {
        certStore.clear();
        int i = 0;
        while (i < this.nodeCerts.length) {
            Block block;
            MyNodeCert nodeCert = (MyNodeCert)this.nodeCerts[i];
            MyNodeCert previous = certStore.put(nodeCert);
            if (previous == null) {
                block = new Block(this, nodeCert.getValue());
                block.setSplitter(true);
            } else {
                block = previous.getBlock();
            }
            block.append(nodeCert);
            ++i;
        }
        LinkedList<Block> splitters = new LinkedList<Block>();
        Iterator<MyNodeCert> iter = certStore.sortedIterator();
        while (iter.hasNext()) {
            splitters.add(iter.next().getBlock());
        }
        this.nodePartitionCount = splitters.size();
        this.split(splitters);
    }

    private void split(Queue<Block> splitterList) {
        while (!splitterList.isEmpty()) {
            Block splitter = splitterList.poll();
            if (splitter.size() <= 0) continue;
            this.splitNext(splitter, splitterList);
        }
    }

    private void splitNext(Block splitter, Queue<Block> splitterList) {
        TreeHashSet<Block> splitBlocks = new TreeHashSet<Block>();
        for (MyNodeCert splitterNode : splitter.getNodes()) {
            Block oldSplitBlock;
            Block splitBlock;
            for (MyEdge2Cert outEdge : splitterNode.outEdges) {
                splitBlock = outEdge.getTarget().getBlock();
                if (splitBlock.startSplit() && (oldSplitBlock = splitBlocks.put(splitBlock)) != null && oldSplitBlock != splitBlock) {
                    oldSplitBlock.merge(splitBlock);
                }
                outEdge.updateTarget();
            }
            for (MyEdge2Cert inEdge : splitterNode.inEdges) {
                splitBlock = inEdge.getSource().getBlock();
                if (splitBlock.startSplit() && (oldSplitBlock = splitBlocks.put(splitBlock)) != null && oldSplitBlock != splitBlock) {
                    oldSplitBlock.merge(splitBlock);
                }
                inEdge.updateSource();
            }
        }
        splitter.setSplitter(false);
        Iterator splitBlockIter = splitBlocks.sortedIterator();
        while (splitBlockIter.hasNext()) {
            Block block = (Block)splitBlockIter.next();
            Block[] newBlocks = block.split();
            if (newBlocks.length <= 0) continue;
            int last = block.isSplitter() ? newBlocks.length : newBlocks.length - 1;
            int i = 0;
            while (i < last) {
                splitterList.add(newBlocks[i]);
                newBlocks[i].setSplitter(true);
                ++i;
            }
            this.nodePartitionCount += newBlocks.length - 1;
        }
    }

    @Override
    CertificateStrategy.NodeCertificate createValueNodeCertificate(ValueNode node) {
        return new MyValueNodeCert(node);
    }

    @Override
    CertificateStrategy.NodeCertificate createNodeCertificate(Node node) {
        return new MyNodeCert(node);
    }

    @Override
    CertificateStrategy.EdgeCertificate createEdge1Certificate(Edge edge, CertificateStrategy.NodeCertificate source) {
        return new MyEdge1Cert(edge, (MyNodeCert)source);
    }

    @Override
    CertificateStrategy.EdgeCertificate createEdge2Certificate(Edge edge, CertificateStrategy.NodeCertificate source, CertificateStrategy.NodeCertificate target) {
        return new MyEdge2Cert(this, edge, (MyNodeCert)source, (MyNodeCert)target);
    }

    public static int getSymmetryBreakCount() {
        return totalSymmetryBreakCount;
    }

    static class Block
    implements Comparable<Block>,
    Cloneable {
        private final SimplePaigeTarjanMcKay strategy;
        private int value;
        private List<MyNodeCert> nodes = new LinkedList<MyNodeCert>();
        private boolean splitter;
        private boolean splitting;

        Block(SimplePaigeTarjanMcKay strategy, int value) {
            this.value = value;
            this.strategy = strategy;
            strategy.graphCertificate += (long)value;
        }

        boolean isSplitter() {
            return this.splitter;
        }

        void setSplitter(boolean splitter) {
            this.splitter = splitter;
        }

        final boolean startSplit() {
            if (!this.splitting) {
                this.splitting = true;
                return true;
            }
            return false;
        }

        Block[] split() {
            if (this.size() == 1) {
                MyNodeCert node = this.nodes.get(0);
                node.setNewValue();
                this.value = node.getValue();
                this.strategy.graphCertificate += (long)this.value;
                this.splitting = false;
                return EMPTY_BLOCK_ARRAY;
            }
            HashMap<Integer, Block> blockMap = new HashMap<Integer, Block>();
            Block block = null;
            for (MyNodeCert node : this.nodes) {
                node.setNewValue();
                if ((block == null || block.value != node.getValue()) && (block = (Block)blockMap.get(node.getValue())) == null) {
                    block = new Block(this.strategy, node.getValue());
                    blockMap.put(node.getValue(), block);
                }
                block.append(node);
            }
            this.nodes = EMPTY_NODE_LIST;
            if (blockMap.size() == 1) {
                return new Block[]{block};
            }
            Object[] result = new Block[blockMap.size()];
            blockMap.values().toArray(result);
            Arrays.sort(result);
            return result;
        }

        void merge(Block other) {
            assert (this.value == other.value) : String.format("Merging blocks %s and %s with distinct hash codes", this, other);
            for (MyNodeCert otherNode : other.getNodes()) {
                otherNode.setBlock(this);
                this.nodes.add(otherNode);
            }
        }

        final void append(MyNodeCert node) {
            this.nodes.add(node);
            node.setBlock(this);
        }

        final int size() {
            return this.nodes.size();
        }

        List<MyNodeCert> getNodes() {
            return this.nodes;
        }

        @Override
        public int compareTo(Block other) {
            int result = this.size() - other.size();
            if (result != 0) {
                return result;
            }
            return this.value < other.value ? -1 : (this.value > other.value ? 1 : 0);
        }

        public boolean equals(Object obj) {
            return obj instanceof Block && ((Block)obj).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            ArrayList<Node> content = new ArrayList<Node>();
            for (MyNodeCert nodeCert : this.nodes) {
                content.add(nodeCert.getElement());
            }
            return String.format("B%dx%d%s", this.nodes.size(), this.value, content);
        }

        public Block clone() {
            try {
                Block result = (Block)super.clone();
                result.nodes = new ArrayList<MyNodeCert>(this.nodes);
                return result;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    static class MyEdge1Cert
    implements CertificateStrategy.EdgeCertificate {
        private final Edge edge;
        private final Label label;
        private final MyNodeCert sourceCert;
        protected final int initValue;
        private final int value;

        MyEdge1Cert(Edge edge, MyNodeCert sourceCert) {
            this.edge = edge;
            this.sourceCert = sourceCert;
            this.label = edge.label();
            this.value = this.initValue = this.label.hashCode();
            sourceCert.addSelf(this);
        }

        @Override
        public final Edge getElement() {
            return this.edge;
        }

        public int hashCode() {
            return this.sourceCert.hashCode() + this.edge.label().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MyEdge1Cert)) {
                return false;
            }
            MyEdge1Cert other = (MyEdge1Cert)obj;
            return other.sourceCert.equals(this.sourceCert) && other.label.equals(this.label);
        }

        public String toString() {
            return "[" + this.getSource() + "," + this.label + "(" + this.initValue + ")]";
        }

        @Override
        public final int getValue() {
            return this.value;
        }

        @Override
        public void modifyValue(int mod) {
        }

        final MyNodeCert getSource() {
            return this.sourceCert;
        }
    }

    static class MyEdge2Cert
    extends MyEdge1Cert {
        private final MyNodeCert targetCert;
        private final SimplePaigeTarjanMcKay strategy;

        MyEdge2Cert(SimplePaigeTarjanMcKay strategy, Edge edge, MyNodeCert sourceCert, MyNodeCert targetCert) {
            super(edge, sourceCert);
            this.targetCert = targetCert;
            sourceCert.addOutgoing(this);
            targetCert.addIncoming(this);
            this.strategy = strategy;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + (this.getTarget().hashCode() << 2);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof MyEdge2Cert && super.equals(obj) && ((MyEdge2Cert)obj).getTarget().equals(this.getTarget());
        }

        @Override
        public String toString() {
            return "[" + this.getSource() + "," + this.getElement().label() + "(" + this.initValue + ")," + this.getTarget() + "]";
        }

        private MyNodeCert getTarget() {
            return this.targetCert;
        }

        void updateSource() {
            this.getSource().modifyValue(3 * this.computeValue());
        }

        void updateTarget() {
            this.getTarget().modifyValue(-5 * this.computeValue());
        }

        private int computeValue() {
            int shift = (this.initValue & 0xF) + 1;
            int targetValue = this.targetCert.getValue();
            int sourceValue = this.getSource().getValue();
            int result = (sourceValue << shift | sourceValue >>> 32 - shift) + (targetValue >>> shift | targetValue << 32 - shift) + this.initValue;
            this.strategy.graphCertificate += (long)result;
            return result;
        }
    }

    static class MyNodeCert
    implements CertificateStrategy.NodeCertificate {
        private static final int INIT_NODE_VALUE = 4715;
        private int nextValue;
        int value;
        private final Node node;
        private final TypeLabel label;
        private final List<MyEdge2Cert> inEdges = new ArrayList<MyEdge2Cert>();
        private final List<MyEdge2Cert> outEdges = new ArrayList<MyEdge2Cert>();
        private Block container;
        static final int TARGET_MASK = 21845;

        public MyNodeCert(Node node) {
            this.node = node;
            if (node instanceof HostNode) {
                this.label = ((HostNode)node).getType().label();
                this.value = this.label.hashCode();
            } else {
                this.label = null;
                this.value = 4715;
            }
        }

        public String toString() {
            return "c" + this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MyNodeCert)) {
                return false;
            }
            MyNodeCert other = (MyNodeCert)obj;
            if (this.value != other.value) {
                return false;
            }
            if (this.label == null) {
                return true;
            }
            return this.label.equals(other.label);
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public final int getValue() {
            return this.value;
        }

        @Override
        public void modifyValue(int value) {
            this.nextValue += value;
        }

        void setNewValue() {
            this.value += this.nextValue;
            this.nextValue = 0;
        }

        @Override
        public Node getElement() {
            return this.node;
        }

        void addSelf(MyEdge1Cert edgeCert) {
            this.value += edgeCert.getValue();
        }

        void addOutgoing(MyEdge2Cert edgeCert) {
            this.outEdges.add(edgeCert);
            this.value += edgeCert.getValue();
        }

        void addIncoming(MyEdge2Cert edgeCert) {
            this.inEdges.add(edgeCert);
            this.value += edgeCert.getValue() ^ 0x5555;
        }

        final Block getBlock() {
            return this.container;
        }

        final void setBlock(Block container) {
            this.container = container;
        }
    }

    static class MyValueNodeCert
    extends MyNodeCert {
        private final Object nodeValue;

        public MyValueNodeCert(ValueNode node) {
            super(node);
            this.nodeValue = node.getValue();
            this.value = node.getValue().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof MyValueNodeCert && this.nodeValue.equals(((MyValueNodeCert)obj).nodeValue);
        }
    }
}

