/*
 * Decompiled with CFR 0.152.
 */
package groove.graph.iso;

import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.EquivRelation;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.EdgeSignatureStore;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.grammar.host.ValueNode;
import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.Element;
import groove.graph.Graph;
import groove.graph.Node;
import groove.graph.iso.IsoChecker;
import groove.graph.iso.PartitionMap;
import groove.util.Reporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class CertificateStrategy {
    private final Graph graph;
    long graphCertificate;
    Map<Element, ElementCertificate<?>> certificateMap;
    PartitionMap<Node> nodePartitionMap;
    PartitionMap<Edge> edgePartitionMap;
    NodeCertificate[] nodeCerts;
    int nodeCertCount;
    EdgeCertificate[] edgeCerts;
    int edge2CertCount;
    int edge1CertCount;
    private final NodeCertificate[] defaultNodeCerts;
    private static int[] iterateCountArray = new int[0];
    static final boolean TRACE = false;
    public static final Reporter reporter = IsoChecker.reporter;
    public static final Reporter computeCertReporter = reporter.register("computeCertificates()");
    protected static final Reporter getPartitionReporter = reporter.register("getPartitionMap()");

    CertificateStrategy(Graph graph) {
        this.graph = graph;
        this.defaultNodeCerts = graph != null ? new NodeCertificate[graph.getFactory().getMaxNodeNr() + 1] : null;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Object getGraphCertificate() {
        if (this.graphCertificate == 0L) {
            this.computeCertificates();
            if (this.graphCertificate == 0L) {
                this.graphCertificate = 1L;
            }
        }
        if (this.getGraph() instanceof Shape) {
            Shape shape = (Shape)this.getGraph();
            shape.getEquivRelation().hashCode();
        }
        return this.graphCertificate;
    }

    public NodeCertificate[] getNodeCertificates() {
        if (this.nodeCerts == null) {
            this.computeCertificates();
        }
        return this.nodeCerts;
    }

    public EdgeCertificate[] getEdgeCertificates() {
        if (this.edgeCerts == null) {
            this.computeCertificates();
        }
        return this.edgeCerts;
    }

    void computeCertificates() {
        computeCertReporter.start();
        this.initCertificates();
        this.iterateCertificates();
        if (this.getGraph() instanceof Shape) {
            this.processShapeCertificates((Shape)this.getGraph());
        }
        computeCertReporter.stop();
    }

    abstract void iterateCertificates();

    void initCertificates() {
        int nodeCount = this.getGraph().nodeCount();
        int edgeCount = this.getGraph().edgeCount();
        this.nodeCerts = new NodeCertificate[nodeCount];
        this.edgeCerts = new EdgeCertificate[edgeCount];
        for (Node node : this.getGraph().nodeSet()) {
            this.initNodeCert(node);
        }
        for (Edge edge : this.getGraph().edgeSet()) {
            this.initEdgeCert(edge);
        }
    }

    private void processShapeCertificates(Shape shape) {
        int result = 0;
        EquivRelation<ShapeNode> er = shape.getEquivRelation();
        EdgeSignatureStore store = shape.getEdgeSigStore();
        for (EquivClass equivClass : er) {
            int ecHash = 0;
            for (ShapeNode node : equivClass) {
                ecHash += this.getNodeCert(node).hashCode();
            }
            ecHash *= ecHash;
            for (ShapeNode node : equivClass) {
                this.getNodeCert(node).modifyValue(ecHash);
            }
            result += ecHash;
        }
        HashMap<EdgeSignature, Integer> hashMap = new HashMap<EdgeSignature, Integer>();
        for (EdgeSignature sig : shape.getEdgeSigSet()) {
            NodeCertificate sigNodeCert = this.getNodeCert(sig.getNode());
            int nHash = sigNodeCert.hashCode();
            int sigHash = sig.getLabel().hashCode();
            Iterator iterator = sig.getEquivClass().iterator();
            while (iterator.hasNext()) {
                ShapeNode opposite;
                ShapeNode oppositeN = opposite = (ShapeNode)iterator.next();
                sigHash += this.getNodeCert(oppositeN).hashCode();
            }
            hashMap.put(sig, sigHash *= nHash);
            result += sigHash;
        }
        EdgeCertificate[] edgeCertificateArray = this.getEdgeCertificates();
        int n = edgeCertificateArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeCertificate edgeCert = edgeCertificateArray[n2];
            ShapeEdge edge = (ShapeEdge)edgeCert.getElement();
            if (edge.getRole() == EdgeRole.BINARY) {
                edgeCert.modifyValue((Integer)hashMap.get(store.getSig(edge, EdgeMultDir.OUTGOING)));
                edgeCert.modifyValue(-((Integer)hashMap.get(store.getSig(edge, EdgeMultDir.INCOMING))).intValue());
            }
            ++n2;
        }
        this.graphCertificate += (long)result;
    }

    private NodeCertificate initNodeCert(Node node) {
        NodeCertificate nodeCert = node instanceof ValueNode ? this.createValueNodeCertificate((ValueNode)node) : this.createNodeCertificate(node);
        this.putNodeCert(nodeCert);
        this.nodeCerts[this.nodeCertCount] = nodeCert;
        ++this.nodeCertCount;
        return nodeCert;
    }

    private void putNodeCert(NodeCertificate nodeCert) {
        Node node = (Node)nodeCert.getElement();
        int nodeNr = node.getNumber();
        assert (nodeNr < this.defaultNodeCerts.length) : String.format("Node nr %d higher than maximum %d", nodeNr, this.defaultNodeCerts.length);
        this.defaultNodeCerts[nodeNr] = nodeCert;
    }

    NodeCertificate getNodeCert(Node node) {
        int nodeNr = node.getNumber();
        NodeCertificate result = this.defaultNodeCerts[nodeNr];
        assert (result != null) : String.format("Could not find certificate for %s", node);
        return result;
    }

    private void initEdgeCert(Edge edge) {
        Node source = edge.source();
        NodeCertificate sourceCert = this.getNodeCert(source);
        assert (sourceCert != null) : String.format("No source certifiate found for %s", edge);
        if (source == edge.target()) {
            EdgeCertificate edge1Cert;
            this.edgeCerts[this.edgeCerts.length - this.edge1CertCount - 1] = edge1Cert = this.createEdge1Certificate(edge, sourceCert);
            ++this.edge1CertCount;
            assert (this.edge1CertCount + this.edge2CertCount <= this.edgeCerts.length) : String.format("%s unary and %s binary edges do not equal %s edges", this.edge1CertCount, this.edge2CertCount, this.edgeCerts.length);
        } else {
            EdgeCertificate edge2Cert;
            NodeCertificate targetCert = this.getNodeCert(edge.target());
            assert (targetCert != null) : String.format("No target certifiate found for %s", edge);
            this.edgeCerts[this.edge2CertCount] = edge2Cert = this.createEdge2Certificate(edge, sourceCert, targetCert);
            ++this.edge2CertCount;
            assert (this.edge1CertCount + this.edge2CertCount <= this.edgeCerts.length) : String.format("%s unary and %s binary edges do not equal %s edges", this.edge1CertCount, this.edge2CertCount, this.edgeCerts.length);
        }
    }

    abstract NodeCertificate createValueNodeCertificate(ValueNode var1);

    abstract NodeCertificate createNodeCertificate(Node var1);

    abstract EdgeCertificate createEdge1Certificate(Edge var1, NodeCertificate var2);

    abstract EdgeCertificate createEdge2Certificate(Edge var1, NodeCertificate var2, NodeCertificate var3);

    public Map<Element, ElementCertificate<?>> getCertificateMap() {
        if (this.certificateMap == null) {
            this.getGraphCertificate();
            this.certificateMap = new HashMap();
            ElementCertificate<Node>[] elementCertificateArray = this.nodeCerts;
            int n = this.nodeCerts.length;
            int n2 = 0;
            while (n2 < n) {
                NodeCertificate nodeCert = elementCertificateArray[n2];
                this.certificateMap.put((Element)nodeCert.getElement(), nodeCert);
                ++n2;
            }
            elementCertificateArray = this.edgeCerts;
            n = this.edgeCerts.length;
            n2 = 0;
            while (n2 < n) {
                ElementCertificate<Node> edgeCert = elementCertificateArray[n2];
                this.certificateMap.put(edgeCert.getElement(), edgeCert);
                ++n2;
            }
        }
        return this.certificateMap;
    }

    public PartitionMap<Node> getNodePartitionMap() {
        if (this.nodePartitionMap == null) {
            this.getGraphCertificate();
            this.nodePartitionMap = this.computeNodePartitionMap();
        }
        return this.nodePartitionMap;
    }

    private PartitionMap<Node> computeNodePartitionMap() {
        getPartitionReporter.start();
        PartitionMap<Node> result = new PartitionMap<Node>();
        NodeCertificate[] nodeCertificateArray = this.nodeCerts;
        int n = this.nodeCerts.length;
        int n2 = 0;
        while (n2 < n) {
            NodeCertificate cert = nodeCertificateArray[n2];
            result.add(cert);
            ++n2;
        }
        getPartitionReporter.stop();
        return result;
    }

    public PartitionMap<Edge> getEdgePartitionMap() {
        if (this.edgePartitionMap == null) {
            this.getGraphCertificate();
            this.edgePartitionMap = this.computeEdgePartitionMap();
        }
        return this.edgePartitionMap;
    }

    private PartitionMap<Edge> computeEdgePartitionMap() {
        getPartitionReporter.start();
        PartitionMap<Edge> result = new PartitionMap<Edge>();
        int bound = this.edgeCerts.length;
        int i = 0;
        while (i < bound) {
            result.add(this.edgeCerts[i]);
            ++i;
        }
        getPartitionReporter.stop();
        return result;
    }

    public abstract int getNodePartitionCount();

    public abstract CertificateStrategy newInstance(Graph var1, boolean var2);

    public abstract boolean getStrength();

    public static List<Integer> getIterateCount() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int[] nArray = iterateCountArray;
        int n = iterateCountArray.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            result.add(element);
            ++n2;
        }
        return result;
    }

    static void recordIterateCount(int count) {
        if (iterateCountArray.length < count + 1) {
            int[] newIterateCount = new int[count + 1];
            System.arraycopy(iterateCountArray, 0, newIterateCount, 0, iterateCountArray.length);
            iterateCountArray = newIterateCount;
        }
        int n = count;
        iterateCountArray[n] = iterateCountArray[n] + 1;
    }

    public static interface Certificate {
        public int getValue();

        public void modifyValue(int var1);
    }

    public static interface EdgeCertificate
    extends ElementCertificate<Edge> {
    }

    public static interface ElementCertificate<EL extends Element>
    extends Certificate {
        public EL getElement();
    }

    public static interface NodeCertificate
    extends ElementCertificate<Node> {
    }
}

