/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.type;

import groove.grammar.AnchorKind;
import groove.grammar.type.LabelPattern;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;
import groove.graph.Label;
import groove.graph.Node;
import java.awt.Color;
import java.util.Set;

public class TypeNode
implements Node,
TypeElement {
    private final TypeGraph graph;
    private final boolean dataType;
    private boolean abstracted;
    private boolean imported;
    private Color colour;
    private LabelPattern pattern;
    private final int nr;
    private final TypeLabel type;

    public TypeNode(int nr, TypeLabel type, TypeGraph graph) {
        assert (graph != null);
        assert (type.getRole() == EdgeRole.NODE_TYPE) : String.format("Can't create type node for non-type label '%s'", type);
        this.nr = nr;
        this.type = type;
        this.graph = graph;
        this.dataType = type.isDataType();
    }

    public boolean equals(Object obj) {
        boolean result;
        assert (this.getGraph() == ((TypeElement)obj).getGraph() || this.isImported() && ((TypeNode)obj).isImported());
        boolean bl = result = this == obj;
        assert (!result || !(obj instanceof TypeEdge) || this.getNumber() == ((TypeNode)obj).getNumber() && this.label().equals(((TypeNode)obj).label()));
        return result;
    }

    public int hashCode() {
        return this.getNumber() ^ this.label().hashCode();
    }

    public String toString() {
        return this.label().text();
    }

    @Override
    public int getNumber() {
        return this.nr;
    }

    @Override
    public int compareTo(Label obj) {
        if (obj instanceof TypeNode) {
            return this.label().compareTo(((TypeNode)obj).label());
        }
        assert (obj instanceof TypeEdge);
        int result = this.compareTo((Label)((TypeEdge)obj).source());
        if (result == 0) {
            result = -1;
        }
        return result;
    }

    @Override
    public String text() {
        return this.label().text();
    }

    @Override
    public EdgeRole getRole() {
        return EdgeRole.NODE_TYPE;
    }

    @Override
    public TypeLabel label() {
        return this.type;
    }

    public final boolean isAbstract() {
        return this.abstracted;
    }

    public final void setAbstract(boolean value) {
        this.abstracted = value;
    }

    public final boolean isTopType() {
        return this.type == TypeLabel.NODE;
    }

    public final boolean isImported() {
        return this.imported;
    }

    public final boolean isDataType() {
        return this.dataType;
    }

    public final void setImported(boolean value) {
        this.imported = value;
    }

    public final LabelPattern getLabelPattern() {
        return this.pattern;
    }

    public final void setLabelPattern(LabelPattern pattern) {
        this.pattern = pattern;
    }

    public final Color getColor() {
        return this.colour;
    }

    public final void setColor(Color colour) {
        this.colour = colour;
    }

    @Override
    public TypeGraph getGraph() {
        return this.graph;
    }

    public Set<TypeNode> getSubtypes() {
        return this.getGraph().getSubtypes(this);
    }

    public Set<TypeNode> getSupertypes() {
        return this.getGraph().getSupertypes(this);
    }

    public boolean subsumes(TypeNode other, boolean strict) {
        if (this.equals(other)) {
            return true;
        }
        return !strict && this.getGraph() != null && this.getGraph().isSubtype(other, this);
    }

    @Override
    public AnchorKind getAnchorKind() {
        return AnchorKind.LABEL;
    }
}

