/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.grammar.Action;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ControlModel;
import groove.grammar.model.PrologModel;
import groove.grammar.model.ResourceKind;
import groove.graph.Edge;
import groove.graph.EdgeComparator;
import groove.graph.Element;
import groove.graph.Node;
import groove.graph.NodeComparator;
import groove.gui.list.ListPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class FormatError
implements Comparable<FormatError>,
ListPanel.SelectableListEntry {
    private PrologModel prolog;
    private ControlModel control;
    private AspectGraph graph;
    private ResourceKind resourceKind;
    private String resourceName;
    private final List<Element> elements = new ArrayList<Element>();
    private final List<Integer> numbers = new ArrayList<Integer>();
    private FormatError subError;
    private final String message;
    private static final NodeComparator nodeComparator = NodeComparator.instance();
    private static final EdgeComparator edgeComparator = EdgeComparator.instance();

    public FormatError(String message) {
        this.message = message;
    }

    public FormatError(String message, Object ... pars) {
        this(String.format(message, pars));
        Object[] objectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            Object par = objectArray[n2];
            this.addContext(par);
            ++n2;
        }
    }

    private void addContext(Object par) {
        if (par instanceof FormatError) {
            this.subError = (FormatError)par;
            this.subError.transferTo(null, this);
        } else if (par instanceof AspectGraph) {
            this.graph = (AspectGraph)par;
            this.resourceName = this.graph.getName();
            this.resourceKind = ResourceKind.toResource(this.graph.getRole());
        } else if (par instanceof ControlModel) {
            this.control = (ControlModel)par;
            this.resourceName = this.control.getFullName();
            this.resourceKind = ResourceKind.CONTROL;
        } else if (par instanceof PrologModel) {
            this.prolog = (PrologModel)par;
            this.resourceName = this.prolog.getFullName();
            this.resourceKind = ResourceKind.PROLOG;
        } else if (par instanceof Element) {
            this.elements.add((Element)par);
        } else if (par instanceof Integer) {
            this.numbers.add((Integer)par);
        } else if (par instanceof Object[]) {
            Object[] objectArray = (Object[])par;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object subpar = objectArray[n2];
                this.addContext(subpar);
                ++n2;
            }
        } else if (par instanceof Action) {
            this.resourceName = ((Action)par).getFullName();
            this.resourceKind = ResourceKind.RULE;
        }
    }

    public FormatError(FormatError prior, Object ... pars) {
        this(prior.toString());
        Object[] objectArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            Object par = objectArray[n2];
            this.addContext(par);
            ++n2;
        }
        this.elements.addAll(prior.getElements());
        if (this.graph == null) {
            this.graph = prior.getGraph();
        }
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof FormatError;
        if (result) {
            FormatError err = (FormatError)obj;
            result = Arrays.equals(this.getArguments(), err.getArguments());
            result &= this.toString().equals(err.toString());
        }
        return result;
    }

    public int hashCode() {
        int result = this.toString().hashCode();
        return result += Arrays.hashCode(this.getArguments());
    }

    public String toString() {
        return this.message;
    }

    @Override
    public int compareTo(FormatError other) {
        int result = this.toString().compareTo(other.toString());
        List<Element> myElements = this.getElements();
        List<Element> otherElements = other.getElements();
        int upper = Math.min(myElements.size(), otherElements.size());
        int i = 0;
        while (result == 0 && i < upper) {
            result = FormatError.compare(myElements.get(i), otherElements.get(i));
            ++i;
        }
        if (result == 0) {
            result = myElements.size() - otherElements.size();
        }
        return result;
    }

    public final ControlModel getControl() {
        return this.control;
    }

    public final PrologModel getProlog() {
        return this.prolog;
    }

    public final FormatError getSubError() {
        return this.subError;
    }

    public final AspectGraph getGraph() {
        return this.graph;
    }

    @Override
    public final List<Element> getElements() {
        return this.elements;
    }

    public final List<Integer> getNumbers() {
        return this.numbers;
    }

    @Override
    public final ResourceKind getResourceKind() {
        return this.resourceKind;
    }

    @Override
    public final String getResourceName() {
        return this.resourceName;
    }

    public FormatError extend(Object ... par) {
        return new FormatError(this, par);
    }

    public FormatError transfer(Map<?, ?> map) {
        FormatError result = new FormatError(this.toString());
        this.transferTo(map, result);
        return result;
    }

    private void transferTo(Map<?, ?> map, FormatError result) {
        Object[] objectArray = this.getArguments();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (map != null && map.containsKey(arg)) {
                arg = map.get(arg);
            }
            result.addContext(arg);
            ++n2;
        }
    }

    private Object[] getArguments() {
        ArrayList<Object> newArguments = new ArrayList<Object>();
        newArguments.addAll(this.elements);
        if (this.control != null) {
            newArguments.add(this.control);
        }
        if (this.prolog != null) {
            newArguments.add(this.prolog);
        }
        newArguments.addAll(this.numbers);
        if (this.subError != null) {
            newArguments.addAll(Arrays.asList(this.subError.getArguments()));
        }
        return newArguments.toArray();
    }

    private static int compare(Element o1, Element o2) {
        int result = o1.getClass().getName().compareTo(o2.getClass().getName());
        if (result != 0) {
            return result;
        }
        result = o1 instanceof Node ? nodeComparator.compare((Node)o1, (Node)o2) : edgeComparator.compare((Edge)o1, (Edge)o2);
        return result;
    }
}

