/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.host;

import groove.algebra.Algebra;
import groove.grammar.host.DefaultHostEdge;
import groove.grammar.host.DefaultHostNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraphMorphism;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.RuleToHostMap;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeFactory;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.StoreFactory;
import groove.util.FreeNumberDispenser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HostFactory
extends StoreFactory<HostNode, HostEdge, TypeLabel> {
    private final Map<String, Map<Object, ValueNode>> valueMaps = new HashMap<String, Map<Object, ValueNode>>();
    private final TypeFactory typeFactory;
    private TypeNode lastNodeType;
    private Map<List<HostNode>, HostNode[]> normalHostNodeMap;
    private static int normaliseGain;
    private static int normaliseCount;

    protected HostFactory(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Override
    public HostNode createNode(int nr) {
        assert (this.typeFactory.getGraph().isImplicit());
        return this.createNode(nr, this.typeFactory.getTopNode());
    }

    public HostNode createNode(TypeLabel type) {
        return this.createNode(this.getNextNodeNr(), type);
    }

    public HostNode createNode(int nr, TypeLabel type) {
        assert (type.getRole() == EdgeRole.NODE_TYPE);
        TypeNode typeNode = this.typeFactory.getNode(type);
        assert (typeNode != null);
        this.setLastNodeType(typeNode);
        HostNode result = (HostNode)super.createNode(nr);
        this.resetLastNodeType();
        assert (result.getType() == typeNode);
        return result;
    }

    public HostNode createNode(int nr, TypeNode typeNode) {
        assert (typeNode.getGraph() == this.typeFactory.getGraph());
        this.setLastNodeType(typeNode);
        HostNode result = (HostNode)super.createNode(nr);
        this.resetLastNodeType();
        assert (result.getType() == typeNode);
        return result;
    }

    public HostNode createNode(TypeLabel type, Set<? extends HostNode> usedNodes) {
        FreeNumberDispenser dispenser = new FreeNumberDispenser(usedNodes);
        return this.createNode(type, dispenser);
    }

    public HostNode createNode(TypeLabel type, int[] usedNodes) {
        FreeNumberDispenser dispenser = new FreeNumberDispenser(usedNodes);
        return this.createNode(type, dispenser);
    }

    private HostNode createNode(TypeLabel type, FreeNumberDispenser dispenser) {
        TypeNode typeNode = this.getTypeFactory().getNode(type);
        int freeNr = dispenser.getNext();
        HostNode result = null;
        while (freeNr != -1) {
            result = this.retrieveNode(freeNr, typeNode);
            if (result.getType() == typeNode) {
                return result;
            }
            freeNr = dispenser.getNext();
        }
        int i = dispenser.getMaxNumber() + 1;
        while (i < this.getMaxNodeNr()) {
            result = (HostNode)this.getNode(i);
            if (result.getType() == typeNode) {
                return result;
            }
            ++i;
        }
        result = this.createNode(type);
        return result;
    }

    private HostNode retrieveNode(int nodeNr, TypeNode type) {
        HostNode result = (HostNode)this.getNodeFromNr(nodeNr);
        if (result == null) {
            result = this.createNode(nodeNr, type);
        }
        return result;
    }

    public ValueNode createValueNode(Algebra<?> algebra, Object value) {
        ValueNode result = this.getValueMap(algebra).get(value);
        if (result == null) {
            result = this.newValueNode(this.getNextNodeNr(), algebra, value);
        }
        return result;
    }

    public ValueNode createValueNode(int nr, Algebra<?> algebra, Object value) {
        ValueNode result = this.getValueMap(algebra).get(value);
        if (result == null) {
            result = this.newValueNode(nr, algebra, value);
        }
        return result;
    }

    private ValueNode newValueNode(int nr, Algebra<?> algebra, Object value) {
        TypeNode type = this.typeFactory.getDataType(algebra.getKind());
        ValueNode result = new ValueNode(nr, algebra, value, type);
        this.addNode(result);
        return result;
    }

    public ValueNode createNodeFromString(Algebra<?> algebra, String value) {
        return this.createValueNode(algebra, algebra.getValueFromSymbol(value));
    }

    public ValueNode createNodeFromJava(Algebra<?> algebra, Object value) {
        return this.createValueNode(algebra, algebra.getValueFromJava(value));
    }

    @Override
    public boolean addNode(Node node) throws IllegalArgumentException {
        assert (node instanceof HostNode);
        assert (((HostNode)node).getType().getGraph() == this.typeFactory.getGraph());
        boolean result = super.addNode(node);
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            Algebra<?> algebra = valueNode.getAlgebra();
            Object value = valueNode.getValue();
            Map<Object, ValueNode> valueMap = this.getValueMap(algebra);
            ValueNode oldNode = valueMap.put(value, valueNode);
            assert (result == (oldNode == null));
            if (oldNode != null && oldNode != node) {
                throw new IllegalArgumentException(String.format("Duplicate value nodes for %s:%s", new Object[]{algebra.getKind(), algebra.getSymbol(value)}));
            }
        }
        return result;
    }

    private Map<Object, ValueNode> getValueMap(Algebra<?> algebra) {
        Map<Object, ValueNode> result = this.valueMaps.get(algebra.getName());
        if (result == null) {
            result = new HashMap<Object, ValueNode>();
            this.valueMaps.put(algebra.getName(), result);
        }
        return result;
    }

    @Override
    public HostEdge createEdge(HostNode source, String text, HostNode target) {
        return this.createEdge(source, (Label)this.createLabel(text), target);
    }

    @Override
    public HostEdge createEdge(HostNode source, Label label, HostNode target) {
        TypeEdge type = this.getTypeFactory().createEdge(source.getType(), (TypeLabel)label, target.getType(), false);
        assert (type != null);
        HostEdge edge = this.newEdge(source, type, target, this.getEdgeCount());
        return this.storeEdge(edge);
    }

    public HostEdge createEdge(HostNode source, TypeEdge type, HostNode target) {
        HostEdge edge = this.newEdge(source, type, target, this.getEdgeCount());
        return this.storeEdge(edge);
    }

    @Override
    protected HostNode newNode(int nr) {
        return new DefaultHostNode(nr, this.getLastNodeType());
    }

    @Override
    protected HostEdge newEdge(HostNode source, Label label, HostNode target, int nr) {
        throw new UnsupportedOperationException();
    }

    protected HostEdge newEdge(HostNode source, TypeEdge type, HostNode target, int nr) {
        assert (type.getGraph() == this.getTypeGraph());
        return new DefaultHostEdge(source, type, target, nr);
    }

    @Override
    public TypeLabel createLabel(String text) {
        return this.getTypeFactory().createLabel(text);
    }

    public HostGraphMorphism createMorphism() {
        return new HostGraphMorphism(this);
    }

    public RuleToHostMap createRuleToHostMap() {
        return new RuleToHostMap(this);
    }

    protected final void setLastNodeType(TypeNode type) {
        assert (this.lastNodeType == null);
        assert (type != null);
        this.lastNodeType = type;
    }

    protected final void resetLastNodeType() {
        assert (this.lastNodeType != null);
        this.lastNodeType = null;
    }

    protected final TypeNode getLastNodeType() {
        TypeNode result = this.lastNodeType;
        return result;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public TypeGraph getTypeGraph() {
        return this.getTypeFactory().getGraph();
    }

    public HostNode[] normalise(HostNode[] nodes) {
        List<HostNode> nodeList;
        HostNode[] result;
        if (this.normalHostNodeMap == null) {
            this.normalHostNodeMap = new HashMap<List<HostNode>, HostNode[]>();
        }
        if ((result = this.normalHostNodeMap.get(nodeList = Arrays.asList(nodes))) == null) {
            result = nodes;
            this.normalHostNodeMap.put(nodeList, nodes);
            ++normaliseCount;
        } else {
            ++normaliseGain;
        }
        return result;
    }

    public static HostFactory newInstance() {
        return HostFactory.newInstance(TypeFactory.newInstance());
    }

    public static HostFactory newInstance(TypeFactory typeFactory) {
        return new HostFactory(typeFactory);
    }

    public static int getNormaliseGain() {
        return normaliseGain;
    }

    public static int getNormaliseCount() {
        return normaliseCount;
    }
}

