/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.aspect;

import groove.grammar.aspect.Aspect;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.type.TypeLabel;
import groove.graph.ALabel;
import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class AspectLabel
extends ALabel {
    private final List<Aspect> aspects = new ArrayList<Aspect>();
    private Aspect edgeOnly;
    private Aspect nodeOnly;
    private String innerText;
    private final GraphRole role;
    private final FormatErrorSet errors = new FormatErrorSet();
    private static final Map<GraphRole, String> roleDescription = new EnumMap<GraphRole, String>(GraphRole.class);

    static {
        roleDescription.put(GraphRole.HOST, "host graph");
        roleDescription.put(GraphRole.TYPE, "type graph");
        roleDescription.put(GraphRole.RULE, "rule graph");
    }

    public AspectLabel(GraphRole role) {
        assert (role.inGrammar());
        this.role = role;
    }

    private AspectLabel(AspectLabel other) {
        this.role = other.role;
        this.aspects.addAll(other.aspects);
        this.innerText = other.innerText;
        this.edgeOnly = other.edgeOnly;
        this.nodeOnly = other.nodeOnly;
    }

    @Override
    public String text() {
        this.setFixed();
        return this.toString();
    }

    @Override
    public EdgeRole getRole() {
        return EdgeRole.parseLabel(this.getInnerText()).one();
    }

    public GraphRole getGraphRole() {
        return this.role;
    }

    @Override
    public boolean setFixed() {
        boolean result = super.setFixed();
        if (result && this.innerText == null) {
            this.innerText = "";
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        for (Aspect value : this.aspects) {
            result.append(value.toString());
        }
        if (this.innerText != null) {
            result.append(this.getInnerText());
        }
        return result.toString();
    }

    public void addAspect(Aspect value) {
        boolean notForEdge;
        this.testFixed(false);
        this.aspects.add(value);
        boolean notForNode = !value.isForNode(this.role);
        boolean bl = notForEdge = !value.isForEdge(this.role);
        if (notForNode) {
            if (notForEdge) {
                this.addError("Aspect %s not allowed in %s", new Object[]{value, roleDescription.get((Object)this.role), this.role});
            } else {
                this.edgeOnly = value;
            }
        } else if (notForEdge) {
            this.nodeOnly = value;
        }
        if (this.nodeOnly != null && this.edgeOnly != null) {
            this.addError("Conflicting aspects %s and %s", this.nodeOnly, this.edgeOnly);
        }
    }

    public AspectLabel clone() {
        return new AspectLabel(this);
    }

    public AspectLabel relabel(TypeLabel oldLabel, TypeLabel newLabel) {
        AspectLabel result = this;
        boolean isNew = false;
        ArrayList<Aspect> newAspects = new ArrayList<Aspect>();
        for (Aspect aspect : this.getAspects()) {
            Aspect newAspect = aspect.relabel(oldLabel, newLabel);
            isNew |= newAspect != aspect;
            newAspects.add(newAspect);
        }
        if (isNew) {
            result = new AspectLabel(this.getGraphRole());
            for (Aspect newAspect : newAspects) {
                result.addAspect(newAspect);
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof AspectLabel && this.equalsAspects((AspectLabel)obj) && this.equalsText((AspectLabel)obj);
    }

    @Override
    protected int computeHashCode() {
        int result = this.aspects.hashCode();
        if (this.innerText != null) {
            result += this.innerText.hashCode();
        }
        return result;
    }

    public boolean equalsAspects(AspectLabel other) {
        return this.aspects.equals(other.aspects);
    }

    private boolean equalsText(AspectLabel other) {
        boolean result = this.innerText == null ? other.innerText == null : this.innerText.equals(other.innerText);
        return result;
    }

    public List<Aspect> getAspects() {
        return this.aspects;
    }

    public final boolean isEdgeOnly() {
        return this.edgeOnly != null || this.innerText != null && this.innerText.length() > 0;
    }

    public final boolean isNodeOnly() {
        return this.nodeOnly != null || this.edgeOnly == null && this.innerText != null && this.innerText.length() == 0;
    }

    public Aspect getEdgeOnlyAspect() {
        return this.edgeOnly;
    }

    public Aspect getNodeOnlyAspect() {
        return this.nodeOnly;
    }

    public void setInnerText(String text) {
        this.testFixed(false);
        this.innerText = text;
        if (text.length() > 0 && this.nodeOnly != null) {
            this.addError("Aspect %s cannot have label text %s", this.nodeOnly, text);
        }
        this.setFixed();
    }

    public String getInnerText() {
        this.setFixed();
        return this.innerText;
    }

    void addError(String message, Object ... args) {
        this.testFixed(false);
        this.errors.add(message, args);
    }

    public boolean hasErrors() {
        this.testFixed(true);
        return !this.errors.isEmpty();
    }

    public FormatErrorSet getErrors() {
        this.testFixed(true);
        return this.errors;
    }
}

