/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.aspect;

import groove.algebra.Operator;
import groove.algebra.SignatureKind;
import groove.automaton.RegExpr;
import groove.grammar.aspect.Aspect;
import groove.grammar.aspect.AspectElement;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.aspect.AspectNode;
import groove.grammar.aspect.Assignment;
import groove.grammar.aspect.Expression;
import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.rule.RuleLabel;
import groove.grammar.type.Multiplicity;
import groove.grammar.type.TypeLabel;
import groove.graph.AEdge;
import groove.graph.ALabel;
import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.graph.plain.PlainLabel;
import groove.util.ExprParser;
import groove.util.Fixable;

public class AspectEdge
extends AEdge<AspectNode, AspectLabel>
implements AspectElement,
Fixable {
    private final GraphRole graphRole;
    private TypeLabel typeLabel;
    private RuleLabel ruleLabel;
    private Aspect aspect;
    private Aspect attr;
    private SignatureKind signature;
    private Aspect labelMode;
    private String levelName;
    private int argumentNr = -1;
    private Operator operator = null;
    private Multiplicity inMult;
    private Multiplicity outMult;
    private boolean composite;
    private boolean fixed;
    private final FormatErrorSet errors = new FormatErrorSet();

    public AspectEdge(AspectNode source, AspectLabel label, AspectNode target) {
        super(source, label, target);
        assert (label.isFixed());
        if (!label.hasErrors() && label.isNodeOnly()) {
            if (label.getNodeOnlyAspect() == null) {
                this.errors.add("Empty edge label not allowed", this);
            } else {
                this.errors.add("Aspect %s not allowed in edge label", label.getNodeOnlyAspect(), this);
            }
        }
        for (FormatError error : ((AspectLabel)this.label()).getErrors()) {
            this.errors.add(error.extend(this));
        }
        this.graphRole = label.getGraphRole();
    }

    public GraphRole getGraphRole() {
        return this.graphRole;
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.fixed = true;
            if (!this.hasErrors()) {
                this.setAspectsFixed();
            }
        }
        return result;
    }

    @Override
    public EdgeRole getRole() {
        if (this.isPredicate()) {
            return EdgeRole.FLAG;
        }
        return this.getDisplayLabel().getRole();
    }

    /*
     * Unable to fully structure code
     */
    private void setAspectsFixed() {
        block5: {
            try {
                this.setAspects((AspectLabel)this.label());
                this.inferAspects();
                this.checkAspects();
                if (this.graphRole == GraphRole.RULE) {
                    this.ruleLabel = this.createRuleLabel();
                    this.typeLabel = null;
                } else {
                    this.ruleLabel = null;
                    this.typeLabel = this.createTypeLabel();
                }
                ((AspectNode)this.target()).inferInAspect(this);
                ((AspectNode)this.source()).inferOutAspect(this);
                if (this.graphRole != GraphRole.RULE || this.getKind().isMeta()) break block5;
                this.checkRegExprs();
                break block5;
            }
            catch (FormatException exc) {
                ** for (error : exc.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                this.errors.add(error.extend(new Object[]{this}));
                continue;
            }
        }
    }

    @Override
    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    @Override
    public FormatErrorSet getErrors() {
        this.setFixed();
        return this.errors;
    }

    public void addError(FormatError error) {
        this.testFixed(false);
        this.errors.add(error.extend(this));
    }

    private void checkAspects() throws FormatException {
        if (this.graphRole == GraphRole.RULE) {
            if (this.getKind() == AspectKind.ABSTRACT || this.getKind() == AspectKind.SUBTYPE) {
                throw new FormatException("Edge aspect %s not allowed in rules", this.getAspect(), this);
            }
            if (!this.hasAspect()) {
                this.setAspect(AspectKind.READER.getAspect());
            }
            if (this.getAttrKind() == AspectKind.TEST ? this.getKind().isCreator() : this.hasAttrAspect() && this.getKind() != AspectKind.READER && this.getKind() != AspectKind.EMBARGO) {
                throw new FormatException("Conflicting aspects %s and %s", this.getAttrAspect(), this.getAspect());
            }
        } else {
            if (this.getKind().isRole()) {
                throw new FormatException("Edge aspect %s only allowed in rules", this.getAspect(), this);
            }
            if (!this.hasAspect()) {
                this.setAspect(AspectKind.DEFAULT.getAspect());
            }
        }
        if (!this.hasAttrAspect()) {
            this.setAttrAspect(AspectKind.DEFAULT.getAspect());
        }
        if (!this.hasLabelMode()) {
            this.setLabelMode(AspectKind.DEFAULT.getAspect());
        }
    }

    private void checkRegExprs() throws FormatException {
        boolean simple;
        RuleLabel ruleLabel = this.ruleLabel;
        boolean bl = simple = ruleLabel == null || ruleLabel.isAtom() || ruleLabel.isSharp() || ruleLabel.isWildcard() && ruleLabel.getWildcardGuard().isNamed();
        if (!simple) {
            AspectKind kind = this.getKind();
            assert (kind.isRole());
            String message = null;
            RegExpr matchExpr = ruleLabel.getMatchExpr();
            if (matchExpr != null && matchExpr.containsOperator("!")) {
                message = "Negation only allowed as top-level operator";
            } else if (kind.isCreator()) {
                if (ruleLabel.isWildcard()) {
                    message = "Unnamed wildcard %s not allowed on creators";
                } else if (!ruleLabel.isEmpty()) {
                    message = "Regular expression label %s not allowed on creators";
                }
            } else if (kind.isEraser() && !((AspectNode)this.source()).getKind().isEraser() && !((AspectNode)this.target()).getKind().isEraser() && !ruleLabel.isWildcard()) {
                message = "Regular expression label %s not allowed on erasers";
            }
            if (message != null) {
                throw new FormatException(message, ruleLabel, this);
            }
        }
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public void testFixed(boolean fixed) {
        if (fixed != this.isFixed()) {
            throw new IllegalStateException(String.format("Aspect edge %s should %sbe fixed", this, fixed ? "" : "not "));
        }
    }

    private void setAspects(AspectLabel label) throws FormatException {
        assert (!label.isNodeOnly());
        for (Aspect aspect : label.getAspects()) {
            this.declareAspect(aspect);
        }
    }

    private void inferAspects() throws FormatException {
        AspectKind sourceKind = ((AspectNode)this.source).getKind();
        AspectKind targetKind = ((AspectNode)this.target).getKind();
        if (sourceKind == AspectKind.REMARK || targetKind == AspectKind.REMARK) {
            this.setAspect(AspectKind.REMARK.getAspect());
        } else if (sourceKind.isQuantifier() || targetKind.isQuantifier()) {
            if (this.getKind() != AspectKind.NESTED && this.getKind() != AspectKind.REMARK && this.getAttrKind() != AspectKind.TEST) {
                this.setAspect(AspectKind.NESTED.getAspect().newInstance(this.getInnerText(), this.getGraphRole()));
            }
        } else if (this.getKind() != AspectKind.REMARK && this.getKind() != AspectKind.SUBTYPE && this.getKind() != AspectKind.CONNECT && this.getKind() != AspectKind.LET) {
            Aspect inferredAspect;
            AspectKind sourceRole = null;
            AspectKind targetRole = null;
            if (sourceKind.isRole() && sourceKind != AspectKind.READER) {
                sourceRole = sourceKind;
            }
            if (targetKind.isRole() && targetKind != AspectKind.READER) {
                targetRole = targetKind;
            }
            if (sourceRole == null) {
                inferredAspect = ((AspectNode)this.target()).getAspect();
            } else if (targetRole == null) {
                inferredAspect = ((AspectNode)this.source()).getAspect();
            } else if (sourceRole == AspectKind.ERASER && targetRole == AspectKind.EMBARGO) {
                inferredAspect = ((AspectNode)this.target()).getAspect();
            } else if (sourceRole == AspectKind.EMBARGO && targetRole == AspectKind.ERASER) {
                inferredAspect = ((AspectNode)this.source()).getAspect();
            } else if (sourceRole == targetRole) {
                inferredAspect = ((AspectNode)this.source()).getAspect();
            } else {
                throw new FormatException("Conflicting aspects %s and %s", ((AspectNode)this.source()).getAspect(), ((AspectNode)this.target()).getAspect());
            }
            if (inferredAspect != null && inferredAspect.getKind().isRole() && inferredAspect.getKind() != AspectKind.READER && (inferredAspect.getKind() != AspectKind.ERASER || this.getKind() != AspectKind.EMBARGO)) {
                this.setAspect(inferredAspect);
            }
        }
    }

    private void declareAspect(Aspect value) throws FormatException {
        assert (value.isForEdge(this.graphRole));
        AspectKind kind = value.getKind();
        if (kind == AspectKind.PATH || kind == AspectKind.LITERAL) {
            this.setLabelMode(value);
        } else if (kind.isAttrKind()) {
            this.setAttrAspect(value);
        } else {
            this.setAspect(value);
        }
    }

    public boolean equalsAspects(AspectElement other) {
        boolean result;
        assert (this.isFixed() && other.isFixed());
        boolean bl = this.getAspect() == null ? other.getAspect() == null : (result = this.getAspect().equals(other.getAspect()));
        if (result) {
            boolean bl2 = this.getAttrAspect() == null ? other.getAttrAspect() == null : (result = this.getAttrAspect().equals(other.getAttrAspect()));
        }
        if (result && other instanceof AspectEdge) {
            Aspect otherMode = ((AspectEdge)other).getLabelMode();
            result = this.getLabelMode().equals(otherMode);
        }
        return result;
    }

    public String getInnerText() {
        return ((AspectLabel)this.label()).getInnerText();
    }

    public PlainLabel getPlainLabel() {
        return PlainLabel.createLabel(((AspectLabel)this.label()).toString());
    }

    public Label getDisplayLabel() {
        ALabel result = null;
        result = this.graphRole == GraphRole.RULE ? this.getRuleLabel() : this.getTypeLabel();
        if (result == null) {
            String text = null;
            if (this.getKind() == AspectKind.NESTED) {
                text = this.getAspect().getContentString();
            } else if (this.isPredicate()) {
                text = this.getPredicate() instanceof Assignment ? ((Assignment)this.getPredicate()).toDisplayString("?=") : ((Expression)this.getPredicate()).toDisplayString();
            } else if (this.isAssign()) {
                text = this.getAssign().toDisplayString(this.getGraphRole() == GraphRole.RULE ? ":=" : "=");
            } else if (this.getKind() == AspectKind.CONNECT) {
                text = "+";
            } else if (this.getAttrKind() == AspectKind.ARGUMENT) {
                text = "\u03c0" + this.getArgument();
            } else if (this.getAttrKind().hasSignature()) {
                if (this.getGraphRole() == GraphRole.TYPE) {
                    text = this.getAttrAspect().getContentString();
                } else if (this.getOperator() != null) {
                    text = this.getOperator().getName();
                }
            }
            if (text == null) {
                text = this.getInnerText();
            }
            result = PlainLabel.createLabel(text);
        }
        return result;
    }

    public RuleLabel getRuleLabel() {
        this.testFixed(true);
        return this.ruleLabel;
    }

    private RuleLabel createRuleLabel() throws FormatException {
        RuleLabel result;
        assert (this.getGraphRole() == GraphRole.RULE);
        if (this.getKind().isMeta() || this.isAssign() || this.isPredicate()) {
            result = null;
        } else if (this.getAttrKind() != AspectKind.DEFAULT) {
            result = null;
        } else {
            assert (this.isAssign() || this.getKind().isRole());
            result = this.getLabelKind() == AspectKind.LITERAL ? new RuleLabel(this.getInnerText()) : new RuleLabel(this.parse(this.getInnerText()));
        }
        return result;
    }

    public TypeLabel getTypeLabel() {
        this.testFixed(true);
        return this.typeLabel;
    }

    private TypeLabel createTypeLabel() throws FormatException {
        TypeLabel result;
        if (this.getKind() == AspectKind.REMARK || this.isAssign() || this.isPredicate() || this.getGraphRole() == GraphRole.TYPE && this.getAttrKind().hasSignature()) {
            result = null;
        } else if (!this.getKind().isRole() && this.getLabelKind() != AspectKind.PATH) {
            result = this.getLabelKind() == AspectKind.LITERAL ? TypeLabel.createBinaryLabel(this.getInnerText()) : TypeLabel.createLabelWithCheck(this.getInnerText());
        } else {
            throw new FormatException("Edge label '%s' is only allowed in rules", this.label(), this);
        }
        return result;
    }

    private RegExpr parse(String text) throws FormatException {
        if (text.startsWith("!")) {
            RegExpr innerExpr = this.parse(text.substring("!".length()));
            return new RegExpr.Neg(innerExpr);
        }
        if (text.startsWith("{")) {
            text = ExprParser.toTrimmed(text, '{', '}');
        }
        return RegExpr.parse(text);
    }

    private void setAspect(Aspect aspect) throws FormatException {
        AspectKind kind = aspect.getKind();
        assert (!kind.isAttrKind() && kind != AspectKind.PATH && kind != AspectKind.LITERAL);
        if (kind.isQuantifier()) {
            if (!aspect.hasContent()) {
                throw new FormatException("Unnamed quantifier %s not allowed on edge", aspect, this);
            }
            if (this.levelName != null) {
                throw new FormatException("Duplicate quantifier levels %s and %s", this.levelName, aspect.getContent(), this);
            }
            this.levelName = (String)aspect.getContent();
        } else if (kind.isRole() && aspect.hasContent()) {
            if (this.levelName != null) {
                throw new FormatException("Duplicate quantifier levels %s and %s", this.levelName, aspect.getContent(), this);
            }
            this.levelName = (String)aspect.getContent();
        }
        if (kind == AspectKind.MULT_IN) {
            this.inMult = (Multiplicity)aspect.getContent();
        } else if (kind == AspectKind.MULT_OUT) {
            this.outMult = (Multiplicity)aspect.getContent();
        } else if (kind == AspectKind.COMPOSITE) {
            this.composite = true;
        } else if (!kind.isQuantifier()) {
            if (this.aspect == null) {
                this.aspect = aspect;
            } else if (!this.aspect.equals(aspect)) {
                throw new FormatException("Conflicting aspects %s and %s", this.aspect, aspect, this);
            }
        }
    }

    @Override
    public Aspect getAspect() {
        return this.aspect;
    }

    private boolean hasAspect() {
        return this.aspect != null;
    }

    @Override
    public AspectKind getKind() {
        return this.hasAspect() ? this.getAspect().getKind() : AspectKind.DEFAULT;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public boolean isNestedAt() {
        return this.hasAspect() && this.getKind() == AspectKind.NESTED && this.getAspect().getContent() == AspectKind.NestedValue.AT;
    }

    public boolean isNestedIn() {
        return this.hasAspect() && this.getKind() == AspectKind.NESTED && this.getAspect().getContent() == AspectKind.NestedValue.IN;
    }

    public boolean isNestedCount() {
        return this.hasAspect() && this.getKind() == AspectKind.NESTED && this.getAspect().getContent() == AspectKind.NestedValue.COUNT;
    }

    public boolean isMerger() {
        this.testFixed(true);
        return this.getKind().inRHS() && !this.getKind().inLHS() && this.getRuleLabel().isEmpty();
    }

    private void setAttrAspect(Aspect type) {
        AspectKind kind = type.getKind();
        assert (kind == AspectKind.DEFAULT || kind.isAttrKind());
        assert (this.attr == null);
        this.attr = type;
        if (type.getKind() == AspectKind.ARGUMENT) {
            this.attr = type;
            this.argumentNr = (Integer)this.attr.getContent();
        } else if (kind.hasSignature()) {
            this.attr = type;
            this.signature = kind.getSignature();
            if (this.getGraphRole() == GraphRole.RULE) {
                this.operator = (Operator)type.getContent();
            }
        }
    }

    @Override
    public Aspect getAttrAspect() {
        return this.attr;
    }

    @Override
    public boolean hasAttrAspect() {
        return this.attr != null && this.attr.getKind() != AspectKind.DEFAULT;
    }

    @Override
    public AspectKind getAttrKind() {
        return this.hasAttrAspect() ? this.getAttrAspect().getKind() : AspectKind.DEFAULT;
    }

    public SignatureKind getSignature() {
        return this.signature;
    }

    public boolean isArgument() {
        return this.argumentNr >= 0;
    }

    public boolean isAssign() {
        return this.hasAspect() && this.getKind() == AspectKind.LET;
    }

    public Assignment getAssign() {
        assert (this.isAssign());
        return (Assignment)this.getAspect().getContent();
    }

    public boolean isPredicate() {
        return this.hasAttrAspect() && this.getAttrKind() == AspectKind.TEST;
    }

    public Object getPredicate() {
        assert (this.isPredicate());
        return this.getAttrAspect().getContent();
    }

    public int getArgument() {
        return this.argumentNr;
    }

    public boolean isOperator() {
        return this.operator != null;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public Multiplicity getInMult() {
        return this.inMult;
    }

    public Multiplicity getOutMult() {
        return this.outMult;
    }

    private void setLabelMode(Aspect type) throws FormatException {
        AspectKind kind = type.getKind();
        assert (kind == AspectKind.DEFAULT || kind == AspectKind.PATH || kind == AspectKind.LITERAL);
        if (this.labelMode != null) {
            throw new FormatException("Conflicting edge aspects %s and %s", this.labelMode, type, this);
        }
        this.labelMode = type;
    }

    public Aspect getLabelMode() {
        return this.labelMode;
    }

    public boolean hasLabelMode() {
        return this.getLabelMode() != null;
    }

    public AspectKind getLabelKind() {
        return this.hasLabelMode() ? this.getLabelMode().getKind() : null;
    }
}

