/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar;

import groove.algebra.AlgebraFamily;
import groove.control.CtrlPar;
import groove.grammar.GrammarProperties;
import groove.grammar.Rule;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.rule.OperatorNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleFactory;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.grammar.type.TypeGraph;
import groove.graph.EdgeRole;
import groove.io.HTMLConverter;
import groove.match.SearchEngine;
import groove.util.Fixable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Condition
implements Fixable {
    private final Op op;
    private final String name;
    private final RuleFactory factory;
    private Rule rule;
    private final Collection<Condition> subConditions = new ArrayList<Condition>();
    private boolean fixed;
    private boolean fixing;
    private final RuleGraph root;
    private Set<RuleNode> inputNodes;
    private final RuleGraph pattern;
    private final GrammarProperties systemProperties;
    private TypeGraph typeGraph;
    private VariableNode countNode;
    private boolean positive;
    public static final Condition True = new Condition("true", Op.TRUE);
    public static final Condition False = new Condition("false", Op.FALSE);

    static {
        try {
            True.setFixed();
            False.setFixed();
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
    }

    public Condition(String name, Op operator) {
        assert (name != null);
        assert (!operator.hasPattern());
        this.op = operator;
        this.name = name;
        this.factory = null;
        this.pattern = null;
        this.root = null;
        this.systemProperties = null;
    }

    public Condition(String name, Op operator, RuleGraph pattern, RuleGraph root, GrammarProperties properties) {
        assert (name != null);
        assert (operator.hasPattern());
        this.op = operator;
        this.name = name;
        this.factory = pattern.getFactory();
        this.root = root == null ? pattern.newGraph(String.valueOf(name) + "-root") : root;
        this.pattern = pattern;
        this.systemProperties = properties;
    }

    public GrammarProperties getSystemProperties() {
        return this.systemProperties;
    }

    public void setTypeGraph(TypeGraph typeGraph) {
        assert (typeGraph != null);
        this.typeGraph = typeGraph;
        for (Condition sub : this.getSubConditions()) {
            sub.setTypeGraph(typeGraph);
        }
    }

    public TypeGraph getTypeGraph() {
        return this.typeGraph;
    }

    public RuleGraph getRoot() {
        return this.root;
    }

    public final Set<RuleNode> getInputNodes() {
        if (this.inputNodes == null) {
            this.inputNodes = this.computeInputNodes();
        }
        return this.inputNodes;
    }

    Set<RuleNode> computeInputNodes() {
        if (this.hasRule() && this.getRule().isTop()) {
            HashSet<RuleNode> result = new HashSet<RuleNode>();
            for (CtrlPar.Var var : this.getRule().getSignature()) {
                if (!var.isInOnly()) continue;
                result.add(var.getRuleNode());
            }
            return result;
        }
        return new HashSet<RuleNode>(this.root.nodeSet());
    }

    public boolean hasPattern() {
        return this.getPattern() != null;
    }

    public RuleGraph getPattern() {
        return this.pattern;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGround() {
        assert (this.isFixed());
        return this.root.isEmpty();
    }

    public Collection<Condition> getSubConditions() {
        return this.subConditions;
    }

    public void addSubCondition(Condition condition) {
        if (!this.getOp().hasOperands()) {
            throw new UnsupportedOperationException(String.format("%s conditions cannot have subconditions", new Object[]{condition.getOp()}));
        }
        condition.testFixed(true);
        this.testFixed(false);
        if (this.typeGraph != null) {
            condition.setTypeGraph(this.typeGraph);
        }
        this.getSubConditions().add(condition);
        if (this.getRule() != null) {
            for (Rule subRule : condition.getTopRules()) {
                this.getRule().addSubRule(subRule);
            }
        }
    }

    boolean hasModifyingSubrule() {
        boolean result = false;
        for (Rule rule : this.getTopRules()) {
            if (!rule.isModifying()) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<Rule> getTopRules() {
        ArrayList<Rule> result = new ArrayList<Rule>();
        if (this.getRule() == null) {
            for (Condition subCond : this.getSubConditions()) {
                result.addAll(subCond.getTopRules());
            }
        } else {
            result.add(this.getRule());
        }
        return result;
    }

    @Override
    public boolean setFixed() throws FormatException {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result && !this.fixing) {
            this.fixing = true;
            for (Condition subCondition : this.getSubConditions()) {
                subCondition.testFixed(true);
            }
            this.fixed = true;
            if (this.hasPattern()) {
                this.getPattern().setFixed();
                if (!this.getSystemProperties().getAlgebraFamily().supportsSymbolic()) {
                    this.checkResolution();
                }
                if (this.getRule() != null) {
                    this.getRule().setFixed();
                }
            }
            this.fixing = false;
        }
        return result;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public void testFixed(boolean value) throws IllegalStateException {
        if (this.isFixed() != value) {
            String message = value ? "Graph condition should be fixed in this state" : "Graph condition should not be fixed in this state";
            throw new IllegalStateException(message);
        }
    }

    void testGround() throws IllegalStateException {
        if (!this.isGround()) {
            throw new IllegalStateException("Method only allowed on ground condition");
        }
    }

    public void checkResolution() throws FormatException {
        FormatErrorSet errors = new FormatErrorSet();
        Map<VariableNode, List<Set<VariableNode>>> resolverMap = this.createResolvers();
        this.stabilise(resolverMap);
        for (RuleNode ruleNode : resolverMap.keySet()) {
            errors.add("Variable node '%s' cannot always be assigned (use %s algebra for symbolic exploration)", ruleNode, AlgebraFamily.POINT.getName());
        }
        errors.throwException();
    }

    private Map<VariableNode, List<Set<VariableNode>>> createResolvers() {
        HashMap<VariableNode, List<Set<VariableNode>>> result = new HashMap<VariableNode, List<Set<VariableNode>>>();
        HashSet<VariableNode> resolved = new HashSet<VariableNode>();
        for (RuleNode ruleNode : this.getInputNodes()) {
            if (!(ruleNode instanceof VariableNode)) continue;
            resolved.add((VariableNode)ruleNode);
        }
        for (RuleNode ruleNode : this.getPattern().nodeSet()) {
            if (!(ruleNode instanceof VariableNode) || ((VariableNode)ruleNode).getConstant() != null || resolved.contains(ruleNode)) continue;
            VariableNode varNode = (VariableNode)ruleNode;
            boolean isResolved = false;
            for (RuleEdge inEdge : this.getPattern().inEdgeSet(ruleNode)) {
                RuleLabel inLabel = (RuleLabel)inEdge.label();
                if (inLabel.isEmpty() || inLabel.isNeg()) continue;
                isResolved = true;
                break;
            }
            if (isResolved) {
                resolved.add(varNode);
                continue;
            }
            result.put(varNode, new ArrayList());
        }
        if (this.getOp().isConjunctive() || this.getSubConditions().size() == 1) {
            for (Condition condition : this.getSubConditions()) {
                VariableNode countNode = condition.getCountNode();
                if (countNode == null || countNode.getConstant() != null || resolved.contains(countNode)) continue;
                HashSet<VariableNode> resolver = new HashSet<VariableNode>();
                for (RuleNode rootNode : condition.getInputNodes()) {
                    if (!(rootNode instanceof VariableNode) || ((VariableNode)rootNode).getConstant() != null) continue;
                    resolver.add((VariableNode)rootNode);
                }
                resolver.removeAll(resolved);
                if (resolver.isEmpty()) {
                    resolved.add(countNode);
                    continue;
                }
                this.addResolver(result, countNode, resolver);
            }
        }
        for (RuleNode ruleNode : this.getPattern().nodeSet()) {
            OperatorNode opNode;
            VariableNode target;
            if (!(ruleNode instanceof OperatorNode) || !result.containsKey(target = (opNode = (OperatorNode)ruleNode).getTarget()) || resolved.contains(target)) continue;
            HashSet<VariableNode> resolver = new HashSet<VariableNode>();
            for (VariableNode arg : opNode.getArguments()) {
                if (arg.hasConstant()) continue;
                resolver.add(arg);
            }
            resolver.removeAll(resolved);
            if (resolver.isEmpty()) {
                resolved.add(target);
                continue;
            }
            ((List)result.get(target)).add(resolver);
        }
        for (VariableNode variableNode : resolved) {
            result.remove(variableNode);
        }
        return result;
    }

    private <K, V> void addResolver(Map<K, List<V>> map, K key, V value) {
        List<V> entry = map.get(key);
        if (entry == null) {
            entry = new ArrayList<V>();
            map.put(key, entry);
        }
        entry.add(value);
    }

    private void stabilise(Map<VariableNode, List<Set<VariableNode>>> resolverMap) {
        boolean stable = false;
        while (!stable) {
            stable = true;
            Iterator<List<Set<VariableNode>>> iter = resolverMap.values().iterator();
            block1: while (iter.hasNext()) {
                for (Set<VariableNode> resolver : iter.next()) {
                    resolver.retainAll(resolverMap.keySet());
                    if (!resolver.isEmpty()) continue;
                    iter.remove();
                    stable = false;
                    continue block1;
                }
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder result = new StringBuilder();
        result.append(prefix);
        result.append(String.format("%s condition %s", this.getOp().getName(), this.getName()));
        if (this.hasPattern()) {
            result.append('\n');
            result.append(prefix);
            result.append(" * Root:    " + this.getRoot());
            result.append('\n');
            result.append(prefix);
            result.append(" * Pattern: " + this.getPattern());
        }
        if (this.hasRule()) {
            result.append('\n');
            result.append(prefix);
            result.append(" * RHS:     " + this.getRule().rhs());
        }
        if (this.hasCountNode()) {
            result.append('\n');
            result.append(prefix);
            result.append(" * Count:   " + this.getCountNode());
        }
        if (!this.getSubConditions().isEmpty()) {
            result.append('\n');
            result.append(prefix);
            result.append(" * Subconditions:");
            for (Condition sub : this.getSubConditions()) {
                result.append('\n');
                result.append(sub.toString(String.valueOf(prefix) + "     "));
            }
        }
        return result.toString();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Condition other = (Condition)obj;
        return this.getName().equals(other.getName());
    }

    public final Op getOp() {
        return this.op;
    }

    public final boolean isNot() {
        return this.getOp() == Op.NOT;
    }

    public RuleFactory getFactory() {
        return this.factory;
    }

    public void setCountNode(VariableNode countNode) {
        assert (!this.isFixed());
        this.countNode = countNode;
    }

    public VariableNode getCountNode() {
        return this.countNode;
    }

    public boolean hasCountNode() {
        return this.countNode != null;
    }

    public void setPositive() {
        assert (!this.isFixed());
        this.positive = true;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public boolean isInjective() {
        return this.getSystemProperties() != null && this.getSystemProperties().isInjective();
    }

    public void setRule(Rule rule) {
        assert (!this.isFixed());
        this.rule = rule;
    }

    public final boolean hasRule() {
        return this.getRule() != null;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Condition reverse() {
        assert (this.getOp() == Op.NOT);
        Condition result = new Condition(String.valueOf(this.getName()) + "-reverse", Op.FORALL, this.getPattern(), this.getRoot(), this.getSystemProperties());
        result.addSubCondition(True);
        if (this.getTypeGraph() != null) {
            result.setTypeGraph(this.getTypeGraph());
        }
        if (this.isFixed()) {
            try {
                result.setFixed();
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean isReversable() {
        return this.isNot() && this.hasBinaryEdges();
    }

    public boolean isCompatible(SearchEngine.SearchMode searchMode) {
        switch (searchMode) {
            case NORMAL: {
                return true;
            }
            case MINIMAL: {
                return !this.isNot() || !this.hasBinaryEdges();
            }
            case REVERSE: {
                if (!this.isNot()) {
                    assert (this.getOp() == Op.TRUE);
                    return true;
                }
                return false;
            }
        }
        assert (false);
        return false;
    }

    private boolean hasBinaryEdges() {
        for (RuleEdge ruleEdge : this.getPattern().edgeSet()) {
            if (ruleEdge.getRole() != EdgeRole.BINARY) continue;
            return true;
        }
        return false;
    }

    public static final Condition newOr(Condition ... operands) {
        return Condition.newCondition(Op.OR, "or", operands);
    }

    public static final Condition newAnd(Condition ... operands) {
        return Condition.newCondition(Op.AND, "and", operands);
    }

    private static final Condition newCondition(Op op, String descr, Condition ... operands) {
        if (operands.length == 0) {
            throw new IllegalArgumentException(String.format("Can't build '%s' with empty operand list", descr));
        }
        StringBuilder name = new StringBuilder();
        int i = 0;
        while (i < operands.length) {
            if (i > 0) {
                name.append(' ');
                name.append(descr);
                name.append(' ');
            }
            name.append('(');
            name.append(operands[i].getName());
            name.append(')');
            ++i;
        }
        Condition result = new Condition(name.toString(), op);
        Condition[] conditionArray = operands;
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            Condition oper = conditionArray[n2];
            result.addSubCondition(oper);
            ++n2;
        }
        try {
            result.setFixed();
        }
        catch (FormatException e) {
            throw new IllegalArgumentException(String.format("Error while fixing new condition %s: %s", name, e.getMessage()));
        }
        return result;
    }

    public static enum Op {
        FORALL("Universal", '\u2200'),
        EXISTS("Existential", '\u2203'),
        NOT("Negated", '\u00ac'),
        AND("Conjunctive", '\u2227'),
        OR("Disjunctive", '\u2228'),
        TRUE("True", HTMLConverter.STRONG_TAG.on(Boolean.TRUE)),
        FALSE("False", HTMLConverter.STRONG_TAG.on(Boolean.FALSE));

        private final String name;
        private final String symbol;

        private Op(String name, char symbol) {
            this(name, "" + symbol);
        }

        private Op(String name, String symbol) {
            this.name = name;
            this.symbol = symbol;
        }

        public final String getSymbol() {
            return this.symbol;
        }

        public final String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public boolean isQuantifier() {
            return this == FORALL || this == EXISTS;
        }

        public boolean hasPattern() {
            return this.isQuantifier() || this == NOT;
        }

        public boolean hasOperands() {
            return this.isQuantifier() || this == AND || this == OR;
        }

        public boolean isConjunctive() {
            return this == EXISTS || this == AND;
        }
    }
}

