/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.explore.strategy.Boundary;
import groove.grammar.Action;
import groove.grammar.Rule;
import groove.lts.GraphTransition;
import groove.verify.ModelChecking;
import groove.verify.ProductTransition;
import java.util.HashSet;
import java.util.Set;

public class RuleSetBoundary
extends Boundary {
    private final Set<Rule> rules;

    public RuleSetBoundary(Set<Rule> rules) {
        this(rules, null);
    }

    private RuleSetBoundary(Set<Rule> rules, ModelChecking.Record record) {
        super(record);
        this.rules = new HashSet<Rule>(rules);
    }

    @Override
    public Boundary instantiate(ModelChecking.Record record) {
        return new RuleSetBoundary(this.rules, record);
    }

    @Override
    public boolean crossingBoundary(ProductTransition transition, boolean traverse) {
        boolean result = false;
        if (transition.graphTransition() != null && this.containsAction(transition.rule())) {
            boolean bl = result = this.currentDepth() >= this.getRecord().getIteration() - 2;
            if (!result && traverse) {
                this.increaseDepth();
            }
        }
        return result;
    }

    @Override
    public void increase() {
    }

    private boolean containsAction(Action action) {
        return this.rules.contains(action);
    }

    @Override
    public void backtrackTransition(GraphTransition transition) {
        if (transition.getAction() != null && this.containsAction(transition.getAction())) {
            this.decreaseDepth();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Action action : this.rules) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(action.getFullName());
        }
        return result.toString();
    }
}

