/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.explore.result.Acceptor;
import groove.explore.strategy.ExploreIterator;
import groove.explore.strategy.Strategy;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.match.MatcherFactory;

public abstract class GTSStrategy
extends Strategy
implements ExploreIterator {
    private GTS gts;
    private GraphState startState;
    private Acceptor acceptor;
    private GraphState nextState;

    @Override
    public void prepare(GTS gts, GraphState state, Acceptor acceptor) {
        this.gts = gts;
        this.startState = state == null ? gts.startState() : state;
        this.nextState = this.startState;
        this.acceptor = acceptor;
        if (acceptor != null) {
            gts.addLTSListener(acceptor);
        }
        MatcherFactory.instance().setDefaultEngine();
    }

    @Override
    public boolean hasNext() {
        return this.getNextState() != null;
    }

    @Override
    public void finish() {
        if (this.acceptor != null) {
            this.getGTS().removeLTSListener(this.acceptor);
        }
    }

    protected final GTS getGTS() {
        return this.gts;
    }

    protected final GraphState getStartState() {
        return this.startState;
    }

    protected GraphState getNextState() {
        return this.nextState;
    }

    protected final void setNextState() {
        this.nextState = this.computeNextState();
    }

    protected abstract GraphState computeNextState();
}

