/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.result;

import groove.explore.result.Acceptor;
import groove.explore.result.Result;
import groove.explore.strategy.LTLStrategy;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.verify.ModelChecking;
import groove.verify.ProductListener;
import groove.verify.ProductState;
import groove.verify.ProductStateSet;
import groove.verify.ProductTransition;
import java.util.ArrayList;
import java.util.Collection;

public class CycleAcceptor
extends Acceptor
implements ProductListener {
    private LTLStrategy strategy;
    private ModelChecking.Record record;

    public CycleAcceptor() {
        super(new CycleResult());
    }

    public void setStrategy(LTLStrategy strategy) {
        this.strategy = strategy;
        this.record = strategy.getRecord();
    }

    @Override
    public void setResult(Result result) {
    }

    @Override
    public void statusUpdate(GTS gts, GraphState state, GraphState.Flag flag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addUpdate(ProductStateSet gts, ProductState state) {
    }

    @Override
    public void closeUpdate(ProductStateSet gts, ProductState state) {
        ModelChecking.Outcome event;
        if (state.getBuchiLocation().isAccepting() && (event = this.redDFS(state)) != ModelChecking.Outcome.OK) {
            for (ProductState stackState : this.strategy.getStateStack()) {
                this.getResult().add(stackState.getGraphState());
            }
            this.getResult().add(state.getGraphState());
        }
    }

    private ModelChecking.Outcome redDFS(ProductState state) {
        for (ProductTransition nextTransition : state.outTransitions()) {
            ProductState target = nextTransition.target();
            if (target.colour() == this.record.cyan()) {
                return ModelChecking.Outcome.ERROR;
            }
            if (target.colour() != this.record.blue()) continue;
            target.setColour(this.record.red());
            ModelChecking.Outcome event = this.redDFS(target);
            if (event == ModelChecking.Outcome.OK) continue;
            return event;
        }
        return ModelChecking.Outcome.OK;
    }

    @Override
    public Acceptor newInstance() {
        CycleAcceptor result = new CycleAcceptor();
        return result;
    }

    @Override
    public String getMessage() {
        Collection<GraphState> states = this.getResult().getValue();
        String property = this.strategy.getProperty();
        String result = states.size() == 0 ? "No counterexample found for " + property : String.valueOf(property) + " is violated; counterexample: " + states;
        return result;
    }

    private static class CycleResult
    extends Result {
        public CycleResult() {
            super(1);
        }

        @Override
        protected Collection<GraphState> createResultSet() {
            return new ArrayList<GraphState>();
        }

        @Override
        public Result newInstance() {
            return new CycleResult();
        }
    }
}

