/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.encode;

import groove.explore.encode.EncodedTypeEditor;
import groove.grammar.model.GrammarModel;
import groove.gui.dialog.ExplorationDialog;
import groove.gui.layout.SpringUtilities;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StringEditor<A>
extends EncodedTypeEditor<A, String> {
    private final JTextField editor;
    private final String syntax;
    private final int nr_components;

    public StringEditor(GrammarModel grammar, String syntax, String initValue, int nrColumns) {
        super(grammar, new SpringLayout());
        this.nr_components = !syntax.equals("") ? 2 : 1;
        this.editor = new JTextField(initValue, nrColumns);
        this.editor.setBackground(ExplorationDialog.INFO_BOX_BG_COLOR);
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                StringEditor.this.notifyTemplateListeners();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                StringEditor.this.notifyTemplateListeners();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                StringEditor.this.notifyTemplateListeners();
            }
        });
        this.syntax = syntax;
        this.setBackground(ExplorationDialog.INFO_BG_COLOR);
        this.refresh();
    }

    public StringEditor(GrammarModel grammar, String initialValue, int nrColumns) {
        this(grammar, "", initialValue, nrColumns);
    }

    @Override
    public void refresh() {
        this.removeAll();
        if (!this.syntax.equals("")) {
            this.add(new JLabel("<HTML><FONT color=#005050><B>Syntax:</B> " + this.syntax + "</FONT></HTML>"));
        }
        this.add(this.editor);
        SpringUtilities.makeCompactGrid(this, this.nr_components, 1, 0, 0, 0, 0);
    }

    @Override
    public String getCurrentValue() {
        return this.editor.getText();
    }

    @Override
    public void setCurrentValue(String value) {
        this.editor.setText(value);
    }
}

