/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.encode;

import java.util.Map;
import java.util.TreeMap;

public class Serialized {
    private final String keyword;
    private final TreeMap<String, String> arguments;

    public Serialized(String keyword) {
        this.keyword = keyword;
        this.arguments = new TreeMap();
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getArgument(String name) {
        if (this.arguments.containsKey(name)) {
            return this.arguments.get(name);
        }
        return "";
    }

    public void setArgument(String name, String value) {
        this.arguments.put(name, value);
    }

    public void appendArgument(String name, String value) {
        this.setArgument(name, String.valueOf(this.getArgument(name)) + value);
    }

    public String toParsableString() {
        StringBuffer result = new StringBuffer(this.getKeyword());
        if (!this.arguments.keySet().isEmpty()) {
            boolean isFirst = true;
            result.append(":");
            for (Map.Entry<String, String> entry : this.arguments.entrySet()) {
                if (!isFirst) {
                    result.append(",");
                }
                result.append(entry.getValue());
                isFirst = false;
            }
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getKeyword());
        if (!this.arguments.keySet().isEmpty()) {
            Boolean isFirst = true;
            result.append("(");
            for (Map.Entry<String, String> entry : this.arguments.entrySet()) {
                if (!isFirst.booleanValue()) {
                    result.append(", ");
                }
                result.append(entry.getKey());
                result.append("=");
                result.append(entry.getValue());
                isFirst = false;
            }
            result.append(")");
        }
        return result.toString();
    }
}

