/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.algebra.AlgebraFamily;
import groove.control.CtrlAut;
import groove.control.CtrlFactory;
import groove.control.parse.CtrlBuilder;
import groove.control.parse.CtrlChecker;
import groove.control.parse.CtrlLexer;
import groove.control.parse.CtrlParser;
import groove.control.parse.CtrlTree;
import groove.control.parse.Namespace;
import groove.grammar.Action;
import groove.grammar.Grammar;
import groove.grammar.QualName;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.io.ExtensionFilter;
import groove.io.FileType;
import groove.util.Groove;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;

public class CtrlLoader {
    private Namespace namespace;
    private AlgebraFamily family;
    private final Map<String, CtrlTree> treeMap = new TreeMap<String, CtrlTree>();
    private FormatErrorSet errors;
    private final CtrlParser parser = new CtrlParser(null);
    private final CtrlChecker checker = new CtrlChecker(null);
    private final CtrlBuilder builder = new CtrlBuilder(null);
    private static final ExtensionFilter controlFilter = FileType.CONTROL_FILTER;
    private static final boolean DEBUG = false;
    private static final CtrlLoader instance = new CtrlLoader();

    public void init(AlgebraFamily algebraFamily, Collection<Rule> rules) {
        this.family = algebraFamily == null ? AlgebraFamily.DEFAULT : algebraFamily;
        this.namespace = new Namespace();
        for (Rule rule : rules) {
            this.namespace.addRule(rule);
        }
        this.treeMap.clear();
        this.errors = null;
    }

    public void parse(String name, String program) throws FormatException {
        assert (this.errors == null);
        ANTLRStringStream charStream = new ANTLRStringStream(program);
        CtrlTree tree = this.parse(name, charStream);
        CtrlTree oldRecord = this.treeMap.put(name, tree);
        assert (oldRecord == null);
    }

    private CtrlTree parse(String name, ANTLRStringStream inputStream) throws FormatException {
        try {
            this.namespace.setFullName(name);
            CtrlTree tree = this.parser.run((CharStream)inputStream, this.namespace, this.family);
            this.parser.getErrors().throwException();
            tree = this.checker.run(tree, this.namespace, this.family);
            this.checker.getErrors().throwException();
            tree.setInputStream(inputStream);
            return tree;
        }
        catch (RecognitionException re) {
            throw new FormatException(re.getMessage(), re.line, re.charPositionInLine);
        }
    }

    public CtrlAut buildAutomaton(String name) throws FormatException {
        this.namespace.setFullName(name);
        CtrlTree tree = this.treeMap.get(name);
        try {
            CtrlAut result = this.builder.run(tree, this.namespace);
            this.builder.getErrors().throwException();
            return result == null ? null : result.clone(name);
        }
        catch (RecognitionException re) {
            throw new FormatException(re.getMessage(), re.line, re.charPositionInLine);
        }
    }

    public CtrlAut buildDefaultAutomaton() throws FormatException {
        return CtrlFactory.instance().buildDefault(this.getActions(), this.family.supportsSymbolic());
    }

    public Collection<Action> getActions() {
        return this.namespace.getActions();
    }

    public Collection<Recipe> getRecipes() {
        return this.namespace.getRecipes();
    }

    public String rename(String name, String oldCallName, String newCallName) {
        CtrlTree tree = this.treeMap.get(name);
        CtrlLexer lexer = new CtrlLexer(null);
        ANTLRStringStream charStream = tree.getInputStream();
        charStream.reset();
        lexer.setCharStream((CharStream)charStream);
        TokenRewriteStream rewriter = new TokenRewriteStream((TokenSource)lexer);
        rewriter.fill();
        for (Token t : tree.getCallTokens(oldCallName)) {
            rewriter.replace(t, (Object)newCallName);
        }
        return rewriter.toString();
    }

    public static void main(String[] args) {
        try {
            String grammarName = args[0];
            Grammar grammar = Groove.loadGrammar(grammarName).toGrammar();
            int i = 1;
            while (i < args.length) {
                String programName = controlFilter.stripExtension(args[1]);
                System.out.printf("Control automaton for %s:%n%s", programName, CtrlLoader.run(grammar, programName, new File(grammarName)));
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
    }

    public static CtrlAut run(Grammar grammar, String programName, String program) throws FormatException {
        instance.init(grammar.getProperties().getAlgebraFamily(), grammar.getAllRules());
        instance.parse(programName, program);
        return instance.buildAutomaton(programName).normalise();
    }

    public static CtrlAut run(Grammar grammar, String programName, File base) throws FormatException, IOException {
        instance.init(grammar.getProperties().getAlgebraFamily(), grammar.getAllRules());
        QualName qualName = new QualName(programName);
        File control = base;
        for (String part : qualName.tokens()) {
            control = new File(control, part);
        }
        String inputFileName = controlFilter.addExtension(control.getPath());
        instance.parse(programName, (ANTLRStringStream)new ANTLRFileStream(inputFileName));
        return instance.buildAutomaton(programName);
    }
}

