/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.control.CtrlCall;
import groove.control.CtrlGuard;
import groove.control.CtrlTransition;
import groove.grammar.Recipe;
import groove.graph.ALabel;
import groove.graph.Label;
import java.util.Map;

public class CtrlLabel
extends ALabel {
    private String text;
    private final CtrlCall call;
    private final CtrlGuard guard = new CtrlGuard();
    private final boolean start;
    private final Recipe recipe;
    private final int number;

    public CtrlLabel(CtrlCall call, CtrlGuard guard, boolean start) {
        this(0, call, guard, start);
    }

    private CtrlLabel(int number, CtrlCall call, CtrlGuard guard, boolean start) {
        assert (start || !call.isOmega());
        assert (start || call.hasRecipe());
        this.call = call;
        this.recipe = call.getRecipe();
        this.start = start;
        this.guard.addAll(guard);
        this.number = number;
    }

    @Override
    public String text() {
        if (this.text == null) {
            this.text = this.computeText();
        }
        return this.text;
    }

    private String computeText() {
        StringBuilder result = new StringBuilder();
        result.append('t');
        result.append(this.getNumber());
        result.append(':');
        if (this.hasRecipe()) {
            result.append(this.getRecipe());
            result.append('/');
        }
        if (!this.guard.isEmpty()) {
            result.append('[');
            boolean first = true;
            for (CtrlTransition guard : this.guard) {
                if (first) {
                    first = false;
                } else {
                    result.append(',');
                }
                result.append('t');
                result.append(guard.getNumber());
            }
            result.append(']');
        }
        result.append(this.getCall().toString());
        return result.toString();
    }

    public final CtrlCall getCall() {
        return this.call;
    }

    public final CtrlGuard getGuard() {
        return this.guard;
    }

    public boolean isStart() {
        return this.start;
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public boolean hasRecipe() {
        return this.getRecipe() != null;
    }

    public int getNumber() {
        return this.number;
    }

    public CtrlLabel newLabel(int number) {
        return new CtrlLabel(number, this.getCall(), this.getGuard(), this.isStart());
    }

    @Override
    public int compareTo(Label obj) {
        if (!(obj instanceof CtrlLabel)) {
            return super.compareTo(obj);
        }
        CtrlLabel other = (CtrlLabel)obj;
        return this.getNumber() - other.getNumber();
    }

    public CtrlLabel newLabel(Map<CtrlTransition, CtrlTransition> map, CtrlGuard guard) {
        CtrlGuard newGuard = this.getGuard().newGuard(map);
        if (guard != null) {
            newGuard.addAll(guard);
        }
        return new CtrlLabel(this.getNumber(), this.getCall(), newGuard, this.isStart());
    }
}

