/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.control.CtrlPar;
import groove.control.CtrlVar;
import groove.grammar.Action;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import groove.util.Groove;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CtrlCall {
    private Map<CtrlVar, Integer> inVars;
    private Map<CtrlVar, Integer> outVars;
    private final Kind kind;
    private final List<CtrlPar> args;
    private final Rule rule;
    private final Recipe recipe;
    private final String name;
    public static final String OMEGA_NAME = "\u03a9";
    public static final CtrlCall OMEGA = new CtrlCall();

    private CtrlCall() {
        this.kind = Kind.OMEGA;
        this.name = OMEGA_NAME;
        this.rule = null;
        this.args = null;
        this.recipe = null;
    }

    public CtrlCall(Kind kind, String name, List<CtrlPar> args) {
        assert (kind == Kind.RECIPE || kind == Kind.FUNCTION);
        this.kind = kind;
        this.name = name;
        this.rule = null;
        this.recipe = null;
        this.args = args;
    }

    public CtrlCall(Rule rule, List<CtrlPar> args) {
        this(rule, args, null);
    }

    private CtrlCall(Rule rule, List<CtrlPar> args, Recipe recipe) {
        this.kind = Kind.RULE;
        this.name = rule.getFullName();
        this.args = args;
        this.rule = rule;
        this.recipe = recipe;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CtrlCall)) {
            return false;
        }
        CtrlCall other = (CtrlCall)obj;
        if (this.getKind() != other.getKind()) {
            return false;
        }
        if (this.isOmega()) {
            return other.isOmega();
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getArgs() == null ? other.getArgs() != null : !this.getArgs().equals(other.getArgs())) {
            return false;
        }
        if (this.getRecipe() == null) {
            return other.getRecipe() == null;
        }
        return this.getRecipe().equals(other.getRecipe());
    }

    public int hashCode() {
        int prime = 31;
        int result = this.getKind().hashCode();
        result = prime * result + (this.isOmega() ? 1231 : 1237);
        if (this.getName() != null) {
            result = prime * result + this.getName().hashCode();
        }
        if (this.getRecipe() != null) {
            result = prime * result + this.getRecipe().hashCode();
        }
        if (this.getArgs() != null) {
            result = prime * result + this.getArgs().hashCode();
        }
        return result;
    }

    public String toString() {
        String result = this.getName();
        if (this.getArgs() != null) {
            result = String.valueOf(result) + Groove.toString(this.getArgs().toArray(), "(", ")", ",");
        }
        return result;
    }

    public boolean isOmega() {
        return this.getKind() == Kind.OMEGA;
    }

    public CtrlCall copy(List<CtrlPar> args) {
        CtrlCall result;
        assert (args == null || args.size() == this.getArgs().size());
        switch (this.getKind()) {
            case OMEGA: {
                result = this;
                break;
            }
            case RULE: {
                result = new CtrlCall(this.getRule(), args);
                break;
            }
            default: {
                result = new CtrlCall(this.getKind(), this.getName(), args);
            }
        }
        return result;
    }

    public boolean modifies(CtrlCall other) {
        boolean result = false;
        if (this.getArgs() != null && !this.getArgs().isEmpty() && other.getArgs() != null && !other.getArgs().isEmpty()) {
            Map<CtrlVar, Integer> otherInVars = other.getInVars();
            for (CtrlVar outVar : this.getOutVars().keySet()) {
                if (!otherInVars.containsKey(outVar)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Map<CtrlVar, Integer> getOutVars() {
        if (this.outVars == null) {
            this.initVars();
        }
        return this.outVars;
    }

    public Map<CtrlVar, Integer> getInVars() {
        if (this.inVars == null) {
            this.initVars();
        }
        return this.inVars;
    }

    private void initVars() {
        HashMap<CtrlVar, Integer> outVars = new HashMap<CtrlVar, Integer>();
        HashMap<CtrlVar, Integer> inVars = new HashMap<CtrlVar, Integer>();
        if (this.getArgs() != null && !this.getArgs().isEmpty()) {
            int size = this.getArgs().size();
            int i = 0;
            while (i < size) {
                CtrlPar arg = this.getArgs().get(i);
                if (arg instanceof CtrlPar.Var) {
                    CtrlVar var = ((CtrlPar.Var)arg).getVar();
                    if (arg.isInOnly()) {
                        inVars.put(var, i);
                    } else {
                        assert (arg.isOutOnly());
                        outVars.put(var, i);
                    }
                }
                ++i;
            }
        }
        this.outVars = outVars;
        this.inVars = inVars;
    }

    public CtrlCall embed(Recipe recipe) {
        if (this.isOmega()) {
            assert (recipe == null);
            return this;
        }
        assert (this.getRule() != null);
        return new CtrlCall(this.getRule(), this.getArgs(), recipe);
    }

    public Kind getKind() {
        return this.kind;
    }

    public final List<CtrlPar> getArgs() {
        return this.args;
    }

    public final Rule getRule() {
        return this.rule;
    }

    public final Recipe getRecipe() {
        return this.recipe;
    }

    public final boolean hasRecipe() {
        return this.getRecipe() != null;
    }

    public final String getName() {
        return this.name;
    }

    public static Kind getKind(Action action) {
        switch (action.getKind()) {
            case RULE: {
                return Kind.RULE;
            }
            case RECIPE: {
                return Kind.RECIPE;
            }
        }
        assert (false);
        return null;
    }

    public static enum Kind {
        RULE("rule"),
        RECIPE("recipe"),
        FUNCTION("function"),
        OMEGA("omega");

        private final String name;

        private Kind(String name) {
            this.name = name;
        }

        public boolean hasBody() {
            return this != RULE;
        }

        public String getName(boolean upper) {
            StringBuilder result = new StringBuilder(this.name);
            if (upper) {
                result.replace(0, 1, "" + Character.toUpperCase(this.name.charAt(0)));
            }
            return result.toString();
        }
    }
}

