/*
 * Decompiled with CFR 0.152.
 */
package groove.automaton;

import groove.automaton.Direction;
import groove.automaton.RegNode;
import groove.grammar.type.TypeLabel;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DFAState {
    private final int number;
    private final boolean initial;
    private final boolean isFinal;
    private final Set<RegNode> nodes;
    private final Map<Direction, Map<TypeLabel, DFAState>> labelSuccMap = new EnumMap<Direction, Map<TypeLabel, DFAState>>(Direction.class);

    DFAState(int number, Set<RegNode> nodes, boolean initial, boolean isFinal) {
        this.number = number;
        this.nodes = new HashSet<RegNode>(nodes);
        this.initial = initial;
        this.isFinal = isFinal;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction dir = directionArray[n2];
            this.labelSuccMap.put(dir, new HashMap());
            ++n2;
        }
    }

    public boolean isInitial() {
        return this.initial;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public Set<RegNode> getNodes() {
        return this.nodes;
    }

    public void addSuccessor(Direction dir, TypeLabel label, DFAState succ) {
        DFAState oldSucc = this.labelSuccMap.get((Object)dir).put(label, succ);
        assert (oldSucc == null) : "Overrides existing transition to " + oldSucc;
    }

    public int getNumber() {
        return this.number;
    }

    public Map<Direction, Map<TypeLabel, DFAState>> getLabelMap() {
        return this.labelSuccMap;
    }

    public String toString() {
        return "a" + this.getNumber();
    }
}

