/*
 * Decompiled with CFR 0.152.
 */
package groove.algebra;

import groove.algebra.Algebras;
import groove.algebra.Precedence;
import groove.algebra.SignatureKind;
import groove.annotation.InfixSymbol;
import groove.annotation.PrefixSymbol;
import groove.util.Groove;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;

public class Operator {
    private final SignatureKind signature;
    private final int arity;
    private final List<SignatureKind> parameterTypes;
    private final SignatureKind returnType;
    private final String name;
    private final String symbol;
    private final Precedence precedence;

    Operator(Method method) throws IllegalArgumentException {
        String typeName;
        Type[] methodParameterTypes = method.getGenericParameterTypes();
        this.signature = Algebras.getSigKind(method.getDeclaringClass());
        this.arity = methodParameterTypes.length;
        this.name = method.getName();
        this.parameterTypes = new ArrayList<SignatureKind>();
        int i = 0;
        while (i < this.arity) {
            if (!(methodParameterTypes[i] instanceof TypeVariable)) {
                throw new IllegalArgumentException(String.format("Method '%s' should only have generic parameter types", method.getName()));
            }
            typeName = ((TypeVariable)methodParameterTypes[i]).getName();
            this.parameterTypes.add(SignatureKind.getKind(typeName.toLowerCase()));
            ++i;
        }
        Type returnType = method.getGenericReturnType();
        if (!(returnType instanceof TypeVariable)) {
            throw new IllegalArgumentException(String.format("Method '%s' should have generic return type", method.getName()));
        }
        typeName = ((TypeVariable)returnType).getName();
        this.returnType = SignatureKind.getKind(typeName.toLowerCase());
        InfixSymbol infix = method.getAnnotation(InfixSymbol.class);
        PrefixSymbol prefix = method.getAnnotation(PrefixSymbol.class);
        Object object = infix == null ? (prefix == null ? null : prefix.symbol()) : (this.symbol = infix.symbol());
        this.precedence = infix == null ? (prefix == null ? null : Precedence.UNARY) : infix.precedence();
    }

    public SignatureKind getSignature() {
        return this.signature;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public List<SignatureKind> getParamTypes() {
        return this.parameterTypes;
    }

    public SignatureKind getResultType() {
        return this.returnType;
    }

    public String getTypedName() {
        return (Object)((Object)this.signature) + ":" + this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Precedence getPrecedence() {
        return this.precedence;
    }

    public String toString() {
        return String.valueOf(this.getTypedName()) + Groove.toString(this.parameterTypes.toArray(), "(", ")", ",");
    }
}

