/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.MyHashMap;
import groove.abstraction.pattern.shape.TypeNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostNode;
import groove.util.Fixable;
import java.util.Map;

public class SimpleMorphism
implements Fixable {
    private final String name;
    private final TypeNode source;
    private final TypeNode target;
    private final Map<HostNode, HostNode> nodeMap;
    private final Map<HostEdge, HostEdge> edgeMap;
    private final Map<HostNode, HostNode> inverseNodeMap;
    private final Map<HostEdge, HostEdge> inverseEdgeMap;
    private boolean fixed;

    public SimpleMorphism(String name, TypeNode source, TypeNode target) {
        this.name = name;
        this.source = source;
        this.target = target;
        this.nodeMap = new MyHashMap<HostNode, HostNode>();
        this.edgeMap = new MyHashMap<HostEdge, HostEdge>();
        this.inverseNodeMap = new MyHashMap<HostNode, HostNode>();
        this.inverseEdgeMap = new MyHashMap<HostEdge, HostEdge>();
        this.fixed = false;
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.fixed = true;
        }
        return result;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public void testFixed(boolean fixed) {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        return String.valueOf(this.getName()) + ": " + this.nodeMap + ", " + this.edgeMap;
    }

    public String getName() {
        return this.name;
    }

    public TypeNode getSource() {
        return this.source;
    }

    public TypeNode getTarget() {
        return this.target;
    }

    public void putNode(HostNode source, HostNode target) {
        assert (!this.isFixed());
        this.nodeMap.put(source, target);
        this.inverseNodeMap.put(target, source);
    }

    public void putEdge(HostEdge edge1, HostEdge edge2) {
        assert (!this.isFixed());
        HostNode src1 = this.getImage(edge1.source());
        HostNode tgt1 = this.getImage(edge1.target());
        HostNode src2 = edge2.source();
        HostNode tgt2 = edge2.target();
        assert (src1.equals(src2) && tgt1.equals(tgt2));
        assert (edge1.label().equals(edge2.label()));
        this.edgeMap.put(edge1, edge2);
        this.inverseEdgeMap.put(edge2, edge1);
    }

    public HostNode getImage(HostNode source) {
        HostNode target = this.nodeMap.get(source);
        assert (target != null);
        return target;
    }

    public HostEdge getImage(HostEdge source) {
        HostEdge target = this.edgeMap.get(source);
        assert (target != null);
        return target;
    }

    public HostNode getPreImage(HostNode target) {
        return this.inverseNodeMap.get(target);
    }

    public HostEdge getPreImage(HostEdge target) {
        return this.inverseEdgeMap.get(target);
    }

    public boolean isDom(HostNode node) {
        return this.nodeMap.keySet().contains(node);
    }

    public boolean isDom(HostEdge edge) {
        return this.edgeMap.keySet().contains(edge);
    }

    public boolean isCod(HostNode node) {
        return this.nodeMap.values().contains(node);
    }

    public boolean isCod(HostEdge edge) {
        return this.edgeMap.values().contains(edge);
    }
}

