/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.pattern.Util;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.type.TypeLabel;
import groove.graph.ANode;
import groove.util.Fixable;
import java.util.Comparator;
import java.util.Set;

public abstract class AbstractPatternNode
extends ANode
implements Fixable {
    public static final PatternNodeComparator comparator = new PatternNodeComparator();

    public AbstractPatternNode(int nr) {
        super(nr);
    }

    @Override
    public abstract boolean setFixed();

    @Override
    public abstract boolean isFixed();

    @Override
    public void testFixed(boolean fixed) {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException();
        }
    }

    public abstract HostGraph getPattern();

    public abstract int getLayer();

    public abstract boolean isNodePattern();

    public abstract boolean isEdgePattern();

    public String getIdStr() {
        return super.toString();
    }

    public HostNode getSimpleNode() {
        assert (this.isNodePattern());
        return (HostNode)this.getPattern().nodeSet().iterator().next();
    }

    public Set<TypeLabel> getNodeLabels() {
        assert (this.isNodePattern());
        return Util.getNodeLabels(this.getPattern(), this.getSimpleNode());
    }

    public HostEdge getSimpleEdge() {
        assert (this.isEdgePattern());
        return Util.getBinaryEdges(this.getPattern()).iterator().next();
    }

    public HostNode getSource() {
        assert (this.isEdgePattern());
        return this.getSimpleEdge().source();
    }

    public HostNode getTarget() {
        assert (this.isEdgePattern());
        return this.getSimpleEdge().target();
    }

    public String getAdornment() {
        return super.toString();
    }

    public boolean introduces(HostEdge sEdge) {
        return this.getSimpleEdge().equals(sEdge);
    }

    private static final class PatternNodeComparator
    implements Comparator<AbstractPatternNode> {
        private PatternNodeComparator() {
        }

        @Override
        public int compare(AbstractPatternNode o1, AbstractPatternNode o2) {
            if (o1.getLayer() < o2.getLayer()) {
                return -1;
            }
            if (o1.getLayer() > o2.getLayer()) {
                return 1;
            }
            return o1.getNumber() - o2.getNumber();
        }
    }
}

