/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.match;

import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.lts.MatchResult;
import groove.abstraction.pattern.match.Match;
import groove.abstraction.pattern.match.PatternSearchPlan;
import groove.abstraction.pattern.match.PreMatch;
import groove.abstraction.pattern.match.SearchItem;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.PatternShape;
import groove.abstraction.pattern.trans.PatternRule;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleNode;
import groove.control.CtrlTransition;
import groove.graph.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Matcher {
    private final boolean injective;
    private final PatternSearchPlan plan;
    private final Search search;
    private final Map<RuleNode, Integer> nodeIxMap;
    private final Map<RuleEdge, Integer> edgeIxMap;
    private RuleNode[] nodeKeys;
    private RuleEdge[] edgeKeys;

    public Matcher(PatternRule pRule, boolean injective) {
        this.injective = injective;
        this.plan = new PatternSearchPlan(pRule, injective);
        this.nodeIxMap = new HashMap<RuleNode, Integer>();
        this.edgeIxMap = new HashMap<RuleEdge, Integer>();
        for (SearchItem searchItem : this.plan) {
            searchItem.activate(this);
        }
        this.nodeKeys = new RuleNode[this.nodeIxMap.size()];
        for (Map.Entry entry : this.nodeIxMap.entrySet()) {
            this.nodeKeys[((Integer)entry.getValue()).intValue()] = (RuleNode)entry.getKey();
        }
        this.edgeKeys = new RuleEdge[this.edgeIxMap.size()];
        for (Map.Entry entry : this.edgeIxMap.entrySet()) {
            this.edgeKeys[((Integer)entry.getValue()).intValue()] = (RuleEdge)entry.getKey();
        }
        this.search = new Search();
    }

    private final boolean isInjective() {
        return this.injective;
    }

    public List<MatchResult> findMatches(PatternGraph pGraph, CtrlTransition ctrlTrans) {
        ArrayList<MatchResult> result = new ArrayList<MatchResult>();
        this.search.initialise(pGraph);
        while (this.search.find()) {
            Match match = this.search.getMatch();
            if (match == null) continue;
            result.add(new MatchResult(match, ctrlTrans));
        }
        return result;
    }

    boolean isNodeFound(RuleNode node) {
        return this.nodeIxMap.get(node) != null;
    }

    boolean isEdgeFound(RuleEdge edge) {
        return this.edgeIxMap.get(edge) != null;
    }

    int getNodeIx(RuleNode node) {
        Integer result = this.nodeIxMap.get(node);
        if (result == null) {
            result = this.nodeIxMap.size();
            this.nodeIxMap.put(node, result);
        }
        return result;
    }

    int getEdgeIx(RuleEdge edge) {
        Integer value = this.edgeIxMap.get(edge);
        if (value == null) {
            value = this.edgeIxMap.size();
            this.edgeIxMap.put(edge, value);
        }
        return value;
    }

    public final class Search {
        private final PatternNode[] nodeImages;
        private final PatternEdge[] edgeImages;
        private final SearchItem.Record[] records;
        private final SearchItem.Record[][] influence;
        private final int[] influenceCount;
        private Set<PatternNode> usedNodes;
        private PatternGraph host;
        private boolean found;
        private int lastSingular;

        Search() {
            int planSize = Matcher.this.plan.size();
            this.records = new SearchItem.Record[planSize];
            this.nodeImages = new PatternNode[Matcher.this.nodeKeys.length];
            this.edgeImages = new PatternEdge[Matcher.this.edgeKeys.length];
            this.influence = new SearchItem.Record[planSize][];
            this.influenceCount = new int[planSize];
        }

        private Set<PatternNode> getUsedNodes() {
            if (this.usedNodes == null) {
                this.usedNodes = new MyHashSet<PatternNode>();
            }
            return this.usedNodes;
        }

        void initialise(PatternGraph host) {
            this.host = host;
            if (Matcher.this.isInjective()) {
                this.getUsedNodes().clear();
            }
            int i = 0;
            while (i < this.nodeImages.length) {
                this.nodeImages[i] = null;
                ++i;
            }
            i = 0;
            while (i < this.edgeImages.length) {
                this.edgeImages[i] = null;
                ++i;
            }
            i = 0;
            while (i < this.records.length && this.records[i] != null) {
                this.records[i].initialise(host);
                ++i;
            }
            this.found = false;
            this.lastSingular = -1;
        }

        boolean find() {
            int current;
            int planSize = Matcher.this.plan.size();
            if (this.found) {
                SearchItem.Record currentRecord;
                current = planSize - 1;
                while (current >= 0 && !(currentRecord = this.getRecord(current)).isRelevant()) {
                    currentRecord.repeat();
                    --current;
                }
            } else {
                current = 0;
            }
            while (current > this.lastSingular && current < planSize) {
                boolean success = this.getRecord(current).next();
                if (success) {
                    int i = 0;
                    while (i < this.influenceCount[current]) {
                        this.influence[current][i].reset();
                        ++i;
                    }
                    ++current;
                    continue;
                }
                if (this.getRecord(current).isEmpty()) {
                    int dependency = Matcher.this.plan.getDependency(current);
                    --current;
                    while (current > dependency) {
                        this.getRecord(current).repeat();
                        --current;
                    }
                    continue;
                }
                --current;
            }
            this.found = current == planSize;
            return this.found;
        }

        private SearchItem.Record getRecord(int current) {
            SearchItem.Record result = this.records[current];
            if (result == null) {
                SearchItem item = (SearchItem)Matcher.this.plan.get(current);
                result = item.createRecord(this);
                result.initialise(this.host);
                this.records[current] = result;
                this.influence[current] = new SearchItem.Record[this.influence.length - current];
                int dependency = Matcher.this.plan.getDependency(current);
                assert (dependency < current);
                if (dependency >= 0) {
                    this.influence[dependency][this.influenceCount[dependency]] = result;
                    int n = dependency;
                    this.influenceCount[n] = this.influenceCount[n] + 1;
                }
                if (this.lastSingular == current - 1 && result.isSingular()) {
                    ++this.lastSingular;
                }
            }
            return result;
        }

        Match getMatch() {
            Match result = null;
            if (this.found) {
                Element image;
                result = this.createEmptyMatch();
                int i = 0;
                while (i < this.nodeImages.length) {
                    image = this.nodeImages[i];
                    if (image != null) {
                        result.putNode(Matcher.this.nodeKeys[i], image);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.edgeImages.length) {
                    image = this.edgeImages[i];
                    if (image != null) {
                        result.putEdge(Matcher.this.edgeKeys[i], image);
                    }
                    ++i;
                }
                assert (result.isFinished());
                result.setFixed();
                if (!result.isValid()) {
                    result = null;
                }
            }
            return result;
        }

        Match createEmptyMatch() {
            if (this.host instanceof PatternShape) {
                return new PreMatch(Matcher.this.plan.getRule(), (PatternShape)this.host);
            }
            return new Match(Matcher.this.plan.getRule(), this.host);
        }

        boolean putNode(int index, PatternNode image) {
            if (Matcher.this.isInjective()) {
                PatternNode oldImage = this.nodeImages[index];
                if (oldImage != null) {
                    boolean removed = this.getUsedNodes().remove(oldImage);
                    assert (removed) : String.format("Node image %s not in used nodes %s", oldImage, this.usedNodes);
                }
                if (image != null && !this.getUsedNodes().add(image)) {
                    this.nodeImages[index] = null;
                    return false;
                }
            }
            this.nodeImages[index] = image;
            return true;
        }

        boolean putEdge(int index, PatternEdge image) {
            this.edgeImages[index] = image;
            return true;
        }

        PatternNode getNode(int index) {
            return this.nodeImages[index];
        }

        PatternEdge getEdge(int index) {
            return this.edgeImages[index];
        }
    }
}

