/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.match;

import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.trans.PatternRule;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleNode;
import groove.graph.AElementBiMap;

public class Match
extends AElementBiMap<RuleNode, RuleEdge, PatternNode, PatternEdge> {
    private final PatternRule pRule;
    private final PatternGraph pGraph;

    public Match(PatternRule pRule, PatternGraph pGraph) {
        super(pGraph.getFactory());
        this.pRule = pRule;
        this.pGraph = pGraph;
    }

    private Match(Match match) {
        super(match.getFactory());
        this.pRule = match.pRule;
        this.pGraph = match.pGraph;
        this.putAll(match);
    }

    public PatternRule getRule() {
        return this.pRule;
    }

    public PatternGraph getGraph() {
        return this.pGraph;
    }

    public boolean isFinished() {
        return this.nodeMap().keySet().containsAll(this.pRule.lhs().nodeSet()) && this.edgeMap().keySet().containsAll(this.pRule.lhs().edgeSet());
    }

    public boolean isValid() {
        return this.isInjective();
    }

    @Override
    public String toString() {
        return "Match of " + this.pRule.getName() + ":\n" + super.toString();
    }

    public Match clone() {
        return new Match(this);
    }
}

