/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.trans;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.trans.BoundType;
import groove.abstraction.neigh.trans.Equation;
import groove.abstraction.neigh.trans.Value;
import groove.abstraction.neigh.trans.Var;
import groove.util.Duo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class Solution {
    private final List<Duo<Var>> vars;
    final Value[] values;
    private final MyHashSet<Equation> lbEqs;
    final MyHashSet<Equation> ubEqs;
    private MyHashSet<ShapeNode> garbageNodes;
    boolean invalid;

    Solution(List<Duo<Var>> vars, int bound, MyHashSet<Equation> lbEqs, MyHashSet<Equation> ubEqs) {
        this.vars = vars;
        int varsCount = vars.size();
        this.values = new Value[varsCount];
        int i = 0;
        while (i < varsCount) {
            this.values[i] = new Value(bound);
            ++i;
        }
        this.lbEqs = lbEqs.clone();
        this.ubEqs = ubEqs.clone();
    }

    Solution(Solution original) {
        int varsCount = original.size();
        this.vars = original.vars;
        this.values = new Value[varsCount];
        int i = 0;
        while (i < varsCount) {
            this.values[i] = original.values[i].clone();
            ++i;
        }
        this.lbEqs = original.lbEqs.clone();
        this.ubEqs = original.ubEqs.clone();
        if (original.garbageNodes != null) {
            this.garbageNodes = original.garbageNodes.clone();
        }
    }

    MyHashSet<Equation> getEqs(BoundType type) {
        MyHashSet<Equation> result = null;
        switch (type) {
            case LB: {
                result = this.lbEqs;
                break;
            }
            case UB: {
                result = this.ubEqs;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < this.size()) {
            sb.append(String.valueOf(this.values[i].toString()) + ", ");
            ++i;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    public Solution clone() {
        return new Solution(this);
    }

    int size() {
        return this.values.length;
    }

    Value getValue(Var var) {
        return this.values[var.number];
    }

    boolean isSingleton(Var var) {
        return this.getValue(var).isSingleton();
    }

    int getBoundValue(Var var) {
        int result = 0;
        switch (var.type) {
            case UB: {
                result = this.getValue((Var)var).j;
                break;
            }
            case LB: {
                result = this.getValue((Var)var).i;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    public int getSum(List<Var> vars, boolean singletons) {
        int result = 0;
        for (Var var : vars) {
            if (singletons && !this.isSingleton(var)) continue;
            result = Multiplicity.add(result, this.getBoundValue(var));
        }
        return result;
    }

    int getMaxValue(Var var) {
        return this.getValue((Var)var).j;
    }

    void cutLow(Var var, int limit) {
        this.getValue(var).cutLow(limit);
    }

    void cutHigh(Var var, int limit) {
        this.getValue(var).cutHigh(limit);
    }

    void cut(Var var, int limit) {
        switch (var.type) {
            case UB: {
                this.cutHigh(var, limit);
                break;
            }
            case LB: {
                this.cutLow(var, limit);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void setToZero(Var var) {
        if (this.isSingleton(var) && this.getBoundValue(var) != 0) {
            this.invalid = true;
        } else {
            this.getValue(var).setToZero();
        }
    }

    boolean isFinished() {
        boolean result;
        boolean bl = result = this.lbEqs.isEmpty() && this.ubEqs.isEmpty() || this.invalid;
        if (!result) {
            result = this.allEqsHaveNodes(this.ubEqs) && this.allEqsHaveNodes(this.lbEqs);
        }
        return result;
    }

    boolean allEqsHaveNodes(Set<Equation> eqs) {
        boolean result = !eqs.isEmpty();
        for (Equation eq : eqs) {
            if (eq.hasNode()) continue;
            result = false;
            break;
        }
        return result;
    }

    Equation getBestBranchingEquation() {
        Equation result = null;
        for (Equation eq : this.ubEqs) {
            if (!this.isNewEqBetter(result, eq)) continue;
            result = eq;
        }
        if (result == null) {
            for (Equation eq : this.lbEqs) {
                if (!this.isNewEqBetter(result, eq)) continue;
                result = eq;
            }
        }
        assert (!result.hasNode());
        return result;
    }

    private boolean isNewEqBetter(Equation oldEq, Equation newEq) {
        int oldOpenVarsCount;
        if (newEq.hasNode()) {
            return false;
        }
        if (oldEq == null) {
            return true;
        }
        int newOpenVarsCount = newEq.getOpenVars(this).size();
        if (newOpenVarsCount < (oldOpenVarsCount = oldEq.getOpenVars(this).size())) {
            return true;
        }
        if (newOpenVarsCount > oldOpenVarsCount) {
            return false;
        }
        if (oldEq.getType() == BoundType.UB) {
            return newEq.getConstant() < oldEq.getConstant();
        }
        return newEq.getConstant() > oldEq.getConstant();
    }

    Multiplicity getMultValue(int varNum, Multiplicity.MultKind kind) {
        int i = this.values[varNum].i;
        int j = this.values[varNum].j;
        return Multiplicity.approx(i, j, kind);
    }

    boolean subsumes(Solution other) {
        boolean result = true;
        int varNum = 0;
        while (varNum < this.size()) {
            if (this.values[varNum].i > other.values[varNum].i || this.values[varNum].j < other.values[varNum].j) {
                result = false;
                break;
            }
            ++varNum;
        }
        return result;
    }

    void projectToZeroWhenNeeded(Var var) {
        Value range = this.getValue(var);
        if (range.isZeroOne()) {
            range.cutHigh(0);
        }
    }

    boolean hasZeroOneVars() {
        boolean result = false;
        int varNum = 0;
        while (varNum < this.size()) {
            if (this.values[varNum].isZeroOne()) {
                result = true;
                break;
            }
            ++varNum;
        }
        return result;
    }

    List<Var> getZeroOneVars() {
        ArrayList<Var> result = new ArrayList<Var>(this.vars.size());
        int v = 0;
        while (v < this.values.length) {
            Value value = this.values[v];
            if (value.isZeroOne()) {
                result.add((Var)this.vars.get(v).two());
            }
            ++v;
        }
        return result;
    }

    void setAllVarsToMax() {
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            value.i = Math.min(value.j, value.bound);
            ++n2;
        }
    }

    void addGarbageNode(ShapeNode node) {
        if (this.garbageNodes == null) {
            this.garbageNodes = new MyHashSet();
        }
        this.garbageNodes.add(node);
    }

    public Set<ShapeNode> getGarbageNodes() {
        return this.garbageNodes;
    }

    boolean isGarbage(ShapeNode node) {
        if (this.garbageNodes == null) {
            return false;
        }
        return this.garbageNodes.contains(node);
    }
}

