/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.trans;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.NeighAbsParam;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeMorphism;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.trans.BoundType;
import groove.abstraction.neigh.trans.EdgeBundle;
import groove.abstraction.neigh.trans.Equation;
import groove.abstraction.neigh.trans.EquationSystem;
import groove.abstraction.neigh.trans.Materialisation;
import groove.abstraction.neigh.trans.Solution;
import groove.abstraction.neigh.trans.Var;
import groove.util.Duo;
import groove.util.Visitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Materialiser {
    private static final boolean WARN_BLOWUP = false;
    private static final int MAX_SOLUTION_COUNT = 4;
    private final Materialisation mat;
    private final int stage;
    private final EquationSystem eqSys;
    private Map<ShapeEdge, Duo<Var>> edgeVarsMap;
    private ArrayList<ShapeEdge> varEdgeMap;
    private Map<EdgeSignature, Duo<Var>> outEsVarsMap;
    private Map<EdgeSignature, Duo<Var>> inEsVarsMap;
    private ArrayList<EdgeSignature> varEsMap;
    private Map<ShapeNode, Duo<Var>> nodeVarsMap;
    private ArrayList<ShapeNode> varNodeMap;

    public static final Materialiser newInstance(Materialisation mat) {
        assert (mat.getStage() == 1);
        return new Materialiser(mat);
    }

    private Materialiser(Materialisation mat) {
        assert (mat != null);
        this.mat = mat;
        this.stage = mat.getStage();
        this.eqSys = new EquationSystem(this.stage);
        this.create();
    }

    public void solve(Set<Materialisation> result) {
        Set<Solution> finishedSols = this.computeSolutions();
        for (Solution sol : finishedSols) {
            Materialisation mat = finishedSols.size() == 1 ? this.mat : this.mat.clone();
            boolean requiresNextStage = this.updateMat(mat, sol);
            if (requiresNextStage) {
                assert (this.stage < 3);
                new Materialiser(mat).solve(result);
                continue;
            }
            result.add(mat);
        }
    }

    public void visitSolutions(Visitor<Materialisation, ?> visitor) {
        Set<Solution> finishedSols = this.computeSolutions();
        for (Solution sol : finishedSols) {
            Materialisation mat = finishedSols.size() == 1 ? this.mat : this.mat.clone();
            boolean requiresNextStage = this.updateMat(mat, sol);
            if (requiresNextStage) {
                assert (this.stage < 3);
                new Materialiser(mat).visitSolutions(visitor);
                continue;
            }
            if (!mat.postProcess()) continue;
            visitor.visit(mat);
        }
    }

    private Set<Solution> computeSolutions() {
        EquationSystem.SolutionSet result = this.eqSys.computeSolutions();
        int finishedSolsSize = result.size();
        assert (this.stage != 2 || finishedSolsSize == 1);
        return result;
    }

    private void create() {
        switch (this.stage) {
            case 1: {
                this.createFirstStage();
                break;
            }
            case 2: {
                this.createSecondStage();
                break;
            }
            case 3: {
                this.createThirdStage();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void createFirstStage() {
        assert (this.stage == 1);
        this.edgeVarsMap = new MyHashMap<ShapeEdge, Duo<Var>>();
        this.varEdgeMap = new ArrayList();
        boolean mayHaveGarbageNodes = NeighAbsParam.getInstance().getNodeMultBound() < NeighAbsParam.getInstance().getEdgeMultBound();
        Shape shape = this.mat.getShape();
        for (EdgeBundle bundle : this.mat.getBundles()) {
            int varsCount = bundle.getEdgesCount();
            Multiplicity nodeMult = shape.getNodeMult(bundle.node);
            Multiplicity edgeMult = bundle.origEsMult;
            Multiplicity constMult = nodeMult.times(edgeMult);
            ArrayList<Duo<Var>> varList = new ArrayList<Duo<Var>>(varsCount);
            for (EdgeSignature splitEs : bundle.getSplitEsSet()) {
                for (ShapeEdge edge : bundle.getSplitEsEdges(splitEs)) {
                    Duo<Var> vars = this.retrieveBoundVars(edge);
                    varList.add(vars);
                    Duo<Equation> trivialEqs = null;
                    if (this.mat.isFixed(edge)) {
                        trivialEqs = this.createEquations(vars, 1, 1);
                    } else if (shape.areNodesConcrete(edge)) {
                        trivialEqs = this.createEquations(vars, 0, 1);
                    }
                    if (trivialEqs == null) continue;
                    this.eqSys.addEquations(trivialEqs);
                }
            }
            Duo<Equation> eqs = mayHaveGarbageNodes && nodeMult.isZeroPlus() ? this.createEquations(varList, constMult.getLowerBound(), constMult.getUpperBound(), bundle.node) : this.createEquations(varList, constMult.getLowerBound(), constMult.getUpperBound());
            this.eqSys.addEquations(eqs);
        }
    }

    private void createSecondStage() {
        assert (this.stage == 2);
        this.outEsVarsMap = new MyHashMap<EdgeSignature, Duo<Var>>();
        this.inEsVarsMap = new MyHashMap<EdgeSignature, Duo<Var>>();
        this.varEsMap = new ArrayList();
        Shape shape = this.mat.getShape();
        for (ShapeNode affectedNode : this.mat.getAffectedNodes()) {
            for (EdgeBundle bundle : this.mat.getBundles(affectedNode)) {
                int esCount = bundle.getSplitEsSet().size();
                ArrayList<Duo<Var>> varList = new ArrayList<Duo<Var>>(esCount);
                for (EdgeSignature es : bundle.getSplitEsSet()) {
                    ShapeEdge edge;
                    Duo<Var> vars = this.retrieveBoundVars(es);
                    varList.add(vars);
                    Set<ShapeEdge> edges = bundle.getSplitEsEdges(es);
                    if (edges.size() != 1 || !this.mat.isFixed(edge = edges.iterator().next()) && !bundle.isFixed(edge, bundle.direction, shape)) continue;
                    Duo<Equation> trivialEqs = this.createEquations(vars, 1, 1);
                    this.eqSys.addEquations(trivialEqs);
                }
                Duo<Equation> eqs = this.createEquations(varList, bundle.origEsMult.getLowerBound(), bundle.origEsMult.getUpperBound());
                this.eqSys.addEquations(eqs);
            }
        }
    }

    private void createThirdStage() {
        assert (this.stage == 3);
        this.nodeVarsMap = new MyHashMap<ShapeNode, Duo<Var>>();
        this.varNodeMap = new ArrayList();
        Shape shape = this.mat.getShape();
        Map<ShapeNode, Set<ShapeNode>> nodeSplitMap = this.mat.getNodeSplitMap();
        for (ShapeNode origNode : nodeSplitMap.keySet()) {
            Multiplicity origMult = this.mat.getOrigNodeMult(origNode);
            Set<ShapeNode> splitNodes = nodeSplitMap.get(origNode);
            int varsCount = splitNodes.size() + 1;
            ArrayList<Duo<Var>> varList = new ArrayList<Duo<Var>>(varsCount);
            if (shape.containsNode(origNode)) {
                Duo<Var> vars = this.retrieveBoundVars(origNode);
                varList.add(vars);
            }
            for (ShapeNode splitNode : splitNodes) {
                if (!shape.containsNode(splitNode)) continue;
                Duo<Var> vars = this.retrieveBoundVars(splitNode);
                varList.add(vars);
            }
            Duo<Equation> eqs = this.createEquations(varList, origMult.getLowerBound(), origMult.getUpperBound());
            this.eqSys.addEquations(eqs);
        }
        for (ShapeNode node : shape.nodeSet()) {
            if (!shape.getNodeMult(node).isOne()) continue;
            for (EdgeBundle bundle : this.mat.getBundles(node)) {
                bundle.update(this.mat);
                EdgeMultDir direction = bundle.direction;
                for (EdgeSignature splitEs : bundle.getSplitEsSet()) {
                    Set<ShapeEdge> sigEdges = bundle.getSplitEsEdges(splitEs);
                    if (!bundle.possibleEdges.containsAll(sigEdges)) continue;
                    Multiplicity esMult = shape.getEdgeSigMult(splitEs);
                    Multiplicity constMult = esMult.toNodeKind();
                    ArrayList<Duo<Var>> varList = new ArrayList<Duo<Var>>(sigEdges.size());
                    for (ShapeEdge edge : sigEdges) {
                        EdgeSignature oppEs = shape.getEdgeSignature(edge, direction.reverse());
                        if (!shape.isEdgeSigConcrete(oppEs)) break;
                        ShapeNode opposite = direction.opposite(edge);
                        Duo<Var> vars = this.nodeVarsMap.get(opposite);
                        if (vars == null) {
                            Multiplicity oppMult = shape.getNodeMult(opposite);
                            int lb = oppMult.getLowerBound();
                            constMult = constMult.sub(lb);
                            continue;
                        }
                        varList.add(vars);
                        if (esMult.getUpperBound() != sigEdges.size()) continue;
                        Duo<Equation> trivialEqs = this.createEquations(Collections.singletonList(vars), 1, 1);
                        this.eqSys.addEquations(trivialEqs);
                    }
                    Duo<Equation> eqs = this.createEquations(varList, constMult.getLowerBound(), constMult.getUpperBound());
                    this.eqSys.addEquations(eqs);
                }
            }
        }
    }

    private boolean updateMat(Materialisation mat, Solution sol) {
        boolean result = false;
        switch (this.stage) {
            case 1: {
                result = this.updateMatFirstStage(mat, sol);
                break;
            }
            case 2: {
                result = this.updateMatSecondStage(mat, sol);
                break;
            }
            case 3: {
                result = this.updateMatThirdStage(mat, sol);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    private boolean updateMatFirstStage(Materialisation mat, Solution sol) {
        assert (this.stage == 1);
        Shape shape = mat.getShape();
        Multiplicity.MultKind kind = this.finalMultKind();
        MyHashSet<ShapeEdge> zeroEdges = new MyHashSet<ShapeEdge>();
        MyHashSet<ShapeEdge> positiveEdges = new MyHashSet<ShapeEdge>();
        int i = 0;
        while (i < this.eqSys.getVarsCount()) {
            Multiplicity mult = sol.getMultValue(i, kind);
            ShapeEdge edge = this.varEdgeMap.get(i);
            if (mult.isZero()) {
                zeroEdges.add(edge);
            } else {
                positiveEdges.add(edge);
            }
            ++i;
        }
        ShapeMorphism morph = mat.getShapeMorphism();
        for (ShapeEdge zeroEdge : zeroEdges) {
            if (shape.containsEdge(zeroEdge)) {
                shape.removeEdge(zeroEdge);
            }
            morph.removeEdge(zeroEdge);
        }
        this.collectGarbageNodes(mat, sol);
        MyHashSet<EdgeBundle> nonSingBundles = new MyHashSet<EdgeBundle>();
        MyHashSet nonSingEdges = new MyHashSet();
        for (EdgeBundle bundle : mat.getBundles()) {
            bundle.updateFromSolution(shape, zeroEdges, positiveEdges);
            if (!bundle.isNonSingular() || !shape.getNodeMult(bundle.node).isCollector()) continue;
            nonSingBundles.add(bundle);
            nonSingEdges.addAll(bundle.possibleEdges);
        }
        for (ShapeEdge positiveEdge : positiveEdges) {
            if (shape.containsEdge(positiveEdge) || nonSingEdges.contains(positiveEdge)) continue;
            shape.addEdgeContext(positiveEdge);
        }
        mat.moveToSecondStage(nonSingBundles);
        return true;
    }

    private void collectGarbageNodes(Materialisation mat, Solution sol) {
        assert (this.stage == 1);
        Set<ShapeNode> garbageNodes = sol.getGarbageNodes();
        if (garbageNodes == null) {
            return;
        }
        Shape shape = mat.getShape();
        for (ShapeNode node : garbageNodes) {
            assert (shape.getNodeMult(node).isZeroPlus());
            assert (shape.isUnconnected(node));
            mat.removeUnconnectedNode(node);
        }
    }

    private boolean updateMatSecondStage(Materialisation mat, Solution sol) {
        assert (this.stage == 2);
        Shape shape = mat.getShape();
        Multiplicity.MultKind kind = this.finalMultKind();
        int i = 0;
        while (i < this.eqSys.getVarsCount()) {
            Multiplicity mult = sol.getMultValue(i, kind);
            assert (mult.isSingleton() || mult.isCollector());
            EdgeSignature es = this.varEsMap.get(i);
            shape.setEdgeSigMult(es, mult);
            ++i;
        }
        mat.recursiveGarbageCollectNodes();
        if (mat.requiresThirdStage()) {
            mat.moveToThirdStage();
            return true;
        }
        return false;
    }

    private boolean updateMatThirdStage(Materialisation mat, Solution sol) {
        assert (this.stage == 3);
        Shape shape = mat.getShape();
        Multiplicity.MultKind kind = this.finalMultKind();
        int i = 0;
        while (i < this.eqSys.getVarsCount()) {
            Multiplicity mult = sol.getMultValue(i, kind);
            shape.setNodeMult(this.varNodeMap.get(i), mult);
            ++i;
        }
        return false;
    }

    private Duo<Equation> createEquations(Duo<Var> vars, int lbConst, int ubConst) {
        Equation lbEq = new Equation(Collections.singletonList((Var)vars.one()), BoundType.LB, lbConst, null);
        Equation ubEq = new Equation(Collections.singletonList((Var)vars.two()), BoundType.UB, ubConst, null);
        return new Duo<Equation>(lbEq, ubEq);
    }

    private Duo<Equation> createEquations(List<Duo<Var>> vars, int lbConst, int ubConst) {
        return this.createEquations(vars, lbConst, ubConst, null);
    }

    private Duo<Equation> createEquations(List<Duo<Var>> varList, int lbConst, int ubConst, ShapeNode node) {
        ArrayList<Var> lbVars = new ArrayList<Var>(varList.size());
        ArrayList<Var> ubVars = new ArrayList<Var>(varList.size());
        for (Duo<Var> varDuo : varList) {
            lbVars.add((Var)varDuo.one());
            ubVars.add((Var)varDuo.two());
        }
        Equation lbEq = new Equation(lbVars, BoundType.LB, lbConst, node);
        Equation ubEq = new Equation(ubVars, BoundType.UB, ubConst, node);
        return new Duo<Equation>(lbEq, ubEq);
    }

    private Duo<Var> retrieveBoundVars(ShapeNode node) {
        assert (this.stage == 3);
        Duo<Var> vars = this.nodeVarsMap.get(node);
        if (vars == null) {
            vars = this.eqSys.createVars();
            this.nodeVarsMap.put(node, vars);
            this.varNodeMap.add(((Var)vars.one()).getNumber(), node);
        }
        return vars;
    }

    private Duo<Var> retrieveBoundVars(ShapeEdge edge) {
        assert (this.stage == 1);
        Duo<Var> vars = this.edgeVarsMap.get(edge);
        if (vars == null) {
            vars = this.eqSys.createVars();
            this.edgeVarsMap.put(edge, vars);
            this.varEdgeMap.add(((Var)vars.one()).getNumber(), edge);
        }
        return vars;
    }

    private Duo<Var> retrieveBoundVars(EdgeSignature es) {
        assert (this.stage == 2);
        EdgeMultDir direction = es.getDirection();
        Duo<Var> vars = this.getEsMap(direction).get(es);
        if (vars == null) {
            vars = this.eqSys.createVars();
            this.getEsMap(direction).put(es, vars);
            this.varEsMap.add(((Var)vars.one()).getNumber(), es);
        }
        return vars;
    }

    private Map<EdgeSignature, Duo<Var>> getEsMap(EdgeMultDir direction) {
        assert (this.stage == 2);
        Map<EdgeSignature, Duo<Var>> result = null;
        switch (direction) {
            case OUTGOING: {
                result = this.outEsVarsMap;
                break;
            }
            case INCOMING: {
                result = this.inEsVarsMap;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    private Multiplicity.MultKind finalMultKind() {
        Multiplicity.MultKind kind = null;
        switch (this.stage) {
            case 1: 
            case 2: {
                kind = Multiplicity.MultKind.EDGE_MULT;
                break;
            }
            case 3: {
                kind = Multiplicity.MultKind.NODE_MULT;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return kind;
    }
}

