/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.shape;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.NeighAbsParam;
import groove.abstraction.neigh.Util;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.EquivRelation;
import groove.abstraction.neigh.equiv.GraphNeighEquiv;
import groove.abstraction.neigh.equiv.NodeEquivClass;
import groove.abstraction.neigh.equiv.ShapeNeighEquiv;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.EdgeSignatureStore;
import groove.abstraction.neigh.shape.HostToShapeMap;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeFactory;
import groove.abstraction.neigh.shape.ShapeGraph;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.trans.Materialisation;
import groove.abstraction.neigh.trans.RuleToShapeMap;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeLabel;
import groove.graph.ANode;
import groove.graph.EdgeRole;
import groove.graph.GGraph;
import groove.graph.Graph;
import groove.graph.Label;
import groove.graph.Node;
import groove.util.Duo;
import groove.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Shape
extends ShapeGraph {
    public Shape(String name, ShapeFactory factory) {
        super(name, factory);
    }

    @Override
    public Shape newGraph(String name) {
        return new Shape(name, this.getFactory());
    }

    @Override
    public Shape clone() {
        return (Shape)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Nodes:\n");
        for (ShapeNode node : this.nodeSet()) {
            sb.append("  " + node + ":" + this.getNodeMult(node) + " ");
            sb.append(Util.getNodeLabels(this, node) + "\n");
        }
        sb.append("Edges:\n");
        for (ShapeEdge e : this.binaryEdgeSet()) {
            sb.append("  " + this.getEdgeMult(e, EdgeMultDir.OUTGOING) + ":" + e + ":" + this.getEdgeMult(e, EdgeMultDir.INCOMING) + "\n");
        }
        sb.append("Equiv. Relation: " + this.getEquivRelation() + "\n");
        return sb.toString();
    }

    @Override
    public boolean addNode(HostNode node) {
        assert (!this.isFixed());
        assert (node instanceof ShapeNode);
        boolean added = super.addNode(node);
        if (added) {
            ShapeNode nodeS = (ShapeNode)node;
            this.setNodeMult(nodeS, Multiplicity.ONE_NODE_MULT);
            this.addToNewEquivClass(nodeS);
        }
        return added;
    }

    @Override
    public ShapeNode addNode() {
        assert (false);
        return null;
    }

    @Override
    public boolean addEdge(HostEdge edge) {
        boolean added = super.addEdge(edge);
        if (added && edge.getRole() == EdgeRole.BINARY) {
            ShapeEdge edgeS = (ShapeEdge)edge;
            EdgeSignatureStore store = this.getEdgeSigStore();
            store.addEdge(edgeS);
        }
        return added;
    }

    @Override
    public boolean removeNodeContext(HostNode node) {
        assert (!this.isFixed());
        boolean result = this.containsNode(node);
        if (result) {
            ArrayList<ShapeEdge> toRemove = new ArrayList<ShapeEdge>(this.edgeSet(node));
            for (ShapeEdge edgeToRemove : toRemove) {
                this.removeEdge(edgeToRemove);
            }
            this.removeNode(node);
        }
        return result;
    }

    @Override
    public boolean removeNode(HostNode node) {
        boolean result = super.removeNode(node);
        if (result) {
            ShapeNode nodeS = (ShapeNode)node;
            EquivClass<ShapeNode> ec = this.getEquivRelation().getEquivClassOf(nodeS);
            if (ec.isSingleton()) {
                this.getEquivRelation().remove(ec);
            } else {
                EquivClass<ShapeNode> newEc = ec.clone();
                newEc.remove(nodeS);
                this.replaceEc(ec, newEc);
            }
            this.getNodeMultMap().remove(nodeS);
        }
        return result;
    }

    @Override
    public boolean removeEdge(HostEdge edge) {
        assert (!this.isFixed());
        boolean result = super.removeEdge(edge);
        if (result && edge.getRole() == EdgeRole.BINARY) {
            ShapeEdge edgeS = (ShapeEdge)edge;
            EdgeSignatureStore edgeSigs = this.getEdgeSigStore();
            edgeSigs.removeEdge(edgeS);
            assert (edgeSigs.isComplete());
        }
        return result;
    }

    @Override
    public boolean setFixed() {
        boolean result = super.setFixed();
        if (result) {
            this.getEquivRelation().setFixed();
        }
        return result;
    }

    private ShapeNode createNode(TypeLabel type) {
        HostNode freshNode = this.getFactory().createNode(type, this.nodeSet());
        assert (!this.nodeSet().contains(freshNode)) : String.format("Fresh node %s already in node set %s", freshNode, this.nodeSet());
        super.addNode(freshNode);
        return freshNode;
    }

    public ShapeEdge createEdge(HostNode node0, HostNode node1, Label label, EdgeMultDir direction) {
        switch (direction) {
            case OUTGOING: {
                return this.createEdge(node0, label, node1);
            }
            case INCOMING: {
                return this.createEdge(node1, label, node0);
            }
        }
        assert (false);
        return null;
    }

    private Set<ShapeEdge> binaryEdgeSet() {
        MyHashSet<ShapeEdge> result = new MyHashSet<ShapeEdge>();
        for (ShapeEdge edge : this.edgeSet()) {
            if (edge.getRole() != EdgeRole.BINARY) continue;
            result.add(edge);
        }
        return result;
    }

    private Set<ShapeEdge> outBinaryEdgeSet(ShapeNode source) {
        MyHashSet<ShapeEdge> result = new MyHashSet<ShapeEdge>();
        for (ShapeEdge edge : this.outEdgeSet(source)) {
            if (edge.getRole() != EdgeRole.BINARY) continue;
            result.add(edge);
        }
        return result;
    }

    private Set<ShapeEdge> inBinaryEdgeSet(ShapeNode target) {
        MyHashSet<ShapeEdge> result = new MyHashSet<ShapeEdge>();
        for (ShapeEdge edge : this.inEdgeSet(target)) {
            if (edge.getRole() != EdgeRole.BINARY) continue;
            result.add(edge);
        }
        return result;
    }

    public Set<ShapeEdge> binaryEdgeSet(ShapeNode node, EdgeMultDir direction) {
        Set<ShapeEdge> result = null;
        switch (direction) {
            case OUTGOING: {
                result = this.outBinaryEdgeSet(node);
                break;
            }
            case INCOMING: {
                result = this.inBinaryEdgeSet(node);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    public GGraph<ShapeNode, ShapeEdge> downcast() {
        return this;
    }

    public static Shape upcast(GGraph<ShapeNode, ShapeEdge> shape) {
        return (Shape)shape;
    }

    private void createShapeNodes(GraphNeighEquiv gne, HostToShapeMap map) {
        assert (!this.isFixed());
        for (EquivClass ec : gne) {
            HostNode nodeG = (HostNode)ec.iterator().next();
            ShapeNode nodeS = this.createNode(nodeG.getType().label());
            int size = ec.size();
            Multiplicity mult = Multiplicity.approx(size, size, Multiplicity.MultKind.NODE_MULT);
            this.setNodeMult(nodeS, mult);
            for (HostNode node : ec) {
                map.putNode(node, nodeS);
            }
        }
    }

    private void createShapeNodes(ShapeNeighEquiv sne, HostToShapeMap map, Shape origShape) {
        assert (!this.isFixed());
        for (EquivClass ec : sne) {
            ShapeNode nodeS = (ShapeNode)ec.iterator().next();
            super.addNode(nodeS);
            Multiplicity mult = origShape.getNodeSetMultSum(ec);
            this.setNodeMult(nodeS, mult);
            for (HostNode node : ec) {
                map.putNode(node, nodeS);
            }
        }
    }

    private void createEquivRelation(EquivRelation<HostNode> er, HostToShapeMap map) {
        assert (!this.isFixed());
        for (EquivClass equivClass : er) {
            EquivClass<ShapeNode> ecS = this.newNodeEquivClass();
            for (HostNode node : equivClass) {
                ecS.add(map.getNode(node));
            }
            this.getEquivRelation().add(ecS);
        }
    }

    private EquivClass<ShapeNode> newNodeEquivClass() {
        return new NodeEquivClass<ShapeNode>(this.getFactory());
    }

    private void createShapeEdges(EquivRelation<HostEdge> er, HostToShapeMap map) {
        assert (!this.isFixed());
        for (EquivClass equivClass : er) {
            HostEdge edgeG = (HostEdge)equivClass.iterator().next();
            HostNode srcG = edgeG.source();
            HostNode tgtG = edgeG.target();
            ShapeNode srcS = map.getNode(srcG);
            ShapeNode tgtS = map.getNode(tgtG);
            TypeLabel labelS = edgeG.label();
            ShapeEdge edgeS = this.createEdge(srcS, (Label)labelS, tgtS);
            this.addEdge(edgeS);
            for (HostEdge eG : equivClass) {
                map.putEdge(eG, edgeS);
            }
        }
    }

    private void createEdgeMultMaps(GraphNeighEquiv gne, HostToShapeMap map, HostGraph graph) {
        assert (!this.isFixed());
        MyHashSet intersectEdges = new MyHashSet();
        for (ShapeEdge edgeS : this.binaryEdgeSet()) {
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir direction = edgeMultDirArray[n2];
                EdgeSignature es = this.getEdgeSignature(edgeS, direction);
                EquivClass<HostNode> ecG = map.getPreImages(es.getEquivClass());
                HostNode nodeG = null;
                switch (direction) {
                    case OUTGOING: {
                        nodeG = map.getPreImages(edgeS.source()).iterator().next();
                        Util.getIntersectEdges((Graph)graph, nodeG, ecG, edgeS.label(), intersectEdges);
                        break;
                    }
                    case INCOMING: {
                        nodeG = map.getPreImages(edgeS.target()).iterator().next();
                        Util.getIntersectEdges((Graph)graph, ecG, nodeG, edgeS.label(), intersectEdges);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                int size = intersectEdges.size();
                Multiplicity mult = Multiplicity.approx(size, size, Multiplicity.MultKind.EDGE_MULT);
                this.setEdgeSigMult(es, mult);
                ++n2;
            }
        }
    }

    private void createEdgeMultMaps(ShapeNeighEquiv currGraphNeighEquiv, HostToShapeMap map, Shape origShape) {
        assert (!this.isFixed());
        Map<EdgeSignature, Multiplicity> esTMap = this.getEdgeSigStore().getMultMap();
        for (Map.Entry<EdgeSignature, Multiplicity> esTEntry : esTMap.entrySet()) {
            EdgeSignature esT = esTEntry.getKey();
            ShapeNode nodeS = (ShapeNode)map.getPreImages(esT.getNode()).iterator().next();
            EquivClass<HostNode> ecTonS = map.getPreImages(esT.getEquivClass());
            Multiplicity mult = currGraphNeighEquiv.getMultSum(esT.getDirection(), nodeS, esT.getLabel(), ecTonS);
            esTEntry.setValue(mult);
        }
    }

    private ShapeEdge getShapeEdge(ShapeNode source, TypeLabel label, ShapeNode target) {
        ShapeEdge result = this.getFactory().createEdge((HostNode)source, (Label)label, (HostNode)target);
        if (!this.containsEdge(result)) {
            result = null;
        }
        return result;
    }

    public ShapeEdge getShapeEdge(ShapeNode node0, ShapeNode node1, TypeLabel label, EdgeMultDir direction) {
        switch (direction) {
            case OUTGOING: {
                return this.getShapeEdge(node0, label, node1);
            }
            case INCOMING: {
                return this.getShapeEdge(node1, label, node0);
            }
        }
        assert (false);
        return null;
    }

    public EdgeSignature getEdgeSignature(ShapeEdge edge, EdgeMultDir direction) {
        EdgeSignature result = this.getEdgeSigStore().getSig(edge, direction);
        if (result == null) {
            result = this.createEdgeSignature(direction, edge);
        }
        return result;
    }

    public EdgeSignature getEdgeSignature(EdgeMultDir direction, ShapeNode node, TypeLabel label, EquivClass<ShapeNode> ec) {
        EdgeSignature result = this.getEdgeSigStore().getSig(direction, node, label, ec);
        if (result == null) {
            result = this.createEdgeSignature(direction, node, label, ec);
        }
        return result;
    }

    public void setNodeMult(ShapeNode node, Multiplicity mult) {
        assert (!this.isFixed());
        assert (mult.isNodeKind());
        assert (this.containsNode(node)) : "Node " + node + " is not in the shape!";
        if (!mult.isZero()) {
            this.getNodeMultMap().put(node, mult);
        } else {
            this.removeNodeContext(node);
        }
    }

    public void setEdgeSigMult(EdgeSignature es, Multiplicity mult) {
        assert (!this.isFixed());
        assert (mult.isEdgeKind());
        assert (this.containsNode(es.getNode()));
        assert (this.getEquivRelation().contains(es.getEquivClass()));
        EdgeSignatureStore store = this.getEdgeSigStore();
        if (mult.isZero()) {
            ArrayList<ShapeEdge> toRemove = new ArrayList<ShapeEdge>(store.getEdges(es));
            for (ShapeEdge edge : toRemove) {
                this.removeEdge(edge);
            }
        } else {
            store.setEdgeMult(es, mult);
        }
    }

    public Multiplicity getNodeMult(ShapeNode node) {
        Multiplicity result = this.getNodeMultMap().get(node);
        return result == null ? Multiplicity.ZERO_NODE_MULT : result;
    }

    Multiplicity getNodeSetMultSum(Set<? extends HostNode> nodes) {
        Multiplicity accumulator = Multiplicity.ZERO_NODE_MULT;
        Map<ShapeNode, Multiplicity> nodeMultMap = this.getNodeMultMap();
        for (HostNode hostNode : nodes) {
            Multiplicity nodeMult = nodeMultMap.get(hostNode);
            accumulator = accumulator.add(nodeMult);
        }
        return accumulator;
    }

    public Multiplicity getEdgeMult(ShapeEdge edge, EdgeMultDir direction) {
        Multiplicity result = this.getEdgeSigStore().getMult(edge, direction);
        return result == null ? Multiplicity.ZERO_EDGE_MULT : result;
    }

    public Multiplicity getEdgeSigMult(EdgeSignature es) {
        Multiplicity result = this.getEdgeSigStore().getMult(es);
        return result == null ? Multiplicity.ZERO_EDGE_MULT : result;
    }

    Multiplicity getEdgeSigSetMult(Set<EdgeSignature> esS) {
        Multiplicity accumulator = Multiplicity.ZERO_EDGE_MULT;
        for (EdgeSignature es : esS) {
            Multiplicity edgeMult = this.getEdgeSigMult(es);
            accumulator = accumulator.add(edgeMult);
        }
        return accumulator;
    }

    private EquivClass<ShapeNode> addToNewEquivClass(ShapeNode node) {
        assert (!this.isFixed());
        EquivClass<ShapeNode> newEc = this.newNodeEquivClass();
        newEc.add(node);
        this.getEquivRelation().add(newEc);
        return newEc;
    }

    public Duo<String> getEdgeMultLabels(ShapeEdge edge) {
        Duo<String> result = new Duo<String>("", "");
        EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
        int n = edgeMultDirArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeMultDir direction = edgeMultDirArray[n2];
            EdgeSignature es = this.getEdgeSignature(edge, direction);
            if (es.getEquivClass().isSingleton() || this.isEdgeSigUnique(es) || edge.equals(this.getMinimumEdgeFromSig(es))) {
                String multStr = this.getEdgeSigMult(es).toString();
                switch (direction) {
                    case OUTGOING: {
                        result.setTwo(multStr);
                        break;
                    }
                    case INCOMING: {
                        result.setOne(multStr);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    public boolean hasEdgeSignature(EdgeSignature es) {
        return this.getEdgeSigSet().contains(es);
    }

    public boolean isEdgeSigUnique(EdgeSignature es) {
        return this.getEdgesFromSig(es).size() == 1;
    }

    private ShapeEdge getMinimumEdgeFromSig(EdgeSignature es) {
        ShapeEdge result = null;
        ANode resultOpposite = null;
        EdgeMultDir direction = es.getDirection();
        for (ShapeEdge edge : this.getEdgesFromSig(es)) {
            ShapeNode ecNode = direction.opposite(edge);
            if (resultOpposite != null && ecNode.getNumber() >= resultOpposite.getNumber()) continue;
            result = edge;
            resultOpposite = ecNode;
        }
        return result;
    }

    public Set<ShapeEdge> getEdgesFromSig(EdgeSignature es) {
        return this.getEdgeSigStore().getEdges(es);
    }

    public void materialiseNode(Materialisation mat, ShapeNode collectorNode) {
        assert (!this.isFixed());
        assert (this.containsNode(collectorNode));
        assert (mat.getStage() == 1);
        assert (this.getNodeMult(collectorNode).isCollector());
        RuleToShapeMap match = mat.getMatch();
        Set<RuleNode> nodesR = mat.getOriginalMatch().getPreImages(collectorNode);
        assert (!nodesR.isEmpty());
        int copies = nodesR.size();
        boolean useCollector = false;
        Multiplicity collectNodeMult = this.getNodeMult(collectorNode);
        if (!collectNodeMult.isUnbounded() && collectNodeMult.getLowerBound() == copies) {
            useCollector = true;
            --copies;
        }
        Iterator<RuleNode> iter = nodesR.iterator();
        int i = 0;
        while (i < copies) {
            RuleNode nodeR = iter.next();
            ShapeNode newNode = this.createNode(collectorNode.getType().label());
            this.setNodeMult(newNode, Multiplicity.ONE_NODE_MULT);
            this.copyUnaryEdges(collectorNode, newNode, nodeR, match);
            this.addToNewEquivClass(newNode);
            mat.addMatNode(newNode, collectorNode, nodeR);
            ++i;
        }
        Multiplicity oldMult = this.getNodeMult(collectorNode);
        Multiplicity newMult = oldMult.sub(copies);
        assert (!newMult.isZero());
        this.setNodeMult(collectorNode, newMult);
        if (useCollector) {
            assert (newMult.isOne());
            RuleNode nodeR = iter.next();
            this.copyUnaryEdges(collectorNode, collectorNode, nodeR, match);
            mat.addMatNode(collectorNode, collectorNode, nodeR);
            assert (!iter.hasNext());
        }
        mat.handleCollectorNode(collectorNode);
    }

    public void materialiseEdge(Materialisation mat, ShapeEdge inconsistentEdge) {
        assert (!this.isFixed());
        assert (mat.getStage() == 1);
        assert (mat.getOriginalShape().containsEdge(inconsistentEdge));
        RuleToShapeMap match = mat.getMatch();
        Set<RuleEdge> edgesR = mat.getOriginalMatch().getPreImages(inconsistentEdge);
        assert (!edgesR.isEmpty());
        TypeLabel label = (TypeLabel)inconsistentEdge.label();
        for (RuleEdge edgeR : edgesR) {
            ShapeNode srcS = match.getNode((Node)edgeR.source());
            ShapeNode tgtS = match.getNode((Node)edgeR.target());
            ShapeEdge newEdge = this.createEdge(srcS, (Label)label, tgtS);
            this.addEdge(newEdge);
            mat.addMatEdge(newEdge, inconsistentEdge, edgeR);
        }
        mat.handleInconsistentEdge(inconsistentEdge);
    }

    public void singulariseNode(Materialisation mat, ShapeNode nodeS) {
        assert (!this.isFixed());
        assert (this.containsNode(nodeS));
        assert (mat.getStage() == 1);
        if (this.getEquivClassOf(nodeS).isSingleton()) {
            return;
        }
        this.handleCrossingEdges(mat, nodeS);
        EquivClass<ShapeNode> origEc = this.getEquivClassOf(nodeS);
        EquivClass<ShapeNode> remEc = origEc.clone();
        remEc.remove(nodeS);
        EquivClass<ShapeNode> singEc = this.newNodeEquivClass();
        singEc.add(nodeS);
        this.replaceEc(origEc, remEc, singEc);
    }

    private void handleCrossingEdges(Materialisation mat, ShapeNode nodeS) {
        MyHashSet possibleEdges = new MyHashSet();
        for (ShapeEdge edgeS : this.edgeSet(nodeS)) {
            if (edgeS.getRole() != EdgeRole.BINARY || this.isEdgeConcrete(edgeS)) continue;
            possibleEdges.add(edgeS);
        }
        for (ShapeEdge possibleEdge : possibleEdges) {
            this.removeEdge(possibleEdge);
            mat.addPossibleEdge(possibleEdge, possibleEdge);
        }
    }

    public void splitNode(Materialisation mat, ShapeNode nodeS, int copies) {
        assert (!this.isFixed());
        assert (this.containsNode(nodeS));
        assert (mat.getStage() == 2);
        EquivClass<ShapeNode> oldEc = this.getEquivClassOf(nodeS);
        EquivClass<ShapeNode> newEc = oldEc.clone();
        int i = 0;
        while (i < copies) {
            ShapeNode newNode = this.createNode(nodeS.getType().label());
            this.copyUnaryEdges(nodeS, newNode, null, null);
            newEc.add(newNode);
            mat.addSplitNode(newNode, nodeS);
            ++i;
        }
        this.replaceEc(oldEc, newEc);
    }

    private void copyUnaryEdges(ShapeNode from, ShapeNode to, RuleNode nodeR, RuleToShapeMap match) {
        assert (!this.isFixed());
        for (ShapeEdge edge : this.outEdgeSet(from)) {
            RuleEdge edgeR;
            if (edge.getRole() == EdgeRole.BINARY) continue;
            TypeLabel label = (TypeLabel)edge.label();
            ShapeEdge edgeS = (ShapeEdge)this.addEdge(to, label, to);
            if (match == null || nodeR == null || (edgeR = match.getSelfEdge(nodeR, label)) == null) continue;
            match.putEdge(edgeR, edgeS);
        }
    }

    private void replaceEc(EquivClass<ShapeNode> oldEc, EquivClass<ShapeNode> ... newEcs) {
        this.getEquivRelation().remove(oldEc);
        EquivClass<ShapeNode>[] equivClassArray = newEcs;
        int n = newEcs.length;
        int n2 = 0;
        while (n2 < n) {
            EquivClass<ShapeNode> newEc = equivClassArray[n2];
            this.getEquivRelation().add(newEc);
            ++n2;
        }
        ArrayList<EdgeSignature> removed = new ArrayList<EdgeSignature>();
        ArrayList<Pair<EdgeSignature, Multiplicity>> added = new ArrayList<Pair<EdgeSignature, Multiplicity>>();
        EdgeSignatureStore store = this.getEdgeSigStore();
        for (Map.Entry<EdgeSignature, Multiplicity> entry : store.getMultMap().entrySet()) {
            EdgeSignature oldEs = entry.getKey();
            if (!oldEs.hasSameEquivClass(oldEc)) continue;
            removed.add(oldEs);
            Multiplicity mult = entry.getValue();
            if (mult.isZero()) continue;
            EdgeMultDir dir = oldEs.getDirection();
            ShapeNode esNode = oldEs.getNode();
            TypeLabel eslabel = oldEs.getLabel();
            EquivClass<ShapeNode>[] equivClassArray2 = newEcs;
            int n3 = newEcs.length;
            int n4 = 0;
            while (n4 < n3) {
                EquivClass<ShapeNode> newEc = equivClassArray2[n4];
                EdgeSignature newEs = this.createEdgeSignature(dir, esNode, eslabel, newEc);
                if (newEs.hasEdges(this)) {
                    added.add(Pair.newPair(newEs, mult));
                }
                ++n4;
            }
        }
        for (EdgeSignature edgeSignature : removed) {
            store.removeSig(edgeSignature);
        }
        for (Pair pair : added) {
            this.setEdgeSigMult((EdgeSignature)pair.one(), (Multiplicity)pair.two());
        }
        assert (store.isComplete());
    }

    public boolean isEdgeConcrete(ShapeEdge edge) {
        return this.isEdgeConcrete(edge, EdgeMultDir.OUTGOING) && this.isEdgeConcrete(edge, EdgeMultDir.INCOMING);
    }

    private boolean isEdgeConcrete(ShapeEdge edge, EdgeMultDir direction) {
        EdgeSignature es = this.getEdgeSignature(edge, direction);
        return this.isEdgeSigConcrete(es);
    }

    public boolean isEdgeSigConcrete(EdgeSignature es) {
        return this.getEdgeSigMult(es).isOne() && this.isEdgeSigUnique(es);
    }

    public boolean areNodesConcrete(ShapeEdge edge) {
        return this.getNodeMult(edge.source()).isOne() && this.getNodeMult(edge.target()).isOne();
    }

    public boolean isEdgeUnique(ShapeEdge edge, EdgeMultDir direction) {
        EdgeSignature es = this.getEdgeSignature(edge, direction);
        return this.isEdgeSigUnique(es);
    }

    public Shape normalise() {
        Shape newShape = this.newGraph(this.getName());
        HostToShapeMap map = new HostToShapeMap(this.getFactory());
        int radius = NeighAbsParam.getInstance().getAbsRadius();
        ShapeNeighEquiv sne = new ShapeNeighEquiv(this, radius);
        newShape.createShapeNodes(sne, map, this);
        newShape.createEquivRelation(sne.getPrevEquivRelation(), map);
        newShape.createShapeEdges(sne.getEdgesEquivRel(), map);
        newShape.createEdgeMultMaps(sne, map, this);
        Map<ShapeNode, Multiplicity> newMultMap = newShape.getNodeMultMap();
        block0: for (Map.Entry<ShapeNode, Multiplicity> nodeEntry : newMultMap.entrySet()) {
            Multiplicity nodeMult = nodeEntry.getValue();
            if (!nodeMult.isUnbounded()) continue;
            ShapeNode node = nodeEntry.getKey();
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir direction = edgeMultDirArray[n2];
                for (ShapeEdge edge : newShape.binaryEdgeSet(node, direction)) {
                    ShapeNode opp = direction.opposite(edge);
                    Multiplicity oppMult = newMultMap.get(opp);
                    if (!oppMult.isOne() || !newShape.isEdgeConcrete(edge)) continue;
                    nodeEntry.setValue(Multiplicity.ONE_NODE_MULT);
                    continue block0;
                }
                ++n2;
            }
        }
        assert (newShape.isInvariantOK());
        return newShape;
    }

    public boolean isUnconnected(ShapeNode node) {
        assert (this.containsNode(node));
        return this.binaryEdgeSet(node, EdgeMultDir.OUTGOING).isEmpty() && this.binaryEdgeSet(node, EdgeMultDir.INCOMING).isEmpty();
    }

    public boolean isInvariantOK() {
        for (EdgeSignature es : this.getEdgeSigSet()) {
            if (!this.getEquivRelation().contains(es.getEquivClass())) {
                return false;
            }
            if (this.getEdgesFromSig(es).size() != 0) continue;
            return false;
        }
        return true;
    }

    public static Shape createShape(HostGraph graph) {
        Shape shape = new Shape(graph.getName(), ShapeFactory.newInstance(graph.getTypeGraph().getFactory()));
        HostToShapeMap map = new HostToShapeMap(shape.getFactory());
        int radius = NeighAbsParam.getInstance().getAbsRadius();
        GraphNeighEquiv gne = new GraphNeighEquiv(graph, radius);
        shape.createShapeNodes(gne, map);
        shape.createEquivRelation(gne.getPrevEquivRelation(), map);
        shape.createShapeEdges(gne.getEdgesEquivRel(), map);
        shape.createEdgeMultMaps(gne, map, graph);
        assert (shape.isInvariantOK());
        return shape;
    }
}

