/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.lts;

import groove.abstraction.neigh.lts.AGTS;
import groove.abstraction.neigh.lts.ShapeNextState;
import groove.abstraction.neigh.lts.ShapeTransition;
import groove.abstraction.neigh.match.PreMatch;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.control.CtrlState;
import groove.control.CtrlTransition;
import groove.grammar.Rule;
import groove.grammar.host.HostElement;
import groove.grammar.host.HostNode;
import groove.lts.AbstractGraphState;
import groove.lts.ActionLabel;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.MatchCollector;
import groove.lts.MatchResult;
import groove.lts.MatchResultSet;
import groove.lts.RuleTransitionStub;
import groove.lts.StateCache;
import groove.lts.StateReference;
import groove.transform.Proof;
import groove.util.cache.CacheReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ShapeState
extends AbstractGraphState {
    private static final ShapeNode[] EMPTY_NODE_ARRAY = new ShapeNode[0];
    private Shape shape;
    private ShapeState subsumptor;
    private ArrayList<GraphTransition> transitions;
    private ArrayList<ShapeState> subsumedStates;

    protected ShapeState(CacheReference<StateCache> reference, Shape shape, CtrlState ctrlState, int number) {
        super(reference, number);
        this.shape = shape;
        if (!this.shape.isFixed()) {
            this.shape.setFixed();
        }
        this.transitions = new ArrayList();
        this.subsumedStates = new ArrayList();
        this.setCtrlState(ctrlState);
    }

    public ShapeState(AGTS gts, Shape shape, CtrlState ctrlState, int number) {
        this(StateReference.newInstance(gts), shape, ctrlState, number);
    }

    @Override
    public Shape getGraph() {
        return this.shape;
    }

    @Override
    public Set<? extends GraphTransition> getTransitions(GraphTransition.Class claz) {
        HashSet<GraphTransition> result = new HashSet<GraphTransition>();
        for (GraphTransition trans : this.transitions) {
            if (!claz.admits(trans)) continue;
            result.add(trans);
        }
        return result;
    }

    @Override
    protected void updateClosed() {
    }

    @Override
    public boolean addTransition(GraphTransition transition) {
        assert (transition instanceof ShapeTransition || transition instanceof ShapeNextState) : "Invalid transition type.";
        this.transitions.add(transition);
        return true;
    }

    public ShapeNode[] getBoundNodes() {
        return EMPTY_NODE_ARRAY;
    }

    protected boolean containsTransition(ActionLabel label, ShapeState target) {
        boolean result = false;
        for (GraphTransition trans : this.transitions) {
            if (trans.target().getNumber() != target.getNumber() || !trans.label().equals(label)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean setSubsumptor(ShapeState subsumptor) {
        if (this.getSubsumptor() != null) {
            return false;
        }
        this.subsumptor = subsumptor;
        return true;
    }

    protected ShapeState getSubsumptor() {
        return this.subsumptor;
    }

    public boolean isSubsumed() {
        return this.subsumptor != null;
    }

    protected void addSubsumedState(ShapeState subsumed) {
        this.subsumedStates.add(subsumed);
    }

    protected int markSubsumedStates(Collection<ShapeState> result) {
        int markCount = 0;
        for (ShapeState subsumed : this.subsumedStates) {
            if (!subsumed.setSubsumptor(this)) continue;
            ++markCount;
            if (result == null) continue;
            result.add(subsumed);
        }
        this.subsumedStates = null;
        return markCount;
    }

    public void disconnectState() {
        assert (this.isSubsumed());
        this.shape = null;
    }

    public boolean isDisconnected() {
        return this.shape == null && this.isSubsumed();
    }

    @Override
    public RuleTransitionStub getOutStub(MatchResult match) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected HostElement[] getFrozenGraph() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setFrozenGraph(HostElement[] frozenGraph) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected RuleTransitionStub createTransitionStub(MatchResult match, HostNode[] addedNodes, GraphState target) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected RuleTransitionStub createInTransitionStub(GraphState source, MatchResult match, HostNode[] addedNodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected StateCache createCache() {
        return new ShapeStateCache();
    }

    private class ShapeMatchSetCollector
    extends MatchCollector {
        public ShapeMatchSetCollector() {
            super(ShapeState.this);
        }

        @Override
        public MatchResultSet computeMatches(CtrlTransition ct) {
            MatchResultSet result = new MatchResultSet();
            Rule rule = ct.getRule();
            for (Proof preMatch : PreMatch.getPreMatches(ShapeState.this.getGraph(), rule)) {
                result.add(new MatchResult(ShapeState.this.getRecord().getEvent(preMatch), ct));
            }
            return result;
        }
    }

    private class ShapeStateCache
    extends StateCache {
        ShapeStateCache() {
            super(ShapeState.this);
        }

        @Override
        protected MatchCollector createMatchCollector() {
            return new ShapeMatchSetCollector();
        }
    }
}

