/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.equiv;

import groove.abstraction.Multiplicity;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.GraphNeighEquiv;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.type.TypeLabel;
import java.util.Map;

public final class ShapeNeighEquiv
extends GraphNeighEquiv {
    public ShapeNeighEquiv(HostGraph graph, int radius) {
        super(graph, radius);
        assert (graph instanceof Shape) : "Invalid argument type!";
    }

    @Override
    Map<HostNode, GraphNeighEquiv.NodeInfo> computeNodeToInfoMap() {
        Map<HostNode, GraphNeighEquiv.NodeInfo> result = this.createNodeToInfoMap();
        Map<HostNode, EquivClass<HostNode>> nodeToCellMap = this.getNodeToCellMap();
        Shape shape = (Shape)this.graph;
        for (Map.Entry<EdgeSignature, Multiplicity> esEntry : shape.getEdgeMultMap().entrySet()) {
            EdgeSignature es = esEntry.getKey();
            GraphNeighEquiv.NodeInfo info = result.get(es.getNode());
            EquivClass<HostNode> targetEc = nodeToCellMap.get(es.getEquivClass().iterator().next());
            info.add(es.getDirection(), es.getLabel(), targetEc, esEntry.getValue());
        }
        return result;
    }

    public Multiplicity getMultSum(EdgeMultDir direction, ShapeNode node, TypeLabel label, EquivClass<? extends HostNode> ec) {
        Map ecMap = (Map)((Map)this.getNodeToInfoMap().get(node).get((Object)direction)).get(label);
        Multiplicity result = ecMap == null ? null : (Multiplicity)ecMap.get(ec);
        return result == null ? Multiplicity.ZERO_EDGE_MULT : result;
    }
}

