/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xui;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.type.VirtualType;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.xui.NLS;
import com.jaxfront.core.xui.XUIDefinition;
import java.awt.Color;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCell
implements Cloneable,
Comparable<TableCell> {
    private Type _ownerType;
    private Type _refType;
    private String _nlsContext;
    private String _labelType;
    private String _origDimension;
    private String _dimension;
    private String _text;
    private String _cellText;
    private String _url;
    private String _urlTarget;
    private String _xpath;
    private boolean _isXPathLabel = false;
    private FormulaExpression _formula;
    private String _formulaExpression;
    private boolean _isButton = false;
    private boolean _isLabel = false;
    private String _fontName;
    private String _ruleId;
    private Integer _fontSize;
    private Integer _focusIndex;
    private String _fontStyle;
    private String _cssStyle;
    private String _nlsKey;
    private String _cssElementStyle;
    private Color _fontColor;
    private int _rowIndex = -1;
    private int _colIndex = -1;
    private String _horizontalAlignment = null;
    private String _verticalAlignment = null;
    private int _rowSpan = -1;
    private int _colSpan = -1;
    boolean _useDefaultFontColor = false;
    private String _areaID;
    private boolean _isGlobal = false;
    static /* synthetic */ Class class$com$jaxfront$core$xui$TableCell;

    public TableCell(Type ownerType, Type cellType, String dimension) {
        this(ownerType, cellType, dimension, false);
    }

    public TableCell(Type ownerType, Type cellType, String dimension, boolean isGlobal) {
        this._isGlobal = isGlobal;
        if (cellType != null) {
            this._nlsContext = NLS.getNLSPageLayoutContext(cellType);
        }
        this._ownerType = ownerType;
        if (cellType.getName().equals("label")) {
            this.initLabel(ownerType, cellType);
        } else if (cellType.getName().equals("button")) {
            this.initButton(cellType);
        } else {
            this._labelType = cellType.getName();
            this._text = ((SimpleType)cellType).getValue();
            Type type = this.getXPathReferencedType(ownerType);
            if (type != null) {
                type.setViewContextType(ownerType);
            }
        }
        Type cell = cellType.getParent("cell");
        this.initFocusIndex(cell);
        this.setCSSStyle(cell.getDirectChildValue("cssStyle"));
        this.setNlsKey(cellType.getDirectChildValue("nlsKey"));
        if (dimension != null) {
            this.convertDimension(dimension);
        }
    }

    public String getLabelType() {
        return this._labelType;
    }

    public boolean isImage() {
        return this.getLabelType() != null && this.getLabelType().equals("image");
    }

    public Type getXPathReferencedType() {
        return this.getXPathReferencedType(this.getType());
    }

    public Type getXPathReferencedType(Type ownerType) {
        if (this.isButton() || this.isImage()) {
            return null;
        }
        if (this._text != null) {
            return this.getXPathReferencedType(ownerType, this._text);
        }
        return this.getXPathReferencedType(ownerType, this._xpath);
    }

    public Type getXPathReferencedType(Type ownerType, String path) {
        if (this._refType != null && !this._refType.isReleased()) {
            return this._refType;
        }
        this._refType = TableCell.evalXPathReferencedType(ownerType, path, false);
        return this._refType;
    }

    public static Type evalXPathReferencedType(Type ownerType, String path, boolean isXUIEditor) {
        if (ownerType != null && path != null && !path.equals("")) {
            List types = TypePathExecuter.getInstance().processXPath(ownerType, path, false, false, isXUIEditor, false, true);
            if (types != null && !types.isEmpty()) {
                return (Type)types.get(0);
            }
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(class$com$jaxfront$core$xui$TableCell == null ? (class$com$jaxfront$core$xui$TableCell = TableCell.class$("com.jaxfront.core.xui.TableCell")) : class$com$jaxfront$core$xui$TableCell, new StringBuffer().append("Cell not found:").append(path).append(" owner:").append(ownerType.getXPathLocation()).toString());
            }
        }
        return null;
    }

    public String getDimension() {
        return this._dimension;
    }

    public void setDimension(String newDimension) {
        this._dimension = newDimension;
    }

    public FormulaExpression getFormula() {
        return this._formula;
    }

    public String getToolTipText() {
        Type type;
        String nlsDimension = this._origDimension;
        StringTokenizer st = new StringTokenizer(this._origDimension, ",");
        if (st.hasMoreTokens()) {
            nlsDimension = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            nlsDimension = new StringBuffer().append(nlsDimension).append(",").append(st.nextToken()).toString();
        }
        String toolTip = null;
        if (this.getType().getStyle() != null && (toolTip = this.getType().getStyle().getNLS(this._nlsContext, nlsDimension, "tooltip")) == null && this._xpath != null && (type = TypePathExecuter.getInstance().getTypeForXPath(this._ownerType, this._xpath)) != null) {
            toolTip = type.getStyle().getLabelToolTip();
        }
        return toolTip;
    }

    public String getLabel() {
        String nlsText;
        String[] dims;
        String nlsDimension = this._origDimension;
        if (this._origDimension != null && (dims = TextTools.tokenize(this._origDimension, ",")) != null) {
            if (dims.length > 0) {
                nlsDimension = dims[0];
            }
            if (dims.length > 1) {
                nlsDimension = new StringBuffer().append(nlsDimension).append(",").append(dims[1]).toString();
            }
        }
        if (this.getNlsKey() != null) {
            return this.getType().getDOM().getNLS().get(this.getNlsKey());
        }
        if (this.hasFormula()) {
            try {
                String label = this.getFormula().evaluate();
                return label;
            }
            catch (FormulaException ex) {
                return null;
            }
        }
        if (this.isButton()) {
            nlsText = this.getType().getStyle().getNLS(this._nlsContext, nlsDimension, null);
            if (nlsText == null) {
                return this.getText();
            }
            return nlsText;
        }
        if (this.isXPathLabel() && this._xpath != null) {
            String text = null;
            Type type = TypePathExecuter.getInstance().getTypeForXPath(this._ownerType, this._xpath);
            if (type != null && (text = this.getType().getStyle().getNLS(this._nlsContext, nlsDimension, null)) == null) {
                text = type.getStyle().getLabelText();
            }
            return text;
        }
        if (this._text == null) {
            nlsText = this.getType().getStyle().getNLS(this._nlsContext, nlsDimension, null);
            if (nlsText != null) {
                return nlsText;
            }
            String globalUserPropertyText = TextTools.replaceGlobalUserProperties(this._text, this._ownerType.getDOM());
            if (globalUserPropertyText != null) {
                return globalUserPropertyText;
            }
        } else {
            return this._text;
        }
        if (this._cellText != null) {
            return this._cellText;
        }
        return null;
    }

    public String getLabelHRef() {
        Type type;
        String text = null;
        if (this.isXPathLabel() && this._xpath != null && (type = TypePathExecuter.getInstance().getTypeForXPath(this._ownerType, this._xpath)) != null) {
            text = type.getStyle().getLeafLabelHRef();
        }
        return text;
    }

    public Type getType() {
        return this._ownerType;
    }

    public String getURL() {
        if (this._url != null && this._url.startsWith("${")) {
            return MathEvaluator.translateVar(this.getType().getDOM().getApplicationProperties(), this._url).toString();
        }
        return this._url;
    }

    public String getURLTarget() {
        return this._urlTarget;
    }

    public boolean hasFormula() {
        return this._formula != null;
    }

    public String getText() {
        return this._text;
    }

    public boolean isXPathLabel() {
        return this._isXPathLabel;
    }

    private void initButton(Type cellType) {
        this._isButton = true;
        this._text = cellType.getDirectChildValue("name");
        if (cellType.getChoosenType().isSimple()) {
            SimpleType actionType = (SimpleType)cellType.getChoosenType();
            this._labelType = actionType.getName();
            this._text = actionType.getValue();
        } else {
            Type classType = cellType.getChoosenType();
            this._labelType = classType.getDirectChildValue("className");
            this._ruleId = cellType.getDirectChildValue("ruleRef");
            if (this._labelType == null) {
                boolean isSelector = new Boolean(cellType.getDirectChildValue("isSelector"));
                if (isSelector) {
                    this._labelType = "selector";
                    this._text = "";
                } else {
                    this._labelType = "no name";
                }
            }
        }
    }

    private void initLabel(Type ownerType, Type cellType) {
        this._labelType = cellType.getDirectChildValue("labelType");
        if (this._labelType == null) {
            this._labelType = "label";
        }
        this._formulaExpression = cellType.getDirectChildValue("formulaExpression");
        if (this._formulaExpression != null && this._formulaExpression.length() > 0) {
            this.initFormulaExpression(ownerType, this._formulaExpression);
        } else {
            String xpath = cellType.getDirectChildValue("xpath");
            if (xpath != null && xpath.length() > 0) {
                this._isXPathLabel = true;
                this._xpath = xpath;
                this._text = null;
            }
        }
        this._url = cellType.getDirectChildValue("url");
        this._urlTarget = cellType.getDirectChildValue("target");
        this._isLabel = true;
        this._areaID = cellType.getDirectChildValue("areaID");
        Type labelFontType = cellType.getDirectChild("font");
        if (labelFontType != null) {
            this._fontName = labelFontType.getDirectChildValue("name");
            String fontSize = labelFontType.getDirectChildValue("size");
            if (fontSize != null && fontSize.length() > 0) {
                this._fontSize = Integer.valueOf(fontSize);
            }
            this._fontStyle = labelFontType.getDirectChildValue("style");
            this._cssElementStyle = labelFontType.getDirectChildValue("cssStyle");
            String fontColor = labelFontType.getDirectChildValue("color");
            if (fontColor != null && fontColor.length() > 0) {
                this._fontColor = TextTools.createColor(fontColor);
            }
        }
    }

    private void initFocusIndex(Type cellType) {
        String focusIndex = cellType.getDirectChildValue("focusIndex");
        if (focusIndex != null && focusIndex.length() > 0) {
            this.setFocusIndex(Integer.valueOf(focusIndex));
        }
    }

    public String getLabelFontName() {
        return this._fontName;
    }

    public String getLabelFontStyle() {
        return this._fontStyle;
    }

    public String getCSSStyle() {
        return this._cssStyle;
    }

    public void setCSSStyle(String style) {
        this._cssStyle = style;
    }

    public String getNlsKey() {
        return this._nlsKey;
    }

    public void setNlsKey(String _nlsKey) {
        this._nlsKey = _nlsKey;
    }

    public String getCSSElementStyle() {
        return this._cssElementStyle;
    }

    public String getAreaID() {
        return this._areaID;
    }

    public void setAreaID(String id) {
        this._areaID = id;
    }

    public int getLabelFontStyleAsInt() {
        if (this.getLabelFontStyle() == null) {
            return 0;
        }
        if (this.getLabelFontStyle().equals("bold")) {
            return 1;
        }
        if (this.getLabelFontStyle().equals("italic")) {
            return 2;
        }
        if (this.getLabelFontStyle().equals("normal")) {
            return 0;
        }
        if (this.getLabelFontStyle().equals("underline")) {
            return 1;
        }
        if (this.getLabelFontStyle().equals("bolditalic")) {
            return 3;
        }
        if (this.getLabelFontStyle().equals("ROMAN_BASELINE")) {
            return 0;
        }
        return 0;
    }

    public Integer getLabelFontSize() {
        return this._fontSize;
    }

    public int getLabelFontSizeAsInt() {
        if (this.getLabelFontSize() != null) {
            return this.getLabelFontSize();
        }
        return ((FontUIResource)UIManager.getDefaults().get("Label.font")).getSize();
    }

    public Color getLabelFontColor() {
        if (this._fontColor == null) {
            this._useDefaultFontColor = true;
            this._fontColor = this.getLabelType().equals("header") ? this.getType().getDOM().getGlobalDefinition().getHeaderTextColor() : (Color)UIManager.getDefaults().get("Label.foreground");
        }
        return this._fontColor;
    }

    public boolean useDefaultFontColor() {
        return this._useDefaultFontColor;
    }

    public boolean isButton() {
        return this._isButton;
    }

    public boolean isLabel() {
        return this._isLabel;
    }

    private void initFormulaExpression(Type ownerType, String formulaExpression) {
        VirtualType virtualType = new VirtualType(ownerType);
        FormulaExpression fe = ownerType.getDOM().lookupFormula(ownerType, formulaExpression);
        this._formula = fe == null ? new FormulaExpression(ownerType, formulaExpression, this, true) : fe;
        virtualType.setFormulaExpression(this._formula);
        XUIDefinition xuiDefinition = new XUIDefinition(virtualType, null);
        virtualType.setUIDefinition(xuiDefinition);
        this._text = "";
        this._ownerType = virtualType;
    }

    public TableCell clone(Type ownerType) {
        TableCell cell = null;
        try {
            Type type;
            cell = (TableCell)this.clone();
            cell._ownerType = ownerType;
            if (this._formulaExpression != null) {
                cell.initFormulaExpression(ownerType, this._formulaExpression);
            }
            if ((type = TableCell.evalXPathReferencedType(ownerType, this._text != null ? this._text : this._xpath, false)) != null) {
                type.setViewContextType(ownerType);
            }
            cell._refType = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cell;
    }

    private void convertDimension(String dimension) {
        this._origDimension = dimension;
        String xCoordinate = null;
        String yCoordinate = null;
        String rowSpan = null;
        String colSpan = null;
        String hAlign = null;
        String vAlign = null;
        StringTokenizer st = new StringTokenizer(dimension, ",");
        String[] values = new String[st.countTokens()];
        int countTokens = st.countTokens();
        for (int i = 0; i < countTokens; ++i) {
            String nextToken;
            values[i] = nextToken = st.nextToken();
        }
        for (int j = 0; j < values.length; ++j) {
            try {
                if (StringUtil.isFloatString(values[j])) {
                    int jValue;
                    int value;
                    Float floatValue = new Float(values[j]);
                    if (floatValue.floatValue() < 0.0f) {
                        xCoordinate = new StringBuffer().append("0:g(").append(floatValue).append(")").toString();
                        continue;
                    }
                    if (j == 0) {
                        this._colIndex = floatValue.intValue() + 1;
                        xCoordinate = new StringBuffer().append("").append(this._colIndex).toString();
                    }
                    if (j == 1) {
                        this._rowIndex = floatValue.intValue() + 1;
                        yCoordinate = new StringBuffer().append("").append(this._rowIndex).toString();
                        continue;
                    }
                    if (j == 2 || j == 4) {
                        value = Integer.valueOf(values[0].trim()) - 1;
                        jValue = Integer.valueOf(values[j].trim());
                        if (value < 0) {
                            if (value == -1) {
                                int width = jValue - value;
                                colSpan = new StringBuffer().append("").append(width).toString();
                                continue;
                            }
                            colSpan = new StringBuffer().append("").append(floatValue.intValue() + value).toString();
                            continue;
                        }
                        colSpan = new StringBuffer().append("").append(floatValue.intValue() - value).toString();
                        continue;
                    }
                    if (j != 3 && j != 5) continue;
                    value = Integer.valueOf(values[1].trim()) - 1;
                    jValue = Integer.valueOf(values[j].trim());
                    if (value < 0) {
                        if (value == -1) {
                            int height = jValue - value;
                            rowSpan = new StringBuffer().append("").append(height).toString();
                            continue;
                        }
                        rowSpan = new StringBuffer().append("").append(floatValue.intValue() + value).toString();
                        continue;
                    }
                    rowSpan = new StringBuffer().append("").append(floatValue.intValue() - value).toString();
                    continue;
                }
                if (j == 2) {
                    hAlign = values[j].trim();
                    continue;
                }
                if (j != 3) continue;
                vAlign = values[j].trim();
                continue;
            }
            catch (NumberFormatException e) {
                if (j == 2) {
                    hAlign = values[j].trim();
                    continue;
                }
                if (j != 3) continue;
                vAlign = values[j].trim();
            }
        }
        String internalDimension = null;
        if (xCoordinate != null && yCoordinate != null) {
            internalDimension = new StringBuffer().append(xCoordinate).append(",").append(yCoordinate).toString();
            if (colSpan != null && rowSpan != null) {
                this._rowSpan = Integer.parseInt(rowSpan);
                this._colSpan = Integer.parseInt(colSpan);
                internalDimension = new StringBuffer().append(internalDimension).append(",").append(colSpan).append(",").append(rowSpan).toString();
            }
            if (hAlign != null && vAlign != null) {
                internalDimension = new StringBuffer().append(internalDimension).append(",").append(hAlign).append(",").append(vAlign).toString();
            }
        }
        this._horizontalAlignment = hAlign;
        this._verticalAlignment = vAlign;
        this._dimension = internalDimension;
    }

    public Double calcMultiColWidth(List widths) {
        int cIndex = this._colIndex - 1;
        if (this.getColSpan() > 1) {
            double currentWidth = 0.0;
            double aWidth = 0.0;
            boolean hasPercentage = false;
            for (int i = 0; i < this.getColSpan(); ++i) {
                currentWidth = (Double)widths.get(cIndex + i);
                if (currentWidth < 1.0) {
                    hasPercentage = true;
                }
                aWidth += currentWidth;
            }
            if (hasPercentage && aWidth >= 1.0) {
                aWidth = 0.99;
            }
            return new Double(aWidth);
        }
        return (Double)widths.get(cIndex);
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getXPath() {
        return this._xpath;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" Label:");
        result.append(this.getLabel());
        result.append(" Xpath:");
        result.append(this.getXPath());
        result.append(" Location:");
        result.append(this._dimension);
        result.append(" OrigLocation:");
        result.append(this._origDimension);
        return result.toString();
    }

    private void setFocusIndex(Integer focusIndex) {
        this._focusIndex = focusIndex;
    }

    public Integer getFocusIndex() {
        return this._focusIndex;
    }

    public String getRuleId() {
        return this._ruleId;
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public int getColIndex() {
        return this._colIndex;
    }

    public int getRowSpan() {
        return this._rowSpan;
    }

    public int getColSpan() {
        return this._colSpan;
    }

    public String getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public String getHorizontalAlignment() {
        return this._horizontalAlignment;
    }

    @Override
    public int compareTo(TableCell tableCell) {
        int coordValueToCompare;
        int coordValue = Integer.parseInt(new StringBuffer().append(String.valueOf(this.getRowIndex())).append(String.valueOf(this.getColIndex())).toString());
        if (coordValue < (coordValueToCompare = Integer.parseInt(new StringBuffer().append(String.valueOf(tableCell.getRowIndex())).append(String.valueOf(tableCell.getColIndex())).toString()))) {
            return -1;
        }
        if (coordValue == coordValueToCompare) {
            return 0;
        }
        return 1;
    }

    public boolean isWorkflowCell() {
        return this.isButton() && this.getText() != null && this.getText().startsWith("${workflowID:");
    }

    public void release() {
        this._ownerType = null;
        this._refType = null;
        this._formula = null;
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((TableCell)x0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

